/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.sql.org.apache.calcite.plan;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.beam.repackaged.sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.sql.com.google.common.collect.Ordering;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelMultipleTrait;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTrait;
import org.apache.beam.repackaged.sql.org.apache.calcite.plan.RelTraitDef;

class RelCompositeTrait<T extends RelMultipleTrait>
implements RelTrait {
    private final RelTraitDef traitDef;
    private final T[] traits;

    private RelCompositeTrait(RelTraitDef traitDef, T[] traits) {
        this.traitDef = traitDef;
        this.traits = (RelMultipleTrait[])Objects.requireNonNull(traits);
        assert (Ordering.natural().isStrictlyOrdered(Arrays.asList((Comparable[])traits))) : Arrays.toString(traits);
        for (T trait : traits) {
            assert (trait.getTraitDef() == this.traitDef);
        }
    }

    static <T extends RelMultipleTrait> RelTrait of(RelTraitDef def, List<T> traitList) {
        if (traitList.isEmpty()) {
            return def.getDefault();
        }
        if (traitList.size() == 1) {
            return def.canonize((RelTrait)traitList.get(0));
        }
        RelMultipleTrait[] traits = traitList.toArray(new RelMultipleTrait[0]);
        for (int i = 0; i < traits.length; ++i) {
            traits[i] = def.canonize(traits[i]);
        }
        RelCompositeTrait compositeTrait = new RelCompositeTrait(def, traits);
        return def.canonize(compositeTrait);
    }

    @Override
    public RelTraitDef getTraitDef() {
        return this.traitDef;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.traits);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof RelCompositeTrait && Arrays.equals(this.traits, ((RelCompositeTrait)obj).traits);
    }

    @Override
    public String toString() {
        return Arrays.toString(this.traits);
    }

    @Override
    public boolean satisfies(RelTrait trait) {
        for (T t : this.traits) {
            if (!t.satisfies(trait)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void register(RelOptPlanner planner) {
    }

    public List<T> traitList() {
        return ImmutableList.copyOf(this.traits);
    }

    public T trait(int i) {
        return this.traits[i];
    }

    public int size() {
        return this.traits.length;
    }
}

