/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino;

import java.io.IOException;
import java.io.InputStream;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.CompileException;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.ErrorHandler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.Location;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.compiler.WarningHandler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.commons.nullanalysis.Nullable;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Descriptor;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.IClass;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.IClassLoader;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.JaninoOption;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Java;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Parser;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.Scanner;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.UnitCompiler;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.util.ClassFile;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.util.resource.Resource;
import org.apache.beam.sdks.java.extensions.sql.repackaged.org.codehaus.janino.util.resource.ResourceFinder;

public class JavaSourceIClassLoader
extends IClassLoader {
    private static final Logger LOGGER = Logger.getLogger(JavaSourceIClassLoader.class.getName());
    private ResourceFinder sourceFinder;
    @Nullable
    private String optionalCharacterEncoding;
    private EnumSet<JaninoOption> options = EnumSet.noneOf(JaninoOption.class);
    private final Set<UnitCompiler> unitCompilers = new HashSet<UnitCompiler>();
    @Nullable
    private ErrorHandler optionalCompileErrorHandler;
    @Nullable
    private WarningHandler optionalWarningHandler;

    public JavaSourceIClassLoader(ResourceFinder sourceFinder, @Nullable String optionalCharacterEncoding, @Nullable IClassLoader optionalParentIClassLoader) {
        super(optionalParentIClassLoader);
        this.sourceFinder = sourceFinder;
        this.optionalCharacterEncoding = optionalCharacterEncoding;
        super.postConstruct();
    }

    public Set<UnitCompiler> getUnitCompilers() {
        return this.unitCompilers;
    }

    public void setSourceFinder(ResourceFinder pathResourceFinder) {
        this.sourceFinder = pathResourceFinder;
    }

    public void setCharacterEncoding(@Nullable String optionalCharacterEncoding) {
        this.optionalCharacterEncoding = optionalCharacterEncoding;
    }

    public void setCompileErrorHandler(@Nullable ErrorHandler optionalCompileErrorHandler) {
        this.optionalCompileErrorHandler = optionalCompileErrorHandler;
    }

    public void setWarningHandler(@Nullable WarningHandler optionalWarningHandler) {
        this.optionalWarningHandler = optionalWarningHandler;
    }

    public EnumSet<JaninoOption> options() {
        return this.options;
    }

    public JavaSourceIClassLoader options(EnumSet<JaninoOption> options) {
        this.options = options;
        return this;
    }

    @Override
    @Nullable
    public IClass findIClass(String fieldDescriptor) throws ClassNotFoundException {
        IClass res;
        LOGGER.entering(null, "findIClass", fieldDescriptor);
        String className = Descriptor.toClassName(fieldDescriptor);
        LOGGER.log(Level.FINE, "className={0}", className);
        if (className.startsWith("java.")) {
            return null;
        }
        int idx = className.indexOf(36);
        String topLevelClassName = idx == -1 ? className : className.substring(0, idx);
        for (UnitCompiler uc : this.unitCompilers) {
            res = uc.findClass(topLevelClassName);
            if (res == null) continue;
            if (!className.equals(topLevelClassName) && (res = uc.findClass(className)) == null) {
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        try {
            UnitCompiler uc;
            Java.CompilationUnit cu = this.findCompilationUnit(className);
            if (cu == null) {
                return null;
            }
            uc = new UnitCompiler(cu, this).options(this.options);
            uc.setCompileErrorHandler(this.optionalCompileErrorHandler);
            uc.setWarningHandler(this.optionalWarningHandler);
            this.unitCompilers.add(uc);
            res = uc.findClass(className);
            if (res == null) {
                if (className.equals(topLevelClassName)) {
                    throw new CompileException("Compilation unit '" + className + "' does not declare a class with the same name", (Location)null);
                }
                return null;
            }
            this.defineIClass(res);
            return res;
        }
        catch (IOException e) {
            throw new ClassNotFoundException("Parsing compilation unit '" + className + "'", e);
        }
        catch (CompileException e) {
            throw new ClassNotFoundException("Parsing compilation unit '" + className + "'", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    protected Java.CompilationUnit findCompilationUnit(String className) throws IOException, CompileException {
        Resource sourceResource = this.sourceFinder.findResource(ClassFile.getSourceResourceName(className));
        LOGGER.log(Level.FINE, "sourceResource={0}", sourceResource);
        if (sourceResource == null) {
            return null;
        }
        InputStream inputStream = sourceResource.open();
        try {
            Scanner scanner = new Scanner(sourceResource.getFileName(), inputStream, this.optionalCharacterEncoding);
            Parser parser = new Parser(scanner);
            parser.setWarningHandler(this.optionalWarningHandler);
            Java.CompilationUnit compilationUnit = parser.parseCompilationUnit();
            return compilationUnit;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException ex) {}
        }
    }
}

