/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql;

import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlEnv;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamEnumerableConverter;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.meta.store.MetaStore;
import org.apache.beam.sdk.options.PipelineOptions;

@Experimental
public class BeamSqlCli {
    private BeamSqlEnv env;
    private MetaStore metaStore;

    public BeamSqlCli metaStore(MetaStore metaStore) {
        return this.metaStore(metaStore, false);
    }

    public BeamSqlCli metaStore(MetaStore metaStore, boolean autoLoadUdfUdaf) {
        this.metaStore = metaStore;
        BeamSqlEnv.BeamSqlEnvBuilder builder = BeamSqlEnv.builder(metaStore);
        if (autoLoadUdfUdaf) {
            builder.autoLoadUserDefinedFunctions();
        }
        this.env = builder.build();
        return this;
    }

    public MetaStore getMetaStore() {
        return this.metaStore;
    }

    public String explainQuery(String sqlString) throws ParseException {
        return this.env.explain(sqlString);
    }

    public void execute(String sqlString) throws ParseException {
        if (this.env.isDdl(sqlString)) {
            this.env.executeDdl(sqlString);
        } else {
            PipelineOptions options = BeamEnumerableConverter.createPipelineOptions(this.env.getPipelineOptions());
            options.setJobName("BeamPlanCreator");
            Pipeline pipeline = Pipeline.create((PipelineOptions)options);
            BeamSqlRelUtils.toPCollection(pipeline, this.env.parseQuery(sqlString));
            pipeline.run();
        }
    }
}

