/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.HashMultimap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Multimap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Ordering;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptCost;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano.RelSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano.RelSubset;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano.VolcanoPlannerPhase;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.volcano.VolcanoRuleMatch;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.RelNodes;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.ChunkList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

class RuleQueue {
    private static final Logger LOGGER = CalciteTrace.getPlannerTracer();
    private static final Set<String> ALL_RULES = ImmutableSet.of("<ALL RULES>");
    private static final double ONE_MINUS_EPSILON = RuleQueue.computeOneMinusEpsilon();
    final Map<RelSubset, Double> subsetImportances = new HashMap<RelSubset, Double>();
    final Set<RelSubset> boostedSubsets = new HashSet<RelSubset>();
    final Map<VolcanoPlannerPhase, PhaseMatchList> matchListMap = new EnumMap<VolcanoPlannerPhase, PhaseMatchList>(VolcanoPlannerPhase.class);
    private static final Comparator<VolcanoRuleMatch> MATCH_COMPARATOR = new RuleMatchImportanceComparator();
    private final VolcanoPlanner planner;
    private final Ordering<RelSubset> relImportanceOrdering = Ordering.from(new RelImportanceComparator());
    private final Map<VolcanoPlannerPhase, Set<String>> phaseRuleMapping;

    RuleQueue(VolcanoPlanner planner) {
        this.planner = planner;
        this.phaseRuleMapping = new EnumMap<VolcanoPlannerPhase, Set<String>>(VolcanoPlannerPhase.class);
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            this.phaseRuleMapping.put(phase, new HashSet());
        }
        planner.getPhaseRuleMappingInitializer().initialize(this.phaseRuleMapping);
        for (VolcanoPlannerPhase phase : VolcanoPlannerPhase.values()) {
            if (this.phaseRuleMapping.get((Object)phase).isEmpty()) {
                this.phaseRuleMapping.put(phase, ALL_RULES);
            }
            PhaseMatchList matchList = new PhaseMatchList(phase);
            this.matchListMap.put(phase, matchList);
        }
    }

    public void clear() {
        this.subsetImportances.clear();
        this.boostedSubsets.clear();
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            matchList.clear();
        }
    }

    public void phaseCompleted(VolcanoPlannerPhase phase) {
        this.matchListMap.get((Object)phase).clear();
    }

    public double getImportance(RelSet set) {
        double importance = 0.0;
        for (RelSubset subset : set.subsets) {
            importance = Math.max(importance, this.getImportance(subset));
        }
        return importance;
    }

    public void recompute(RelSubset subset, boolean force) {
        Double previousImportance = this.subsetImportances.get(subset);
        if (previousImportance == null) {
            if (!force) {
                return;
            }
            previousImportance = Double.NEGATIVE_INFINITY;
        }
        double importance = this.computeImportance(subset);
        if (previousImportance == importance) {
            return;
        }
        this.updateImportance(subset, importance);
    }

    public void recompute(RelSubset subset) {
        this.recompute(subset, false);
    }

    public void boostImportance(Collection<RelSubset> subsets, double factor) {
        LOGGER.trace("boostImportance({}, {})", (Object)factor, subsets);
        ArrayList<RelSubset> boostRemovals = new ArrayList<RelSubset>();
        Iterator<RelSubset> iter = this.boostedSubsets.iterator();
        while (iter.hasNext()) {
            RelSubset subset = iter.next();
            if (subsets.contains(subset)) continue;
            iter.remove();
            boostRemovals.add(subset);
        }
        boostRemovals.sort(new Comparator<RelSubset>(){

            @Override
            public int compare(RelSubset o1, RelSubset o2) {
                int o2children;
                int o1children = this.countChildren(o1);
                int c = Integer.compare(o1children, o2children = this.countChildren(o2));
                if (c == 0) {
                    c = Integer.compare(o1.getId(), o2.getId());
                }
                return c;
            }

            private int countChildren(RelSubset subset) {
                int count = 0;
                for (RelNode rel : subset.getRels()) {
                    count += rel.getInputs().size();
                }
                return count;
            }
        });
        for (RelSubset subset : boostRemovals) {
            subset.propagateBoostRemoval(this.planner);
        }
        for (RelSubset subset : subsets) {
            double importance = this.subsetImportances.get(subset);
            this.updateImportance(subset, Math.min(ONE_MINUS_EPSILON, importance * factor));
            subset.boosted = true;
            this.boostedSubsets.add(subset);
        }
    }

    void updateImportance(RelSubset subset, Double importance) {
        this.subsetImportances.put(subset, importance);
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            Multimap<RelSubset, VolcanoRuleMatch> relMatchMap = matchList.matchMap;
            if (!relMatchMap.containsKey(subset)) continue;
            for (VolcanoRuleMatch match : relMatchMap.get(subset)) {
                match.clearCachedImportance();
            }
        }
    }

    double getImportance(RelSubset rel) {
        assert (rel != null);
        double importance = 0.0;
        RelSet set = this.planner.getSet(rel);
        assert (set != null);
        for (RelSubset subset2 : set.subsets) {
            Double d = this.subsetImportances.get(subset2);
            if (d == null) continue;
            double subsetImportance = d;
            if (subset2 != rel) {
                subsetImportance /= 2.0;
            }
            if (!(subsetImportance > importance)) continue;
            importance = subsetImportance;
        }
        return importance;
    }

    void addMatch(VolcanoRuleMatch match) {
        String matchName = match.toString();
        for (PhaseMatchList matchList : this.matchListMap.values()) {
            String ruleDescription;
            Set<String> phaseRuleSet;
            if (!matchList.names.add(matchName) || (phaseRuleSet = this.phaseRuleMapping.get((Object)matchList.phase)) != ALL_RULES && !phaseRuleSet.contains(ruleDescription = match.getRule().toString())) continue;
            LOGGER.trace("{} Rule-match queued: {}", (Object)matchList.phase.toString(), (Object)matchName);
            matchList.list.add(match);
            matchList.matchMap.put(this.planner.getSubset(match.rels[0]), match);
        }
    }

    double computeImportance(RelSubset subset) {
        double importance;
        if (subset == this.planner.root) {
            importance = 1.0;
        } else {
            RelMetadataQuery mq = subset.getCluster().getMetadataQuery();
            importance = 0.0;
            for (RelSubset parent : subset.getParentSubsets(this.planner)) {
                double childImportance = this.computeImportanceOfChild(mq, subset, parent);
                importance = Math.max(importance, childImportance);
            }
        }
        LOGGER.trace("Importance of [{}] is {}", (Object)subset, (Object)importance);
        return importance;
    }

    private void dump() {
        if (LOGGER.isTraceEnabled()) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            this.dump(pw);
            pw.flush();
            LOGGER.trace(sw.toString());
        }
    }

    private void dump(PrintWriter pw) {
        this.planner.dump(pw);
        pw.print("Importances: {");
        for (RelSubset subset : this.relImportanceOrdering.sortedCopy(this.subsetImportances.keySet())) {
            pw.print(" " + subset.toString() + "=" + this.subsetImportances.get(subset));
        }
        pw.println("}");
    }

    VolcanoRuleMatch popMatch(VolcanoPlannerPhase phase) {
        VolcanoRuleMatch match;
        this.dump();
        PhaseMatchList phaseMatchList = this.matchListMap.get((Object)phase);
        if (phaseMatchList == null) {
            throw new AssertionError((Object)("Used match list for phase " + (Object)((Object)phase) + " after phase complete"));
        }
        List<VolcanoRuleMatch> matchList = phaseMatchList.list;
        while (true) {
            if (matchList.isEmpty()) {
                return null;
            }
            if (LOGGER.isTraceEnabled()) {
                matchList.sort(MATCH_COMPARATOR);
                match = matchList.remove(0);
                StringBuilder b = new StringBuilder();
                b.append("Sorted rule queue:");
                for (VolcanoRuleMatch match2 : matchList) {
                    double importance = match2.computeImportance();
                    b.append("\n");
                    b.append(match2);
                    b.append(" importance ");
                    b.append(importance);
                }
                LOGGER.trace(b.toString());
            } else {
                match = null;
                int bestPos = -1;
                int i = -1;
                for (VolcanoRuleMatch match2 : matchList) {
                    ++i;
                    if (match != null && MATCH_COMPARATOR.compare(match2, match) >= 0) continue;
                    bestPos = i;
                    match = match2;
                }
                match = matchList.remove(bestPos);
            }
            if (!this.skipMatch(match)) break;
            LOGGER.debug("Skip match: {}", (Object)match);
        }
        match.recomputeDigest();
        phaseMatchList.matchMap.remove(this.planner.getSubset(match.rels[0]), match);
        LOGGER.debug("Pop match: {}", (Object)match);
        return match;
    }

    private boolean skipMatch(VolcanoRuleMatch match) {
        for (RelNode rel : match.rels) {
            Double importance = this.planner.relImportances.get(rel);
            if (importance == null || importance != 0.0) continue;
            return true;
        }
        ArrayDeque<RelSubset> subsets = new ArrayDeque<RelSubset>();
        try {
            this.checkDuplicateSubsets(subsets, match.rule.getOperand(), match.rels);
        }
        catch (Util.FoundOne e) {
            return true;
        }
        return false;
    }

    private void checkDuplicateSubsets(Deque<RelSubset> subsets, RelOptRuleOperand operand, RelNode[] rels) {
        RelSubset subset = this.planner.getSubset(rels[operand.ordinalInRule]);
        if (subsets.contains(subset)) {
            throw Util.FoundOne.NULL;
        }
        if (!operand.getChildOperands().isEmpty()) {
            subsets.push(subset);
            for (RelOptRuleOperand childOperand : operand.getChildOperands()) {
                this.checkDuplicateSubsets(subsets, childOperand, rels);
            }
            RelSubset x = subsets.pop();
            assert (x == subset);
        }
    }

    private double computeImportanceOfChild(RelMetadataQuery mq, RelSubset child, RelSubset parent) {
        double parentCost;
        double parentImportance = this.getImportance(parent);
        double childCost = this.toDouble(this.planner.getCost(child, mq));
        double alpha = childCost / (parentCost = this.toDouble(this.planner.getCost(parent, mq)));
        if (alpha >= 1.0) {
            alpha = 0.99;
        }
        double importance = parentImportance * alpha;
        LOGGER.trace("Importance of [{}] to its parent [{}] is {} (parent importance={}, child cost={}, parent cost={})", new Object[]{child, parent, importance, parentImportance, childCost, parentCost});
        return importance;
    }

    private double toDouble(RelOptCost cost) {
        if (cost.isInfinite()) {
            return 1.0E30;
        }
        return cost.getCpu() + cost.getRows() + cost.getIo();
    }

    private static double computeOneMinusEpsilon() {
        double d0;
        double d = 0.0;
        do {
            d0 = d;
        } while ((d = (d + 1.0) / 2.0) != 1.0);
        return d0;
    }

    private static class PhaseMatchList {
        final VolcanoPlannerPhase phase;
        final List<VolcanoRuleMatch> list = new ChunkList<VolcanoRuleMatch>();
        final Set<String> names = new HashSet<String>();
        final Multimap<RelSubset, VolcanoRuleMatch> matchMap = HashMultimap.create();

        PhaseMatchList(VolcanoPlannerPhase phase) {
            this.phase = phase;
        }

        void clear() {
            this.list.clear();
            this.names.clear();
            this.matchMap.clear();
        }
    }

    private static class RuleMatchImportanceComparator
    implements Comparator<VolcanoRuleMatch> {
        private RuleMatchImportanceComparator() {
        }

        @Override
        public int compare(VolcanoRuleMatch match1, VolcanoRuleMatch match2) {
            double imp2;
            double imp1 = match1.getImportance();
            int c = Double.compare(imp1, imp2 = match2.getImportance());
            if (c != 0) {
                return -c;
            }
            c = match1.rule.getClass().getName().compareTo(match2.rule.getClass().getName());
            if (c != 0) {
                return -c;
            }
            return -RelNodes.compareRels(match1.rels, match2.rels);
        }
    }

    private class RelImportanceComparator
    implements Comparator<RelSubset> {
        private RelImportanceComparator() {
        }

        @Override
        public int compare(RelSubset rel1, RelSubset rel2) {
            double imp1 = RuleQueue.this.getImportance(rel1);
            double imp2 = RuleQueue.this.getImportance(rel2);
            int c = Double.compare(imp2, imp1);
            if (c == 0) {
                c = rel1.getId() - rel2.getId();
            }
            return c;
        }
    }
}

