/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type;

import java.util.AbstractList;
import java.util.List;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.ExplicitOperatorBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCallBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlCollation;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.ExplicitReturnTypeInference;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.MatchReturnTypeInference;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.OrdinalReturnTypeInference;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlReturnTypeInferenceChain;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeTransform;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeTransformCascade;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeTransforms;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Static;

public abstract class ReturnTypes {
    public static final SqlReturnTypeInference ARG0 = new OrdinalReturnTypeInference(0);
    public static final SqlReturnTypeInference ARG0_NULLABLE_VARYING = ReturnTypes.cascade(ARG0, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING);
    public static final SqlReturnTypeInference ARG0_NULLABLE = ReturnTypes.cascade(ARG0, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_FORCE_NULLABLE = ReturnTypes.cascade(ARG0, SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference ARG0_INTERVAL = new MatchReturnTypeInference(0, SqlTypeFamily.DATETIME_INTERVAL.getTypeNames());
    public static final SqlReturnTypeInference ARG0_INTERVAL_NULLABLE = ReturnTypes.cascade(ARG0_INTERVAL, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG0_NULLABLE_IF_EMPTY = new OrdinalReturnTypeInference(0){

        @Override
        public RelDataType inferReturnType(SqlOperatorBinding opBinding) {
            RelDataType type = super.inferReturnType(opBinding);
            if (opBinding.getGroupCount() == 0 || opBinding.hasFilter()) {
                return opBinding.getTypeFactory().createTypeWithNullability(type, true);
            }
            return type;
        }
    };
    public static final SqlReturnTypeInference ARG1 = new OrdinalReturnTypeInference(1);
    public static final SqlReturnTypeInference ARG1_NULLABLE = ReturnTypes.cascade(ARG1, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference ARG2 = new OrdinalReturnTypeInference(2);
    public static final SqlReturnTypeInference ARG2_NULLABLE = ReturnTypes.cascade(ARG2, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN = ReturnTypes.explicit(SqlTypeName.BOOLEAN);
    public static final SqlReturnTypeInference BOOLEAN_NULLABLE = ReturnTypes.cascade(BOOLEAN, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN_NULLABLE_OPTIMIZED = opBinding -> {
        int n = opBinding.getOperandCount();
        RelDataType type1 = null;
        for (int i = 0; i < n && !(type1 = opBinding.getOperandType(i)).isNullable(); ++i) {
        }
        return type1;
    };
    public static final SqlReturnTypeInference BOOLEAN_FORCE_NULLABLE = ReturnTypes.cascade(BOOLEAN, SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference BOOLEAN_NOT_NULL = ReturnTypes.cascade(BOOLEAN, SqlTypeTransforms.TO_NOT_NULLABLE);
    public static final SqlReturnTypeInference DATE = ReturnTypes.explicit(SqlTypeName.DATE);
    public static final SqlReturnTypeInference TIME = ReturnTypes.explicit(SqlTypeName.TIME, 0);
    public static final SqlReturnTypeInference TIME_NULLABLE = ReturnTypes.cascade(TIME, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference DOUBLE = ReturnTypes.explicit(SqlTypeName.DOUBLE);
    public static final SqlReturnTypeInference DOUBLE_NULLABLE = ReturnTypes.cascade(DOUBLE, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference INTEGER = ReturnTypes.explicit(SqlTypeName.INTEGER);
    public static final SqlReturnTypeInference INTEGER_NULLABLE = ReturnTypes.cascade(INTEGER, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference BIGINT = ReturnTypes.explicit(SqlTypeName.BIGINT);
    public static final SqlReturnTypeInference BIGINT_FORCE_NULLABLE = ReturnTypes.cascade(BIGINT, SqlTypeTransforms.FORCE_NULLABLE);
    public static final SqlReturnTypeInference BIGINT_NULLABLE = ReturnTypes.cascade(BIGINT, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference VARCHAR_2000 = ReturnTypes.explicit(SqlTypeName.VARCHAR, 2000);
    public static final SqlReturnTypeInference HISTOGRAM = ReturnTypes.explicit(SqlTypeName.VARBINARY, 8);
    public static final SqlReturnTypeInference CURSOR = ReturnTypes.explicit(SqlTypeName.CURSOR);
    public static final SqlReturnTypeInference COLUMN_LIST = ReturnTypes.explicit(SqlTypeName.COLUMN_LIST);
    public static final SqlReturnTypeInference LEAST_RESTRICTIVE = opBinding -> opBinding.getTypeFactory().leastRestrictive(opBinding.collectOperandTypes());
    public static final SqlReturnTypeInference MULTISET = opBinding -> {
        ExplicitOperatorBinding newBinding = new ExplicitOperatorBinding(opBinding, (List<RelDataType>)new AbstractList<RelDataType>(){

            @Override
            public RelDataType get(int index) {
                RelDataType type = opBinding.getOperandType(index).getComponentType();
                assert (type != null);
                return type;
            }

            @Override
            public int size() {
                return opBinding.getOperandCount();
            }
        });
        RelDataType biggestElementType = LEAST_RESTRICTIVE.inferReturnType(newBinding);
        return opBinding.getTypeFactory().createMultisetType(biggestElementType, -1L);
    };
    public static final SqlReturnTypeInference TO_MULTISET = ReturnTypes.cascade(ARG0, SqlTypeTransforms.TO_MULTISET);
    public static final SqlReturnTypeInference MULTISET_ELEMENT_NULLABLE = ReturnTypes.cascade(MULTISET, SqlTypeTransforms.TO_MULTISET_ELEMENT_TYPE);
    public static final SqlReturnTypeInference MULTISET_NULLABLE = ReturnTypes.cascade(MULTISET, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference MULTISET_PROJECT_ONLY = ReturnTypes.cascade(MULTISET, SqlTypeTransforms.ONLY_COLUMN);
    public static final SqlReturnTypeInference INTEGER_QUOTIENT_NULLABLE = ReturnTypes.chain(ARG0_INTERVAL_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_SCALE0 = opBinding -> {
        RelDataType type1 = opBinding.getOperandType(0);
        if (SqlTypeUtil.isDecimal(type1)) {
            if (type1.getScale() == 0) {
                return type1;
            }
            int p = type1.getPrecision();
            RelDataType ret = opBinding.getTypeFactory().createSqlType(SqlTypeName.DECIMAL, p, 0);
            if (type1.isNullable()) {
                ret = opBinding.getTypeFactory().createTypeWithNullability(ret, true);
            }
            return ret;
        }
        return null;
    };
    public static final SqlReturnTypeInference ARG0_OR_EXACT_NO_SCALE = ReturnTypes.chain(DECIMAL_SCALE0, ARG0);
    public static final SqlReturnTypeInference DECIMAL_PRODUCT = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        return typeFactory.createDecimalProduct(type1, type2);
    };
    public static final SqlReturnTypeInference DECIMAL_PRODUCT_NULLABLE = ReturnTypes.cascade(DECIMAL_PRODUCT, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference PRODUCT_NULLABLE = ReturnTypes.chain(DECIMAL_PRODUCT_NULLABLE, ARG0_INTERVAL_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_QUOTIENT = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        return typeFactory.createDecimalQuotient(type1, type2);
    };
    public static final SqlReturnTypeInference DECIMAL_QUOTIENT_NULLABLE = ReturnTypes.cascade(DECIMAL_QUOTIENT, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference QUOTIENT_NULLABLE = ReturnTypes.chain(DECIMAL_QUOTIENT_NULLABLE, ARG0_INTERVAL_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DECIMAL_SUM = opBinding -> {
        RelDataType type1 = opBinding.getOperandType(0);
        RelDataType type2 = opBinding.getOperandType(1);
        if (SqlTypeUtil.isExactNumeric(type1) && SqlTypeUtil.isExactNumeric(type2) && (SqlTypeUtil.isDecimal(type1) || SqlTypeUtil.isDecimal(type2))) {
            int p1 = type1.getPrecision();
            int p2 = type2.getPrecision();
            int s1 = type1.getScale();
            int s2 = type2.getScale();
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            int scale = Math.max(s1, s2);
            RelDataTypeSystem typeSystem = typeFactory.getTypeSystem();
            assert (scale <= typeSystem.getMaxNumericScale());
            int precision = Math.max(p1 - s1, p2 - s2) + scale + 1;
            precision = Math.min(precision, typeSystem.getMaxNumericPrecision());
            assert (precision > 0);
            return typeFactory.createSqlType(SqlTypeName.DECIMAL, precision, scale);
        }
        return null;
    };
    public static final SqlReturnTypeInference DECIMAL_SUM_NULLABLE = ReturnTypes.cascade(DECIMAL_SUM, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference NULLABLE_SUM = new SqlReturnTypeInferenceChain(DECIMAL_SUM_NULLABLE, LEAST_RESTRICTIVE);
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION = opBinding -> {
        boolean containsAnyType;
        RelDataType argType0 = opBinding.getOperandType(0);
        RelDataType argType1 = opBinding.getOperandType(1);
        boolean bl = containsAnyType = argType0.getSqlTypeName() == SqlTypeName.ANY || argType1.getSqlTypeName() == SqlTypeName.ANY;
        if (!(containsAnyType || SqlTypeUtil.inCharOrBinaryFamilies(argType0) && SqlTypeUtil.inCharOrBinaryFamilies(argType1))) {
            Preconditions.checkArgument(SqlTypeUtil.sameNamedType(argType0, argType1));
        }
        SqlCollation pickedCollation = null;
        if (!containsAnyType && SqlTypeUtil.inCharFamily(argType0)) {
            if (!SqlTypeUtil.isCharTypeComparable(opBinding.collectOperandTypes().subList(0, 2))) {
                throw opBinding.newError(Static.RESOURCE.typeNotComparable(argType0.getFullTypeString(), argType1.getFullTypeString()));
            }
            pickedCollation = SqlCollation.getCoercibilityDyadicOperator(argType0.getCollation(), argType1.getCollation());
            assert (null != pickedCollation);
        }
        SqlTypeName typeName = argType0.getSqlTypeName();
        if (SqlTypeUtil.isBoundedVariableWidth(argType1)) {
            typeName = argType1.getSqlTypeName();
        }
        long x = (long)argType0.getPrecision() + (long)argType1.getPrecision();
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataTypeSystem typeSystem = typeFactory.getTypeSystem();
        int typePrecision = argType0.getPrecision() == -1 || argType1.getPrecision() == -1 || x > (long)typeSystem.getMaxPrecision(typeName) ? -1 : (int)x;
        RelDataType ret = typeFactory.createSqlType(typeName, typePrecision);
        if (null != pickedCollation) {
            RelDataType pickedType;
            if (argType0.getCollation().equals(pickedCollation)) {
                pickedType = argType0;
            } else if (argType1.getCollation().equals(pickedCollation)) {
                pickedType = argType1;
            } else {
                throw new AssertionError((Object)"should never come here");
            }
            ret = typeFactory.createTypeWithCharsetAndCollation(ret, pickedType.getCharset(), pickedType.getCollation());
        }
        return ret;
    };
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION_NULLABLE_VARYING = ReturnTypes.cascade(DYADIC_STRING_SUM_PRECISION, SqlTypeTransforms.TO_NULLABLE, SqlTypeTransforms.TO_VARYING);
    public static final SqlReturnTypeInference DYADIC_STRING_SUM_PRECISION_NULLABLE = ReturnTypes.cascade(DYADIC_STRING_SUM_PRECISION, SqlTypeTransforms.TO_NULLABLE);
    public static final SqlReturnTypeInference SCOPE = opBinding -> {
        SqlCallBinding callBinding = (SqlCallBinding)opBinding;
        return callBinding.getValidator().getNamespace(callBinding.getCall()).getRowType();
    };
    public static final SqlReturnTypeInference MULTISET_PROJECT0 = opBinding -> {
        assert (opBinding.getOperandCount() == 1);
        RelDataType recordMultisetType = opBinding.getOperandType(0);
        RelDataType multisetType = recordMultisetType.getComponentType();
        assert (multisetType != null) : "expected a multiset type: " + recordMultisetType;
        List<RelDataTypeField> fields = multisetType.getFieldList();
        assert (fields.size() > 0);
        RelDataType firstColType = fields.get(0).getType();
        return opBinding.getTypeFactory().createMultisetType(firstColType, -1L);
    };
    public static final SqlReturnTypeInference MULTISET_RECORD = opBinding -> {
        assert (opBinding.getOperandCount() == 1);
        RelDataType multisetType = opBinding.getOperandType(0);
        RelDataType componentType = multisetType.getComponentType();
        assert (componentType != null) : "expected a multiset type: " + multisetType;
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.builder().add(SqlUtil.deriveAliasFromOrdinal(0), componentType).build();
        return typeFactory.createMultisetType(type, -1L);
    };
    public static final SqlReturnTypeInference RECORD_TO_SCALAR = opBinding -> {
        assert (opBinding.getOperandCount() == 1);
        RelDataType recordType = opBinding.getOperandType(0);
        boolean isStruct = recordType.isStruct();
        int fieldCount = recordType.getFieldCount();
        assert (isStruct && fieldCount == 1);
        RelDataTypeField fieldType = recordType.getFieldList().get(0);
        assert (fieldType != null) : "expected a record type with one field: " + recordType;
        RelDataType firstColType = fieldType.getType();
        return opBinding.getTypeFactory().createTypeWithNullability(firstColType, true);
    };
    public static final SqlReturnTypeInference AGG_SUM = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType type = typeFactory.getTypeSystem().deriveSumType(typeFactory, opBinding.getOperandType(0));
        if (opBinding.getGroupCount() == 0 || opBinding.hasFilter()) {
            return typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    };
    public static final SqlReturnTypeInference AGG_SUM_EMPTY_IS_ZERO = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType sumType = typeFactory.getTypeSystem().deriveSumType(typeFactory, opBinding.getOperandType(0));
        return typeFactory.createTypeWithNullability(sumType, false);
    };
    public static final SqlReturnTypeInference FRACTIONAL_RANK = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return typeFactory.getTypeSystem().deriveFractionalRankType(typeFactory);
    };
    public static final SqlReturnTypeInference RANK = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        return typeFactory.getTypeSystem().deriveRankType(typeFactory);
    };
    public static final SqlReturnTypeInference AVG_AGG_FUNCTION = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType relDataType = typeFactory.getTypeSystem().deriveAvgAggType(typeFactory, opBinding.getOperandType(0));
        if (opBinding.getGroupCount() == 0 || opBinding.hasFilter()) {
            return typeFactory.createTypeWithNullability(relDataType, true);
        }
        return relDataType;
    };
    public static final SqlReturnTypeInference COVAR_REGR_FUNCTION = opBinding -> {
        RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
        RelDataType relDataType = typeFactory.getTypeSystem().deriveCovarType(typeFactory, opBinding.getOperandType(0), opBinding.getOperandType(1));
        if (opBinding.getGroupCount() == 0 || opBinding.hasFilter()) {
            return typeFactory.createTypeWithNullability(relDataType, true);
        }
        return relDataType;
    };

    private ReturnTypes() {
    }

    public static SqlReturnTypeInferenceChain chain(SqlReturnTypeInference ... rules) {
        return new SqlReturnTypeInferenceChain(rules);
    }

    public static SqlTypeTransformCascade cascade(SqlReturnTypeInference rule, SqlTypeTransform ... transforms) {
        return new SqlTypeTransformCascade(rule, transforms);
    }

    public static ExplicitReturnTypeInference explicit(RelProtoDataType protoType) {
        return new ExplicitReturnTypeInference(protoType);
    }

    public static ExplicitReturnTypeInference explicit(RelDataType type) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(type));
    }

    public static ExplicitReturnTypeInference explicit(SqlTypeName typeName) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(typeName, false));
    }

    public static ExplicitReturnTypeInference explicit(SqlTypeName typeName, int precision) {
        return ReturnTypes.explicit(RelDataTypeImpl.proto(typeName, precision, false));
    }
}

