/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.rules;

import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.BoundType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableList;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableMap;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableRangeSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.ImmutableSortedSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.Range;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.RangeSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.com.google.common.collect.TreeRangeSet;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.Filter;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.core.RelFactories;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexCall;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexNode;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexShuttle;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexUtil;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rex.RexVisitorImpl;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.runtime.SqlFunctions;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlBinaryOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlKind;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilder;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.tools.RelBuilderFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Bug;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.DateString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.TimestampString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.TimestampWithTimeZoneString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.util.Util;

public abstract class DateRangeRules {
    private static final Predicate<Filter> FILTER_PREDICATE = filter -> {
        ExtractFinder finder = (ExtractFinder)ExtractFinder.THREAD_INSTANCES.get();
        Throwable throwable = null;
        try {
            assert (finder.timeUnits.isEmpty() && finder.opKinds.isEmpty()) : "previous user did not clean up";
            filter.getCondition().accept(finder);
            boolean bl = finder.timeUnits.contains((Object)TimeUnitRange.YEAR) || finder.opKinds.contains((Object)SqlKind.FLOOR) || finder.opKinds.contains((Object)SqlKind.CEIL);
            return bl;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (finder != null) {
                DateRangeRules.$closeResource(throwable, finder);
            }
        }
    };
    public static final RelOptRule FILTER_INSTANCE = new FilterDateRangeRule(RelFactories.LOGICAL_BUILDER);
    private static final Map<TimeUnitRange, Integer> TIME_UNIT_CODES = ImmutableMap.builder().put(TimeUnitRange.YEAR, 1).put(TimeUnitRange.MONTH, 2).put(TimeUnitRange.DAY, 5).put(TimeUnitRange.HOUR, 10).put(TimeUnitRange.MINUTE, 12).put(TimeUnitRange.SECOND, 13).put(TimeUnitRange.MILLISECOND, 14).build();
    private static final Map<TimeUnitRange, TimeUnitRange> TIME_UNIT_PARENTS = ImmutableMap.builder().put(TimeUnitRange.MONTH, TimeUnitRange.YEAR).put(TimeUnitRange.DAY, TimeUnitRange.MONTH).put(TimeUnitRange.HOUR, TimeUnitRange.DAY).put(TimeUnitRange.MINUTE, TimeUnitRange.HOUR).put(TimeUnitRange.SECOND, TimeUnitRange.MINUTE).put(TimeUnitRange.MILLISECOND, TimeUnitRange.SECOND).put(TimeUnitRange.MICROSECOND, TimeUnitRange.SECOND).build();

    private DateRangeRules() {
    }

    static ImmutableSortedSet<TimeUnitRange> extractTimeUnits(RexNode e) {
        try (ExtractFinder finder = (ExtractFinder)ExtractFinder.THREAD_INSTANCES.get();){
            assert (finder.timeUnits.isEmpty() && finder.opKinds.isEmpty()) : "previous user did not clean up";
            e.accept(finder);
            ImmutableSortedSet<TimeUnitRange> immutableSortedSet = ImmutableSortedSet.copyOf(finder.timeUnits);
            return immutableSortedSet;
        }
    }

    @VisibleForTesting
    public static RexNode replaceTimeUnits(RexBuilder rexBuilder, RexNode e, String timeZone) {
        ImmutableSet timeUnits = DateRangeRules.extractTimeUnits(e);
        if (!timeUnits.contains((Object)TimeUnitRange.YEAR)) {
            timeUnits = ((ImmutableSortedSet.Builder)((ImmutableSortedSet.Builder)ImmutableSortedSet.naturalOrder().addAll((Iterable)timeUnits)).add((Object)TimeUnitRange.YEAR)).build();
        }
        HashMap<RexNode, RangeSet<Calendar>> operandRanges = new HashMap<RexNode, RangeSet<Calendar>>();
        for (TimeUnitRange timeUnit : timeUnits) {
            e = e.accept(new ExtractShuttle(rexBuilder, timeUnit, (Map<RexNode, RangeSet<Calendar>>)operandRanges, (ImmutableSortedSet<TimeUnitRange>)timeUnits, timeZone));
        }
        return e;
    }

    @VisibleForTesting
    static class ExtractShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;
        private final TimeUnitRange timeUnit;
        private final Map<RexNode, RangeSet<Calendar>> operandRanges;
        private final Deque<RexCall> calls = new ArrayDeque<RexCall>();
        private final ImmutableSortedSet<TimeUnitRange> timeUnitRanges;
        private final String timeZone;

        @VisibleForTesting
        ExtractShuttle(RexBuilder rexBuilder, TimeUnitRange timeUnit, Map<RexNode, RangeSet<Calendar>> operandRanges, ImmutableSortedSet<TimeUnitRange> timeUnitRanges, String timeZone) {
            this.rexBuilder = Objects.requireNonNull(rexBuilder);
            this.timeUnit = Objects.requireNonNull(timeUnit);
            Bug.upgrade("Change type to Map<RexNode, RangeSet<Calendar>> when [CALCITE-1367] is fixed");
            this.operandRanges = Objects.requireNonNull(operandRanges);
            this.timeUnitRanges = Objects.requireNonNull(timeUnitRanges);
            this.timeZone = timeZone;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public RexNode visitCall(RexCall call) {
            switch (call.getKind()) {
                case EQUALS: 
                case GREATER_THAN_OR_EQUAL: 
                case LESS_THAN_OR_EQUAL: 
                case GREATER_THAN: 
                case LESS_THAN: {
                    RexLiteral flag;
                    RexNode operand;
                    RexCall subCall;
                    RexNode op0 = (RexNode)call.operands.get(0);
                    RexNode op1 = (RexNode)call.operands.get(1);
                    switch (op0.getKind()) {
                        case LITERAL: {
                            boolean bl;
                            assert (op0 instanceof RexLiteral);
                            if (this.isExtractCall(op1)) {
                                assert (op1 instanceof RexCall);
                                subCall = (RexCall)op1;
                                operand = subCall.getOperands().get(1);
                                if (this.canRewriteExtract(operand)) {
                                    return this.compareExtract(call.getKind().reverse(), operand, (RexLiteral)op0);
                                }
                            }
                            if (!this.isFloorCeilCall(op1)) break;
                            assert (op1 instanceof RexCall);
                            subCall = (RexCall)op1;
                            flag = (RexLiteral)subCall.operands.get(1);
                            TimeUnitRange timeUnit = (TimeUnitRange)((Object)flag.getValue());
                            SqlKind sqlKind = call.getKind().reverse();
                            RexLiteral rexLiteral = (RexLiteral)op0;
                            if (op1.getKind() == SqlKind.FLOOR) {
                                bl = true;
                                return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                            }
                            bl = false;
                            return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                        }
                    }
                    switch (op1.getKind()) {
                        case LITERAL: {
                            boolean bl;
                            assert (op1 instanceof RexLiteral);
                            if (this.isExtractCall(op0)) {
                                assert (op0 instanceof RexCall);
                                subCall = (RexCall)op0;
                                operand = (RexNode)subCall.operands.get(1);
                                if (this.canRewriteExtract(operand)) {
                                    return this.compareExtract(call.getKind(), (RexNode)subCall.operands.get(1), (RexLiteral)op1);
                                }
                            }
                            if (!this.isFloorCeilCall(op0)) break;
                            subCall = (RexCall)op0;
                            flag = (RexLiteral)subCall.operands.get(1);
                            TimeUnitRange timeUnit = (TimeUnitRange)((Object)flag.getValue());
                            SqlKind sqlKind = call.getKind();
                            RexLiteral rexLiteral = (RexLiteral)op1;
                            if (op0.getKind() == SqlKind.FLOOR) {
                                bl = true;
                                return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                            }
                            bl = false;
                            return this.compareFloorCeil(sqlKind, subCall.getOperands().get(0), rexLiteral, timeUnit, bl);
                        }
                    }
                    break;
                }
            }
            this.calls.push(call);
            try {
                RexNode rexNode = super.visitCall(call);
                return rexNode;
            }
            finally {
                this.calls.pop();
            }
        }

        private boolean canRewriteExtract(RexNode operand) {
            if (this.timeUnit == TimeUnitRange.YEAR) {
                return true;
            }
            RangeSet<Calendar> calendarRangeSet = this.operandRanges.get(operand);
            if (calendarRangeSet == null || calendarRangeSet.isEmpty()) {
                return false;
            }
            for (Range<Calendar> range : calendarRangeSet.asRanges()) {
                if (range.hasUpperBound() && range.hasLowerBound()) continue;
                return false;
            }
            return true;
        }

        @Override
        protected List<RexNode> visitList(List<? extends RexNode> exprs, boolean[] update) {
            if (exprs.isEmpty()) {
                return ImmutableList.of();
            }
            switch (this.calls.peek().getKind()) {
                case AND: {
                    return super.visitList(exprs, update);
                }
            }
            if (this.timeUnit != TimeUnitRange.YEAR) {
                return exprs;
            }
            ImmutableMap<RexNode, RangeSet<Calendar>> save = ImmutableMap.copyOf(this.operandRanges);
            ImmutableList.Builder clonedOperands = ImmutableList.builder();
            Iterator<RexNode> iterator = exprs.iterator();
            while (iterator.hasNext()) {
                RexNode operand;
                RexNode clonedOperand = operand = iterator.next();
                for (TimeUnitRange timeUnit : this.timeUnitRanges) {
                    clonedOperand = clonedOperand.accept(new ExtractShuttle(this.rexBuilder, timeUnit, this.operandRanges, this.timeUnitRanges, this.timeZone));
                }
                if (clonedOperand != operand && update != null) {
                    update[0] = true;
                }
                clonedOperands.add(clonedOperand);
                this.operandRanges.clear();
                this.operandRanges.putAll(save);
            }
            return clonedOperands.build();
        }

        boolean isExtractCall(RexNode e) {
            switch (e.getKind()) {
                case EXTRACT: {
                    RexCall call = (RexCall)e;
                    RexLiteral flag = (RexLiteral)call.operands.get(0);
                    TimeUnitRange timeUnit = (TimeUnitRange)((Object)flag.getValue());
                    return timeUnit == this.timeUnit;
                }
            }
            return false;
        }

        RexNode compareExtract(SqlKind comparison, RexNode operand, RexLiteral literal) {
            RangeSet rangeSet = this.operandRanges.get(operand);
            if (rangeSet == null) {
                rangeSet = ImmutableRangeSet.of().complement();
            }
            TreeRangeSet<Calendar> s2 = TreeRangeSet.create();
            int v = ((BigDecimal)literal.getValue()).intValue() - (this.timeUnit == TimeUnitRange.MONTH ? 1 : 0);
            if (!ExtractShuttle.isValid(v, this.timeUnit)) {
                return this.rexBuilder.makeLiteral(false);
            }
            for (Range<Calendar> range : rangeSet.asRanges()) {
                switch (this.timeUnit) {
                    case YEAR: {
                        Calendar calendar = Util.calendar();
                        calendar.clear();
                        calendar.set(v, 0, 1);
                        s2.add(this.extractRange(this.timeUnit, comparison, calendar));
                        break;
                    }
                    case MONTH: 
                    case DAY: 
                    case HOUR: 
                    case MINUTE: 
                    case SECOND: {
                        if (!range.hasLowerBound() || !range.hasUpperBound()) break;
                        Calendar calendar = (Calendar)((Calendar)range.lowerEndpoint()).clone();
                        int i = 0;
                        while (this.next(calendar, this.timeUnit, v, range, i++ > 0)) {
                            s2.add(this.extractRange(this.timeUnit, comparison, calendar));
                        }
                        break;
                    }
                }
            }
            s2.removeAll(rangeSet.complement());
            this.operandRanges.put(operand, ImmutableRangeSet.copyOf(s2));
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            for (Range<Calendar> range : s2.asRanges()) {
                nodes.add(this.toRex(operand, range));
            }
            return RexUtil.composeDisjunction(this.rexBuilder, nodes);
        }

        private boolean next(Calendar c, TimeUnitRange timeUnit, int v, Range<Calendar> r, boolean strict) {
            Calendar original = (Calendar)c.clone();
            int code = (Integer)TIME_UNIT_CODES.get((Object)timeUnit);
            while (true) {
                c.set(code, v);
                int v2 = c.get(code);
                if (v2 < v) continue;
                if (!strict || original.compareTo(c) != 0) break;
                c.add((Integer)TIME_UNIT_CODES.get(TIME_UNIT_PARENTS.get((Object)timeUnit)), 1);
            }
            return r.contains(c);
        }

        private static boolean isValid(int v, TimeUnitRange timeUnit) {
            switch (timeUnit) {
                case YEAR: {
                    return v > 0;
                }
                case MONTH: {
                    return v >= 0 && v <= 11;
                }
                case DAY: {
                    return v > 0 && v <= 31;
                }
                case HOUR: {
                    return v >= 0 && v <= 24;
                }
                case MINUTE: 
                case SECOND: {
                    return v >= 0 && v <= 60;
                }
            }
            return false;
        }

        @Nonnull
        private RexNode toRex(RexNode operand, Range<Calendar> r) {
            SqlBinaryOperator op;
            ArrayList<RexNode> nodes = new ArrayList<RexNode>();
            if (r.hasLowerBound()) {
                op = r.lowerBoundType() == BoundType.CLOSED ? SqlStdOperatorTable.GREATER_THAN_OR_EQUAL : SqlStdOperatorTable.GREATER_THAN;
                nodes.add(this.rexBuilder.makeCall((SqlOperator)op, operand, this.dateTimeLiteral(this.rexBuilder, r.lowerEndpoint(), operand)));
            }
            if (r.hasUpperBound()) {
                op = r.upperBoundType() == BoundType.CLOSED ? SqlStdOperatorTable.LESS_THAN_OR_EQUAL : SqlStdOperatorTable.LESS_THAN;
                nodes.add(this.rexBuilder.makeCall((SqlOperator)op, operand, this.dateTimeLiteral(this.rexBuilder, r.upperEndpoint(), operand)));
            }
            return RexUtil.composeConjunction(this.rexBuilder, nodes);
        }

        private RexLiteral dateTimeLiteral(RexBuilder rexBuilder, Calendar calendar, RexNode operand) {
            switch (operand.getType().getSqlTypeName()) {
                case TIMESTAMP: {
                    TimestampString ts = TimestampString.fromCalendarFields(calendar);
                    int p = operand.getType().getPrecision();
                    return rexBuilder.makeTimestampLiteral(ts, p);
                }
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    TimestampString ts = TimestampString.fromCalendarFields(calendar);
                    TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                    TimestampString localTs = new TimestampWithTimeZoneString(ts, tz).withTimeZone(DateTimeUtils.UTC_ZONE).getLocalTimestampString();
                    int p = operand.getType().getPrecision();
                    return rexBuilder.makeTimestampWithLocalTimeZoneLiteral(localTs, p);
                }
                case DATE: {
                    DateString d = DateString.fromCalendarFields(calendar);
                    return rexBuilder.makeDateLiteral(d);
                }
            }
            throw Util.unexpected(operand.getType().getSqlTypeName());
        }

        private Range<Calendar> extractRange(TimeUnitRange timeUnit, SqlKind comparison, Calendar c) {
            switch (comparison) {
                case EQUALS: {
                    return Range.closedOpen(this.round(c, timeUnit, true), this.round(c, timeUnit, false));
                }
                case LESS_THAN: {
                    return Range.lessThan(this.round(c, timeUnit, true));
                }
                case LESS_THAN_OR_EQUAL: {
                    return Range.lessThan(this.round(c, timeUnit, false));
                }
                case GREATER_THAN: {
                    return Range.atLeast(this.round(c, timeUnit, false));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Range.atLeast(this.round(c, timeUnit, true));
                }
            }
            throw new AssertionError((Object)comparison);
        }

        private Calendar round(Calendar c, TimeUnitRange timeUnit, boolean down) {
            c = (Calendar)c.clone();
            if (!down) {
                Integer code = (Integer)TIME_UNIT_CODES.get((Object)timeUnit);
                int v = c.get(code);
                c.set(code, v + 1);
            }
            return c;
        }

        private RexNode compareFloorCeil(SqlKind comparison, RexNode operand, RexLiteral timeLiteral, TimeUnitRange timeUnit, boolean floor) {
            RangeSet rangeSet = this.operandRanges.get(operand);
            if (rangeSet == null) {
                rangeSet = ImmutableRangeSet.of().complement();
            }
            TreeRangeSet<Calendar> s2 = TreeRangeSet.create();
            Calendar c = this.timestampValue(timeLiteral);
            Range<Calendar> range = floor ? this.floorRange(timeUnit, comparison, c) : this.ceilRange(timeUnit, comparison, c);
            s2.add(range);
            s2.removeAll(rangeSet.complement());
            this.operandRanges.put(operand, ImmutableRangeSet.copyOf(s2));
            if (range.isEmpty()) {
                return this.rexBuilder.makeLiteral(false);
            }
            return this.toRex(operand, range);
        }

        private Calendar timestampValue(RexLiteral timeLiteral) {
            switch (timeLiteral.getTypeName()) {
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    TimeZone tz = TimeZone.getTimeZone(this.timeZone);
                    return Util.calendar(SqlFunctions.timestampWithLocalTimeZoneToTimestamp(timeLiteral.getValueAs(Long.class), tz));
                }
                case TIMESTAMP: {
                    return Util.calendar(timeLiteral.getValueAs(Long.class));
                }
                case DATE: {
                    DateString d = timeLiteral.getValueAs(DateString.class);
                    return Util.calendar(d.getMillisSinceEpoch());
                }
            }
            throw Util.unexpected(timeLiteral.getTypeName());
        }

        private Range<Calendar> floorRange(TimeUnitRange timeUnit, SqlKind comparison, Calendar c) {
            Calendar floor = this.floor(c, timeUnit);
            boolean boundary = floor.equals(c);
            switch (comparison) {
                case EQUALS: {
                    return Range.closedOpen(floor, boundary ? this.increment(floor, timeUnit) : floor);
                }
                case LESS_THAN: {
                    return boundary ? Range.lessThan(floor) : Range.lessThan(this.increment(floor, timeUnit));
                }
                case LESS_THAN_OR_EQUAL: {
                    return Range.lessThan(this.increment(floor, timeUnit));
                }
                case GREATER_THAN: {
                    return Range.atLeast(this.increment(floor, timeUnit));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return boundary ? Range.atLeast(floor) : Range.atLeast(this.increment(floor, timeUnit));
                }
            }
            throw Util.unexpected(comparison);
        }

        private Range<Calendar> ceilRange(TimeUnitRange timeUnit, SqlKind comparison, Calendar c) {
            Calendar ceil = this.ceil(c, timeUnit);
            boolean boundary = ceil.equals(c);
            switch (comparison) {
                case EQUALS: {
                    return Range.openClosed(boundary ? this.decrement(ceil, timeUnit) : ceil, ceil);
                }
                case LESS_THAN: {
                    return Range.atMost(this.decrement(ceil, timeUnit));
                }
                case LESS_THAN_OR_EQUAL: {
                    return boundary ? Range.atMost(ceil) : Range.atMost(this.decrement(ceil, timeUnit));
                }
                case GREATER_THAN: {
                    return boundary ? Range.greaterThan(ceil) : Range.greaterThan(this.decrement(ceil, timeUnit));
                }
                case GREATER_THAN_OR_EQUAL: {
                    return Range.greaterThan(this.decrement(ceil, timeUnit));
                }
            }
            throw Util.unexpected(comparison);
        }

        boolean isFloorCeilCall(RexNode e) {
            switch (e.getKind()) {
                case FLOOR: 
                case CEIL: {
                    RexCall call = (RexCall)e;
                    return call.getOperands().size() == 2;
                }
            }
            return false;
        }

        private Calendar increment(Calendar c, TimeUnitRange timeUnit) {
            c = (Calendar)c.clone();
            c.add((Integer)TIME_UNIT_CODES.get((Object)timeUnit), 1);
            return c;
        }

        private Calendar decrement(Calendar c, TimeUnitRange timeUnit) {
            c = (Calendar)c.clone();
            c.add((Integer)TIME_UNIT_CODES.get((Object)timeUnit), -1);
            return c;
        }

        private Calendar ceil(Calendar c, TimeUnitRange timeUnit) {
            Calendar floor = this.floor(c, timeUnit);
            return floor.equals(c) ? floor : this.increment(floor, timeUnit);
        }

        private Calendar floor(Calendar c, TimeUnitRange timeUnit) {
            c = (Calendar)c.clone();
            switch (timeUnit) {
                case YEAR: {
                    c.set((Integer)TIME_UNIT_CODES.get((Object)TimeUnitRange.MONTH), 0);
                }
                case MONTH: {
                    c.set((Integer)TIME_UNIT_CODES.get((Object)TimeUnitRange.DAY), 1);
                }
                case DAY: {
                    c.set((Integer)TIME_UNIT_CODES.get((Object)TimeUnitRange.HOUR), 0);
                }
                case HOUR: {
                    c.set((Integer)TIME_UNIT_CODES.get((Object)TimeUnitRange.MINUTE), 0);
                }
                case MINUTE: {
                    c.set((Integer)TIME_UNIT_CODES.get((Object)TimeUnitRange.SECOND), 0);
                }
                case SECOND: {
                    c.set((Integer)TIME_UNIT_CODES.get((Object)TimeUnitRange.MILLISECOND), 0);
                }
            }
            return c;
        }
    }

    private static class ExtractFinder
    extends RexVisitorImpl
    implements AutoCloseable {
        private final Set<TimeUnitRange> timeUnits = EnumSet.noneOf(TimeUnitRange.class);
        private final Set<SqlKind> opKinds = EnumSet.noneOf(SqlKind.class);
        private static final ThreadLocal<ExtractFinder> THREAD_INSTANCES = ThreadLocal.withInitial(ExtractFinder::new);

        private ExtractFinder() {
            super(true);
        }

        @Override
        public Object visitCall(RexCall call) {
            switch (call.getKind()) {
                case EXTRACT: {
                    RexLiteral operand = (RexLiteral)call.getOperands().get(0);
                    this.timeUnits.add((TimeUnitRange)((Object)operand.getValue()));
                    break;
                }
                case FLOOR: 
                case CEIL: {
                    if (call.getOperands().size() != 2) break;
                    this.opKinds.add(call.getKind());
                }
            }
            return super.visitCall(call);
        }

        @Override
        public void close() {
            this.timeUnits.clear();
            this.opKinds.clear();
        }
    }

    public static class FilterDateRangeRule
    extends RelOptRule {
        public FilterDateRangeRule(RelBuilderFactory relBuilderFactory) {
            super(FilterDateRangeRule.operandJ(Filter.class, null, FILTER_PREDICATE, FilterDateRangeRule.any()), relBuilderFactory, "FilterDateRangeRule");
        }

        @Override
        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
            String timeZone = filter.getCluster().getPlanner().getContext().unwrap(CalciteConnectionConfig.class).timeZone();
            RexNode condition = DateRangeRules.replaceTimeUnits(rexBuilder, filter.getCondition(), timeZone);
            if (condition.equals(filter.getCondition())) {
                return;
            }
            RelBuilder relBuilder = this.relBuilderFactory.create(filter.getCluster(), null);
            relBuilder.push(filter.getInput()).filter(condition);
            call.transformTo(relBuilder.build());
        }
    }
}

