/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.impl.utils;

import java.lang.reflect.Type;
import java.util.Date;
import java.util.Map;
import java.util.stream.IntStream;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.repackaged.beam_sdks_java_extensions_sql.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.BiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableBiMap;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.ImmutableMap;
import org.joda.time.base.AbstractInstant;

public class CalciteUtils {
    private static final long UNLIMITED_ARRAY_SIZE = -1L;
    private static final BiMap<Schema.FieldType, SqlTypeName> BEAM_TO_CALCITE_TYPE_MAPPING = ImmutableBiMap.builder().put((Object)Schema.FieldType.BYTE, (Object)SqlTypeName.TINYINT).put((Object)Schema.FieldType.INT16, (Object)SqlTypeName.SMALLINT).put((Object)Schema.FieldType.INT32, (Object)SqlTypeName.INTEGER).put((Object)Schema.FieldType.INT64, (Object)SqlTypeName.BIGINT).put((Object)Schema.FieldType.FLOAT, (Object)SqlTypeName.FLOAT).put((Object)Schema.FieldType.DOUBLE, (Object)SqlTypeName.DOUBLE).put((Object)Schema.FieldType.DECIMAL, (Object)SqlTypeName.DECIMAL).put((Object)Schema.FieldType.BOOLEAN, (Object)SqlTypeName.BOOLEAN).put((Object)Schema.FieldType.BYTES, (Object)SqlTypeName.VARBINARY).put((Object)Schema.FieldType.DATETIME.withMetadata("DATE"), (Object)SqlTypeName.DATE).put((Object)Schema.FieldType.DATETIME.withMetadata("TIME"), (Object)SqlTypeName.TIME).put((Object)Schema.FieldType.DATETIME.withMetadata("TIME_WITH_LOCAL_TZ"), (Object)SqlTypeName.TIME_WITH_LOCAL_TIME_ZONE).put((Object)Schema.FieldType.DATETIME, (Object)SqlTypeName.TIMESTAMP).put((Object)Schema.FieldType.DATETIME.withMetadata("TS_WITH_LOCAL_TZ"), (Object)SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE).put((Object)Schema.FieldType.STRING.withMetadata("CHAR"), (Object)SqlTypeName.CHAR).put((Object)Schema.FieldType.STRING, (Object)SqlTypeName.VARCHAR).build();
    private static final BiMap<SqlTypeName, Schema.FieldType> CALCITE_TO_BEAM_TYPE_MAPPING = BEAM_TO_CALCITE_TYPE_MAPPING.inverse();
    public static final Schema.FieldType TINY_INT = CalciteUtils.toFieldType(SqlTypeName.TINYINT);
    public static final Schema.FieldType SMALL_INT = CalciteUtils.toFieldType(SqlTypeName.SMALLINT);
    public static final Schema.FieldType INTEGER = CalciteUtils.toFieldType(SqlTypeName.INTEGER);
    public static final Schema.FieldType BIG_INT = CalciteUtils.toFieldType(SqlTypeName.BIGINT);
    public static final Schema.FieldType FLOAT = CalciteUtils.toFieldType(SqlTypeName.FLOAT);
    public static final Schema.FieldType DOUBLE = CalciteUtils.toFieldType(SqlTypeName.DOUBLE);
    public static final Schema.FieldType DECIMAL = CalciteUtils.toFieldType(SqlTypeName.DECIMAL);
    public static final Schema.FieldType BOOLEAN = CalciteUtils.toFieldType(SqlTypeName.BOOLEAN);
    public static final Schema.FieldType CHAR = CalciteUtils.toFieldType(SqlTypeName.CHAR);
    public static final Schema.FieldType VARCHAR = CalciteUtils.toFieldType(SqlTypeName.VARCHAR);
    public static final Schema.FieldType TIME = CalciteUtils.toFieldType(SqlTypeName.TIME);
    public static final Schema.FieldType DATE = CalciteUtils.toFieldType(SqlTypeName.DATE);
    public static final Schema.FieldType TIMESTAMP = CalciteUtils.toFieldType(SqlTypeName.TIMESTAMP);
    private static final Map<Schema.FieldType, SqlTypeName> BEAM_TO_CALCITE_DEFAULT_MAPPING = ImmutableMap.of((Object)Schema.FieldType.DATETIME, (Object)((Object)SqlTypeName.TIMESTAMP), (Object)Schema.FieldType.STRING, (Object)((Object)SqlTypeName.VARCHAR));

    public static Schema toSchema(RelDataType tableInfo) {
        return (Schema)tableInfo.getFieldList().stream().map(CalciteUtils::toField).collect(Schema.toSchema());
    }

    public static SqlTypeName toSqlTypeName(Schema.FieldType type) {
        switch (type.getTypeName()) {
            case ROW: {
                return SqlTypeName.ROW;
            }
            case ARRAY: {
                return SqlTypeName.ARRAY;
            }
            case MAP: {
                return SqlTypeName.MAP;
            }
        }
        SqlTypeName typeName = (SqlTypeName)((Object)BEAM_TO_CALCITE_TYPE_MAPPING.get((Object)type.withNullable(false)));
        if (typeName != null) {
            return typeName;
        }
        return BEAM_TO_CALCITE_DEFAULT_MAPPING.get(type);
    }

    public static Schema.FieldType toFieldType(SqlTypeName sqlTypeName) {
        switch (sqlTypeName) {
            case MAP: 
            case MULTISET: 
            case ARRAY: 
            case ROW: {
                throw new IllegalArgumentException(String.format("%s is a type constructor that takes parameters, not a type,so it cannot be converted to a %s", new Object[]{sqlTypeName, Schema.FieldType.class.getSimpleName()}));
            }
        }
        return (Schema.FieldType)CALCITE_TO_BEAM_TYPE_MAPPING.get((Object)sqlTypeName);
    }

    public static Schema.Field toField(RelDataTypeField calciteField) {
        return CalciteUtils.toField(calciteField.getName(), calciteField.getType());
    }

    public static Schema.Field toField(String name, RelDataType calciteType) {
        return Schema.Field.of((String)name, (Schema.FieldType)CalciteUtils.toFieldType(calciteType)).withNullable(calciteType.isNullable());
    }

    public static Schema.FieldType toFieldType(RelDataType calciteType) {
        switch (calciteType.getSqlTypeName()) {
            case MULTISET: 
            case ARRAY: {
                return Schema.FieldType.array((Schema.FieldType)CalciteUtils.toFieldType(calciteType.getComponentType()));
            }
            case MAP: {
                return Schema.FieldType.map((Schema.FieldType)CalciteUtils.toFieldType(calciteType.getKeyType()), (Schema.FieldType)CalciteUtils.toFieldType(calciteType.getValueType()));
            }
            case ROW: {
                return Schema.FieldType.row((Schema)CalciteUtils.toSchema(calciteType));
            }
        }
        return CalciteUtils.toFieldType(calciteType.getSqlTypeName());
    }

    public static RelDataType toCalciteRowType(Schema schema, RelDataTypeFactory dataTypeFactory) {
        RelDataTypeFactory.Builder builder = new RelDataTypeFactory.Builder(dataTypeFactory);
        IntStream.range(0, schema.getFieldCount()).forEach(idx -> builder.add(schema.getField(idx).getName(), CalciteUtils.toRelDataType(dataTypeFactory, schema, idx)));
        return builder.build();
    }

    private static RelDataType toRelDataType(RelDataTypeFactory dataTypeFactory, Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ARRAY: {
                return dataTypeFactory.createArrayType(CalciteUtils.toRelDataType(dataTypeFactory, fieldType.getCollectionElementType()), -1L);
            }
            case MAP: {
                RelDataType componentKeyType = CalciteUtils.toRelDataType(dataTypeFactory, fieldType.getMapKeyType());
                RelDataType componentValueType = CalciteUtils.toRelDataType(dataTypeFactory, fieldType.getMapValueType());
                return dataTypeFactory.createMapType(componentKeyType, componentValueType);
            }
            case ROW: {
                return CalciteUtils.toCalciteRowType(fieldType.getRowSchema(), dataTypeFactory);
            }
        }
        return dataTypeFactory.createSqlType(CalciteUtils.toSqlTypeName(fieldType));
    }

    private static RelDataType toRelDataType(RelDataTypeFactory dataTypeFactory, Schema schema, int fieldIndex) {
        Schema.Field field = schema.getField(fieldIndex);
        RelDataType type = CalciteUtils.toRelDataType(dataTypeFactory, field.getType());
        return dataTypeFactory.createTypeWithNullability(type, field.getType().getNullable());
    }

    public static RelDataType sqlTypeWithAutoCast(RelDataTypeFactory typeFactory, Type rawType) {
        if (rawType instanceof Class && AbstractInstant.class.isAssignableFrom((Class)rawType)) {
            return typeFactory.createJavaType(Date.class);
        }
        if (rawType instanceof Class && ByteString.class.isAssignableFrom((Class)rawType)) {
            return typeFactory.createJavaType(byte[].class);
        }
        return typeFactory.createJavaType((Class)rawType);
    }
}

