/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperatorRewriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SqlCaseWithValueOperatorRewriter
implements SqlOperatorRewriter {
    SqlCaseWithValueOperatorRewriter() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RexNode apply(@UnknownKeyFor @NonNull @Initialized RexBuilder rexBuilder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> operands) {
        Preconditions.checkArgument((operands.size() % 2 == 0 && !operands.isEmpty() ? 1 : 0) != 0, (Object)"$case_with_value should have an even number of arguments greater than 0 in function call (The value operand, the else operand, and paired when/then operands).");
        SqlCaseOperator op = SqlStdOperatorTable.CASE;
        ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
        RexNode value = operands.get(0);
        for (int i = 1; i < operands.size() - 2; i += 2) {
            RexNode when = operands.get(i);
            RexNode then = operands.get(i + 1);
            newOperands.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.EQUALS, (List)ImmutableList.of((Object)value, (Object)when)));
            newOperands.add(then);
        }
        RexNode elseOperand = (RexNode)Iterables.getLast(operands);
        newOperands.add(elseOperand);
        return rexBuilder.makeCall((SqlOperator)op, newOperands);
    }
}

