/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.Analyzer;
import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.ParseResumeLocation;
import com.google.zetasql.SimpleCatalog;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLOptions;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCatalog;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class SqlAnalyzer {
    private static final @UnknownKeyFor @NonNull @Initialized ImmutableSet<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ZetaSQLResolvedNodeKind.ResolvedNodeKind> SUPPORTED_STATEMENT_KINDS = ImmutableSet.of((Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_QUERY_STMT, (Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_FUNCTION_STMT, (Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_TABLE_FUNCTION_STMT);

    SqlAnalyzer() {
    }

    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String>> extractTableNames(@UnknownKeyFor @NonNull @Initialized String sql, @UnknownKeyFor @NonNull @Initialized AnalyzerOptions options) {
        ParseResumeLocation parseResumeLocation = new ParseResumeLocation(sql);
        ImmutableList.Builder tables = ImmutableList.builder();
        while (!SqlAnalyzer.isEndOfInput(parseResumeLocation)) {
            List statementTables = Analyzer.extractTableNamesFromNextStatement((ParseResumeLocation)parseResumeLocation, (AnalyzerOptions)options);
            tables.addAll((Iterable)statementTables);
        }
        return tables.build();
    }

    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedQueryStmt analyzeQuery(@UnknownKeyFor @NonNull @Initialized String sql, @UnknownKeyFor @NonNull @Initialized AnalyzerOptions options, @UnknownKeyFor @NonNull @Initialized BeamZetaSqlCatalog catalog) {
        ResolvedNodes.ResolvedStatement statement;
        ParseResumeLocation parseResumeLocation = new ParseResumeLocation(sql);
        do {
            if ((statement = this.analyzeNextStatement(parseResumeLocation, options, catalog)).nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_QUERY_STMT || SqlAnalyzer.isEndOfInput(parseResumeLocation)) continue;
            throw new UnsupportedOperationException("No additional statements are allowed after a SELECT statement.");
        } while (!SqlAnalyzer.isEndOfInput(parseResumeLocation));
        if (!(statement instanceof ResolvedNodes.ResolvedQueryStmt)) {
            throw new UnsupportedOperationException("Statement list must end in a SELECT statement, not " + statement.nodeKindString());
        }
        return (ResolvedNodes.ResolvedQueryStmt)statement;
    }

    private static @UnknownKeyFor @NonNull @Initialized boolean isEndOfInput(@UnknownKeyFor @NonNull @Initialized ParseResumeLocation parseResumeLocation) {
        return parseResumeLocation.getBytePosition() >= parseResumeLocation.getInput().getBytes(StandardCharsets.UTF_8).length;
    }

    private // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized ResolvedNodes.ResolvedStatement analyzeNextStatement(@UnknownKeyFor @NonNull @Initialized ParseResumeLocation parseResumeLocation, @UnknownKeyFor @NonNull @Initialized AnalyzerOptions options, @UnknownKeyFor @NonNull @Initialized BeamZetaSqlCatalog catalog) {
        ResolvedNodes.ResolvedStatement resolvedStatement = Analyzer.analyzeNextStatement((ParseResumeLocation)parseResumeLocation, (AnalyzerOptions)options, (SimpleCatalog)catalog.getZetaSqlCatalog());
        if (resolvedStatement.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_FUNCTION_STMT) {
            ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt = (ResolvedNodes.ResolvedCreateFunctionStmt)resolvedStatement;
            try {
                catalog.addFunction(createFunctionStmt);
            }
            catch (IllegalArgumentException e) {
                throw new RuntimeException(String.format("Failed to define function '%s'", String.join((CharSequence)".", (Iterable<? extends CharSequence>)createFunctionStmt.getNamePath())), e);
            }
        } else if (resolvedStatement.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_TABLE_FUNCTION_STMT) {
            ResolvedNodes.ResolvedCreateTableFunctionStmt createTableFunctionStmt = (ResolvedNodes.ResolvedCreateTableFunctionStmt)resolvedStatement;
            catalog.addTableValuedFunction(createTableFunctionStmt);
        } else if (!SUPPORTED_STATEMENT_KINDS.contains((Object)resolvedStatement.nodeKind())) {
            throw new UnsupportedOperationException("Unrecognized statement type " + resolvedStatement.nodeKindString());
        }
        return resolvedStatement;
    }

    static @UnknownKeyFor @NonNull @Initialized AnalyzerOptions baseAnalyzerOptions() {
        AnalyzerOptions options = new AnalyzerOptions();
        options.setErrorMessageMode(ZetaSQLOptions.ErrorMessageMode.ERROR_MESSAGE_MULTI_LINE_WITH_CARET);
        options.getLanguageOptions().setProductMode(ZetaSQLOptions.ProductMode.PRODUCT_EXTERNAL);
        options.getLanguageOptions().setEnabledLanguageFeatures(new HashSet<ZetaSQLOptions.LanguageFeature>(Arrays.asList(ZetaSQLOptions.LanguageFeature.FEATURE_CREATE_AGGREGATE_FUNCTION, ZetaSQLOptions.LanguageFeature.FEATURE_CREATE_TABLE_FUNCTION, ZetaSQLOptions.LanguageFeature.FEATURE_DISALLOW_GROUP_BY_FLOAT, ZetaSQLOptions.LanguageFeature.FEATURE_NUMERIC_TYPE, ZetaSQLOptions.LanguageFeature.FEATURE_TABLE_VALUED_FUNCTIONS, ZetaSQLOptions.LanguageFeature.FEATURE_TEMPLATE_FUNCTIONS, ZetaSQLOptions.LanguageFeature.FEATURE_V_1_1_SELECT_STAR_EXCEPT_REPLACE, ZetaSQLOptions.LanguageFeature.FEATURE_V_1_2_CIVIL_TIME, ZetaSQLOptions.LanguageFeature.FEATURE_V_1_3_ADDITIONAL_STRING_FUNCTIONS)));
        options.getLanguageOptions().setSupportedStatementKinds(SUPPORTED_STATEMENT_KINDS);
        return options;
    }

    static @UnknownKeyFor @NonNull @Initialized AnalyzerOptions getAnalyzerOptions(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters queryParams, @UnknownKeyFor @NonNull @Initialized String defaultTimezone) {
        AnalyzerOptions options;
        block3: {
            block2: {
                options = SqlAnalyzer.baseAnalyzerOptions();
                options.setDefaultTimezone(defaultTimezone);
                if (queryParams.getKind() != QueryPlanner.QueryParameters.Kind.NAMED) break block2;
                options.setParameterMode(ZetaSQLOptions.ParameterMode.PARAMETER_NAMED);
                for (Map.Entry entry : queryParams.named().entrySet()) {
                    options.addQueryParameter((String)entry.getKey(), ((Value)entry.getValue()).getType());
                }
                break block3;
            }
            if (queryParams.getKind() != QueryPlanner.QueryParameters.Kind.POSITIONAL) break block3;
            options.setParameterMode(ZetaSQLOptions.ParameterMode.PARAMETER_POSITIONAL);
            for (Value param : queryParams.positional()) {
                options.addPositionalQueryParameter(param.getType());
            }
        }
        return options;
    }
}

