/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation.impl;

import java.util.TimeZone;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.zetasql.DateTimeUtils;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.linq4j.function.Strict;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Internal
public class TimestampFunctions {
    public static @UnknownKeyFor @NonNull @Initialized DateTime timestamp(@UnknownKeyFor @NonNull @Initialized String timestampStr) {
        return TimestampFunctions.timestamp(timestampStr, "UTC");
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized DateTime timestamp(@UnknownKeyFor @NonNull @Initialized String timestampStr, @UnknownKeyFor @NonNull @Initialized String timezone) {
        return DateTimeUtils.findDateTimePattern(timestampStr).withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timezone))).parseDateTime(timestampStr);
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized DateTime timestamp(@UnknownKeyFor @NonNull @Initialized Integer numOfDays) {
        return TimestampFunctions.timestamp(numOfDays, "UTC");
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized DateTime timestamp(@UnknownKeyFor @NonNull @Initialized Integer numOfDays, @UnknownKeyFor @NonNull @Initialized String timezone) {
        return new DateTime((long)numOfDays.intValue() * DateTimeUtils.MILLIS_PER_DAY, DateTimeZone.UTC).withZoneRetainFields(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timezone)));
    }
}

