/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.unnest;

import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.ZetaSqlUnnest;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BeamZetaSqlUnnestRel
extends ZetaSqlUnnest
implements BeamRelNode {
    private final @UnknownKeyFor @NonNull @Initialized RelDataType unnestType;
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices;

    public BeamZetaSqlUnnestRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RelDataType unnestType, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices) {
        super(cluster, traitSet, input, false);
        this.unnestType = unnestType;
        this.unnestIndices = unnestIndices;
    }

    public @UnknownKeyFor @NonNull @Initialized ZetaSqlUnnest copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input) {
        return new BeamZetaSqlUnnestRel(this.getCluster(), traitSet, input, this.unnestType, this.unnestIndices);
    }

    @Override
    protected @UnknownKeyFor @NonNull @Initialized RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.input.getRowType(), (RelDataType)this.unnestType, (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, (List)ImmutableList.of());
    }

    public @UnknownKeyFor @NonNull @Initialized NodeStats estimateNodeStats(@UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats((RelNode)this.input, (BeamRelMetadataQuery)mq).multiply(2.0);
    }

    public @UnknownKeyFor @NonNull @Initialized BeamCostModel beamComputeSelfCost(@UnknownKeyFor @NonNull @Initialized RelOptPlanner planner, @UnknownKeyFor @NonNull @Initialized BeamRelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats((RelNode)this, (BeamRelMetadataQuery)mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RelWriter explainTerms(@UnknownKeyFor @NonNull @Initialized RelWriter pw) {
        return super.explainTerms(pw).item("unnestIndices", this.unnestIndices);
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    private static class UnnestFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices;

        private UnnestFn(@UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> unnestIndices) {
            this.outputSchema = outputSchema;
            this.unnestIndices = unnestIndices;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized Row row, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> out) {
            Row rowWithArrayField = row;
            Schema schemaWithArrayField = this.outputSchema;
            for (int i = this.unnestIndices.size() - 1; i > 0; --i) {
                rowWithArrayField = rowWithArrayField.getRow(this.unnestIndices.get(i).intValue());
                schemaWithArrayField = schemaWithArrayField.getField(this.unnestIndices.get(i).intValue()).getType().getRowSchema();
            }
            @Nullable Collection rawValues = rowWithArrayField.getArray(this.unnestIndices.get(0).intValue());
            if (rawValues == null) {
                return;
            }
            for (Object uncollectedValue : rawValues) {
                out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValue(uncollectedValue).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            PCollection outer = pinput.get(0);
            Schema joinedSchema = CalciteUtils.toSchema((RelDataType)BeamZetaSqlUnnestRel.this.getRowType());
            return ((PCollection)outer.apply((PTransform)ParDo.of((DoFn)new UnnestFn(joinedSchema, BeamZetaSqlUnnestRel.this.unnestIndices)))).setRowSchema(joinedSchema);
        }
    }
}

