/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperatorRewriter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlCaseOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Util;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SqlCoalesceOperatorRewriter
implements SqlOperatorRewriter {
    SqlCoalesceOperatorRewriter() {
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized RexNode apply(@UnknownKeyFor @NonNull @Initialized RexBuilder rexBuilder, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RexNode> operands) {
        Preconditions.checkArgument((operands.size() >= 1 ? 1 : 0) != 0, (Object)"COALESCE should have at least one argument in function call.");
        if (operands.size() == 1) {
            return operands.get(0);
        }
        SqlCaseOperator op = SqlStdOperatorTable.CASE;
        ArrayList<RexNode> newOperands = new ArrayList<RexNode>();
        for (RexNode operand : Util.skipLast(operands)) {
            newOperands.add(rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, (List)ImmutableList.of((Object)operand)));
            newOperands.add(operand);
        }
        newOperands.add((RexNode)Util.last(operands));
        return rexBuilder.makeCall((SqlOperator)op, newOperands);
    }
}

