/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.auto.value.AutoValue;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.PreparedExpression;
import com.google.zetasql.Type;
import com.google.zetasql.Value;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.IntFunction;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamSqlUnparseContext;
import org.apache.beam.sdk.extensions.sql.zetasql.AutoValue_BeamZetaSqlCalcRel_TimestampedFuture;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlBeamTranslationUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlCalciteTranslationUtils;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;

@Internal
public class BeamZetaSqlCalcRel
extends AbstractBeamCalcRel {
    private static final @UnknownKeyFor @NonNull @Initialized SqlDialect DIALECT = BeamBigQuerySqlDialect.DEFAULT;
    private static final @UnknownKeyFor @NonNull @Initialized int MAX_PENDING_WINDOW = 32;
    private final @UnknownKeyFor @NonNull @Initialized BeamSqlUnparseContext context;

    private static @UnknownKeyFor @NonNull @Initialized String columnName(@UnknownKeyFor @NonNull @Initialized int i) {
        return "_" + i;
    }

    public BeamZetaSqlCalcRel(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traits, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
        super(cluster, traits, input, program);
        IntFunction<SqlNode> fn = i -> new SqlIdentifier(BeamZetaSqlCalcRel.columnName(i), SqlParserPos.ZERO);
        this.context = new BeamSqlUnparseContext(fn);
    }

    public @UnknownKeyFor @NonNull @Initialized Calc copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized RexProgram program) {
        return new BeamZetaSqlCalcRel(this.getCluster(), traitSet, input, program);
    }

    public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row>, @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row>> buildPTransform() {
        return new Transform();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> createNullParams(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized RelDataType> input) {
        HashMap<String, Value> result = new HashMap<String, Value>();
        for (Map.Entry<String, RelDataType> entry : input.entrySet()) {
            result.put(entry.getKey(), Value.createNullValue((Type)ZetaSqlCalciteTranslationUtils.toZetaSqlType(entry.getValue())));
        }
        return result;
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    private static class CalcFn
    extends DoFn<Row, Row> {
        private final @UnknownKeyFor @NonNull @Initialized String sql;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> nullParams;
        private final @UnknownKeyFor @NonNull @Initialized Schema inputSchema;
        private final @UnknownKeyFor @NonNull @Initialized Schema outputSchema;
        private final @UnknownKeyFor @NonNull @Initialized String defaultTimezone;
        private final @UnknownKeyFor @NonNull @Initialized boolean verifyRowValues;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Integer> referencedColumns;
        @DoFn.FieldAccess(value="row")
        private final @UnknownKeyFor @NonNull @Initialized FieldAccessDescriptor fieldAccess;
        private transient @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized BoundedWindow, @UnknownKeyFor @NonNull @Initialized Queue<@UnknownKeyFor @NonNull @Initialized TimestampedFuture>> pending = new HashMap<BoundedWindow, Queue<TimestampedFuture>>();
        private transient @UnknownKeyFor @NonNull @Initialized PreparedExpression exp;
        private transient // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized PreparedExpression. @Nullable @UnknownKeyFor @Initialized Stream stream;

        CalcFn(@UnknownKeyFor @NonNull @Initialized String sql, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> nullParams, @UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized Schema outputSchema, @UnknownKeyFor @NonNull @Initialized String defaultTimezone, @UnknownKeyFor @NonNull @Initialized boolean verifyRowValues) {
            this.sql = sql;
            this.exp = new PreparedExpression(sql);
            this.nullParams = nullParams;
            this.inputSchema = inputSchema;
            this.outputSchema = outputSchema;
            this.defaultTimezone = defaultTimezone;
            this.verifyRowValues = verifyRowValues;
            try (PreparedExpression exp = CalcFn.prepareExpression(sql, nullParams, inputSchema, defaultTimezone);){
                ImmutableList.Builder columns = new ImmutableList.Builder();
                for (String c : exp.getReferencedColumns()) {
                    columns.add((Object)Integer.parseInt(c.substring(1)));
                }
                this.referencedColumns = columns.build();
                this.fieldAccess = FieldAccessDescriptor.withFieldIds(this.referencedColumns);
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized PreparedExpression prepareExpression(@UnknownKeyFor @NonNull @Initialized String sql, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> nullParams, @UnknownKeyFor @NonNull @Initialized Schema inputSchema, @UnknownKeyFor @NonNull @Initialized String defaultTimezone) {
            AnalyzerOptions options = SqlAnalyzer.getAnalyzerOptions(QueryPlanner.QueryParameters.ofNamed(nullParams), defaultTimezone);
            for (int i = 0; i < inputSchema.getFieldCount(); ++i) {
                options.addExpressionColumn(BeamZetaSqlCalcRel.columnName(i), ZetaSqlBeamTranslationUtils.toZetaSqlType(inputSchema.getField(i).getType()));
            }
            PreparedExpression exp = new PreparedExpression(sql);
            exp.prepare(options);
            return exp;
        }

        @DoFn.Setup
        public void setup() {
            this.exp = CalcFn.prepareExpression(this.sql, this.nullParams, this.inputSchema, this.defaultTimezone);
            this.stream = this.exp.stream();
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.pending = new HashMap<BoundedWindow, Queue<TimestampedFuture>>();
        }

        public @UnknownKeyFor @NonNull @Initialized Duration getAllowedTimestampSkew() {
            return Duration.millis((long)Long.MAX_VALUE);
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.FieldAccess(value="row") @UnknownKeyFor @NonNull @Initialized Row row, @DoFn.Timestamp @UnknownKeyFor @NonNull @Initialized Instant t, @UnknownKeyFor @NonNull @Initialized BoundedWindow w, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> r) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            HashMap<String, Value> columns = new HashMap<String, Value>();
            for (int i : this.referencedColumns) {
                Schema.Field field = this.inputSchema.getField(i);
                columns.put(BeamZetaSqlCalcRel.columnName(i), ZetaSqlBeamTranslationUtils.toZetaSqlValue(row.getBaseValue(field.getName(), Object.class), field.getType()));
            }
            @NonNull ListenableFuture valueFuture = ((PreparedExpression.Stream)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)this.stream)).execute(columns, this.nullParams);
            @Nullable Queue<TimestampedFuture> pendingWindow = this.pending.get(w);
            if (pendingWindow == null) {
                pendingWindow = new ArrayDeque<TimestampedFuture>();
                this.pending.put(w, pendingWindow);
            }
            pendingWindow.add(TimestampedFuture.create(t, (Future)valueFuture));
            while (!pendingWindow.isEmpty() && pendingWindow.element().future().isDone() || pendingWindow.size() > 32) {
                this.outputRow(pendingWindow.remove(), r);
            }
        }

        @DoFn.FinishBundle
        public void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            ((PreparedExpression.Stream)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)this.stream)).flush();
            for (Map.Entry<BoundedWindow, Queue<TimestampedFuture>> pendingWindow : this.pending.entrySet()) {
                OutputReceiverForFinishBundle rowOutputReciever = new OutputReceiverForFinishBundle(c, pendingWindow.getKey());
                for (TimestampedFuture timestampedFuture : pendingWindow.getValue()) {
                    this.outputRow(timestampedFuture, rowOutputReciever);
                }
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized RuntimeException extractException(@UnknownKeyFor @NonNull @Initialized ExecutionException e) {
            try {
                throw (Throwable)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)e.getCause());
            }
            catch (RuntimeException r) {
                return r;
            }
            catch (Throwable t) {
                return new RuntimeException(t);
            }
        }

        private void outputRow(@UnknownKeyFor @NonNull @Initialized TimestampedFuture c, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Row> r) throws @UnknownKeyFor @NonNull @Initialized InterruptedException {
            Value v;
            try {
                v = c.future().get();
            }
            catch (ExecutionException e) {
                throw CalcFn.extractException(e);
            }
            if (!v.isNull()) {
                Row row = ZetaSqlBeamTranslationUtils.toBeamRow(v, this.outputSchema, this.verifyRowValues);
                r.outputWithTimestamp((Object)row, c.timestamp());
            }
        }

        @DoFn.Teardown
        public void teardown() {
            ((PreparedExpression.Stream)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)this.stream)).close();
            this.exp.close();
        }

        private static class OutputReceiverForFinishBundle
        implements DoFn.OutputReceiver<Row> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c;
            private final @UnknownKeyFor @NonNull @Initialized BoundedWindow w;

            private OutputReceiverForFinishBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c, @UnknownKeyFor @NonNull @Initialized BoundedWindow w) {
                this.c = c;
                this.w = w;
            }

            public void output(@UnknownKeyFor @NonNull @Initialized Row output) {
                throw new RuntimeException("Unsupported");
            }

            public void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized Row output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                this.c.output((Object)output, timestamp, this.w);
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollectionList<@UnknownKeyFor @NonNull @Initialized Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"%s expected a single input PCollection, but received %d.", (Object)BeamZetaSqlCalcRel.class.getSimpleName(), (int)pinput.size());
            PCollection upstream = pinput.get(0);
            RexBuilder rexBuilder = BeamZetaSqlCalcRel.this.getCluster().getRexBuilder();
            RexNode rex = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.ROW, BeamZetaSqlCalcRel.this.getProgram().getProjectList());
            RexLocalRef condition = BeamZetaSqlCalcRel.this.getProgram().getCondition();
            if (condition != null) {
                rex = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.CASE, new RexNode[]{condition, rex, rexBuilder.makeNullLiteral(BeamZetaSqlCalcRel.this.getRowType())});
            }
            BeamSqlPipelineOptions options = (BeamSqlPipelineOptions)pinput.getPipeline().getOptions().as(BeamSqlPipelineOptions.class);
            Schema outputSchema = CalciteUtils.toSchema((RelDataType)BeamZetaSqlCalcRel.this.getRowType());
            CalcFn calcFn = new CalcFn(BeamZetaSqlCalcRel.this.context.toSql(BeamZetaSqlCalcRel.this.getProgram(), rex).toSqlString(DIALECT).getSql(), BeamZetaSqlCalcRel.createNullParams(BeamZetaSqlCalcRel.this.context.getNullParams()), upstream.getSchema(), outputSchema, options.getZetaSqlDefaultTimezone(), options.getVerifyRowValues());
            return ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
        }
    }

    @AutoValue
    static abstract class TimestampedFuture {
        TimestampedFuture() {
        }

        private static @UnknownKeyFor @NonNull @Initialized TimestampedFuture create(@UnknownKeyFor @NonNull @Initialized Instant t, @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @NonNull @Initialized Value> f) {
            return new AutoValue_BeamZetaSqlCalcRel_TimestampedFuture(t, f);
        }

        abstract @UnknownKeyFor @NonNull @Initialized Instant timestamp();

        abstract @UnknownKeyFor @NonNull @Initialized Future<@UnknownKeyFor @NonNull @Initialized Value> future();
    }
}

