/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelCollationImpl;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelFieldCollation;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.logical.LogicalSort;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

class LimitOffsetScanToOrderByLimitConverter
extends RelConverter<ResolvedNodes.ResolvedLimitOffsetScan> {
    LimitOffsetScanToOrderByLimitConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedLimitOffsetScan zetaNode) {
        return zetaNode.getInputScan() instanceof ResolvedNodes.ResolvedOrderByScan;
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedLimitOffsetScan zetaNode) {
        return Collections.singletonList(((ResolvedNodes.ResolvedOrderByScan)zetaNode.getInputScan()).getInputScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedLimitOffsetScan zetaNode, List<RelNode> inputs) {
        ResolvedNodes.ResolvedOrderByScan inputOrderByScan = (ResolvedNodes.ResolvedOrderByScan)zetaNode.getInputScan();
        RelNode input = inputs.get(0);
        RelCollation relCollation = LimitOffsetScanToOrderByLimitConverter.getRelCollation(inputOrderByScan);
        RexNode offset = zetaNode.getOffset() == null ? null : this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getOffset());
        RexNode fetch = this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getLimit(), (List<ResolvedColumn>)zetaNode.getColumnList(), input.getRowType().getFieldList(), (Map<String, RexNode>)ImmutableMap.of());
        if (RexLiteral.isNullLiteral((RexNode)offset) || RexLiteral.isNullLiteral((RexNode)fetch)) {
            throw new UnsupportedOperationException("Limit requires non-null count and offset");
        }
        LogicalSort sorted = LogicalSort.create((RelNode)input, (RelCollation)relCollation, (RexNode)offset, (RexNode)fetch);
        return this.convertOrderByScanToLogicalScan(inputOrderByScan, (RelNode)sorted);
    }

    private static RelCollation getRelCollation(ResolvedNodes.ResolvedOrderByScan node) {
        long inputOffset = ((ResolvedColumn)node.getInputScan().getColumnList().get(0)).getId();
        List fieldCollations = node.getOrderByItemList().stream().map(item -> LimitOffsetScanToOrderByLimitConverter.orderByItemToFieldCollation(item, inputOffset)).collect(Collectors.toList());
        return RelCollationImpl.of(fieldCollations);
    }

    private static RelFieldCollation orderByItemToFieldCollation(ResolvedNodes.ResolvedOrderByItem item, long inputOffset) {
        RelFieldCollation.Direction sortDirection = item.getIsDescending() ? RelFieldCollation.Direction.DESCENDING : RelFieldCollation.Direction.ASCENDING;
        long fieldIndex = item.getColumnRef().getColumn().getId() - inputOffset;
        return new RelFieldCollation((int)fieldIndex, sortDirection);
    }

    private RelNode convertOrderByScanToLogicalScan(ResolvedNodes.ResolvedOrderByScan node, RelNode input) {
        List<RexNode> projects = this.getExpressionConverter().retrieveRexNodeFromOrderByScan(this.getCluster(), node, input.getRowType().getFieldList());
        List<String> fieldNames = this.getTrait().retrieveFieldNames((List<ResolvedColumn>)node.getColumnList());
        return LogicalProject.create((RelNode)input, (List)ImmutableList.of(), projects, fieldNames);
    }
}

