/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.LanguageOptions;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCatalog;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ExpressionConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.QueryStatementConverter;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexExecutor;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.tools.Program;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.Util;

class ZetaSQLPlannerImpl {
    private final SchemaPlus defaultSchemaPlus;
    private final FrameworkConfig config;
    private RelOptPlanner planner;
    private JavaTypeFactory typeFactory;
    private final RexExecutor executor;
    private final ImmutableList<Program> programs;
    private String defaultTimezone = "UTC";

    ZetaSQLPlannerImpl(FrameworkConfig config) {
        this.config = config;
        this.executor = config.getExecutor();
        this.programs = config.getPrograms();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            Util.discard((Object)rootSchema);
            this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
            this.planner = cluster.getPlanner();
            this.planner.setExecutor(this.executor);
            return null;
        }, (FrameworkConfig)config);
        this.defaultSchemaPlus = config.getDefaultSchema();
    }

    public RelRoot rel(String sql, QueryPlanner.QueryParameters params) {
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)this.typeFactory));
        AnalyzerOptions options = SqlAnalyzer.getAnalyzerOptions(params, this.defaultTimezone);
        BeamZetaSqlCatalog catalog = BeamZetaSqlCatalog.create(this.defaultSchemaPlus, (JavaTypeFactory)cluster.getTypeFactory(), options);
        SqlAnalyzer analyzer = new SqlAnalyzer();
        List<List<String>> tables = analyzer.extractTableNames(sql, options);
        TableResolution.registerTables(this.defaultSchemaPlus, tables);
        QueryTrait trait = new QueryTrait();
        catalog.addTables(tables, trait);
        ResolvedNodes.ResolvedQueryStmt statement = analyzer.analyzeQuery(sql, options, catalog);
        ExpressionConverter expressionConverter = new ExpressionConverter(cluster, params, catalog.getUserFunctionDefinitions());
        ConversionContext context = ConversionContext.of(this.config, expressionConverter, cluster, trait);
        RelNode convertedNode = QueryStatementConverter.convertRootQuery(context, statement);
        return RelRoot.of((RelNode)convertedNode, (SqlKind)SqlKind.ALL);
    }

    RelNode transform(int i, RelTraitSet relTraitSet, RelNode relNode) {
        Program program = (Program)this.programs.get(i);
        return program.run(this.planner, relNode, relTraitSet, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    String getDefaultTimezone() {
        return this.defaultTimezone;
    }

    void setDefaultTimezone(String timezone) {
        this.defaultTimezone = timezone;
    }

    static LanguageOptions getLanguageOptions() {
        return SqlAnalyzer.baseAnalyzerOptions().getLanguageOptions();
    }
}

