/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.unnest;

import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelMetadataQuery;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.ZetaSqlUnnest;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_28_0.com.google.common.base.Preconditions;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;

public class BeamZetaSqlUncollectRel
extends ZetaSqlUnnest
implements BeamRelNode {
    public BeamZetaSqlUncollectRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, boolean withOrdinality) {
        super(cluster, traitSet, input, withOrdinality);
    }

    @Override
    public RelNode copy(RelTraitSet traitSet, RelNode input) {
        return new BeamZetaSqlUncollectRel(this.getCluster(), traitSet, input, this.withOrdinality);
    }

    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    public NodeStats estimateNodeStats(BeamRelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats((RelNode)this.input, (BeamRelMetadataQuery)mq).multiply(2.0);
    }

    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, BeamRelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats((RelNode)this, (BeamRelMetadataQuery)mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    private static class UncollectDoFn
    extends DoFn<Row, Row> {
        private final Schema schema;

        private UncollectDoFn(Schema schema) {
            this.schema = schema;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element Row inputRow, DoFn.OutputReceiver<Row> output) {
            for (Object element : inputRow.getArray(0)) {
                output.output((Object)Row.withSchema((Schema)this.schema).addValue(element).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"Wrong number of inputs for %s: %s", (Object)BeamZetaSqlUncollectRel.class.getSimpleName(), pinput);
            PCollection upstream = pinput.get(0);
            Schema outputSchema = CalciteUtils.toSchema((RelDataType)BeamZetaSqlUncollectRel.this.getRowType());
            PCollection uncollected = ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)new UncollectDoFn(outputSchema)))).setRowSchema(outputSchema);
            return uncollected;
        }
    }
}

