/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.StructType;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLType;
import com.google.zetasql.functions.ZetaSQLDateTime;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.SqlOperators;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.util.ByteString;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.util.TimeUnit;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.DateString;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.TimeString;
import org.apache.beam.vendor.calcite.v1_28_0.org.apache.calcite.util.TimestampString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

@Internal
public final class ZetaSqlCalciteTranslationUtils {
    public static final BigDecimal ZETASQL_NUMERIC_MAX_VALUE = new BigDecimal("99999999999999999999999999999.999999999");
    public static final BigDecimal ZETASQL_NUMERIC_MIN_VALUE = new BigDecimal("-99999999999999999999999999999.999999999");
    public static final int ZETASQL_NUMERIC_SCALE = 9;
    private static final ImmutableMap<Integer, TimeUnit> TIME_UNIT_CASTING_MAP = ImmutableMap.builder().put((Object)ZetaSQLDateTime.DateTimestampPart.YEAR.getNumber(), (Object)TimeUnit.YEAR).put((Object)ZetaSQLDateTime.DateTimestampPart.MONTH.getNumber(), (Object)TimeUnit.MONTH).put((Object)ZetaSQLDateTime.DateTimestampPart.DAY.getNumber(), (Object)TimeUnit.DAY).put((Object)ZetaSQLDateTime.DateTimestampPart.DAYOFWEEK.getNumber(), (Object)TimeUnit.DOW).put((Object)ZetaSQLDateTime.DateTimestampPart.DAYOFYEAR.getNumber(), (Object)TimeUnit.DOY).put((Object)ZetaSQLDateTime.DateTimestampPart.QUARTER.getNumber(), (Object)TimeUnit.QUARTER).put((Object)ZetaSQLDateTime.DateTimestampPart.HOUR.getNumber(), (Object)TimeUnit.HOUR).put((Object)ZetaSQLDateTime.DateTimestampPart.MINUTE.getNumber(), (Object)TimeUnit.MINUTE).put((Object)ZetaSQLDateTime.DateTimestampPart.SECOND.getNumber(), (Object)TimeUnit.SECOND).put((Object)ZetaSQLDateTime.DateTimestampPart.MILLISECOND.getNumber(), (Object)TimeUnit.MILLISECOND).put((Object)ZetaSQLDateTime.DateTimestampPart.MICROSECOND.getNumber(), (Object)TimeUnit.MICROSECOND).put((Object)ZetaSQLDateTime.DateTimestampPart.ISOYEAR.getNumber(), (Object)TimeUnit.ISOYEAR).put((Object)ZetaSQLDateTime.DateTimestampPart.ISOWEEK.getNumber(), (Object)TimeUnit.WEEK).build();

    private ZetaSqlCalciteTranslationUtils() {
    }

    public static Type toZetaSqlType(RelDataType calciteType) {
        switch (calciteType.getSqlTypeName()) {
            case BIGINT: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64);
            }
            case DOUBLE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE);
            }
            case BOOLEAN: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BOOL);
            }
            case VARCHAR: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING);
            }
            case VARBINARY: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BYTES);
            }
            case DECIMAL: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_NUMERIC);
            }
            case DATE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATE);
            }
            case TIME: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIME);
            }
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATETIME);
            }
            case TIMESTAMP: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP);
            }
            case ARRAY: {
                return TypeFactory.createArrayType((Type)ZetaSqlCalciteTranslationUtils.toZetaSqlType(calciteType.getComponentType()));
            }
            case ROW: {
                return TypeFactory.createStructType((Collection)calciteType.getFieldList().stream().map(f -> new StructType.StructField(f.getName(), ZetaSqlCalciteTranslationUtils.toZetaSqlType(f.getType()))).collect(Collectors.toList()));
            }
        }
        throw new UnsupportedOperationException("Unknown Calcite type: " + calciteType.getSqlTypeName().getName());
    }

    public static RelDataType toCalciteType(Type type, boolean nullable, RexBuilder rexBuilder) {
        RelDataType nonNullType;
        switch (type.getKind()) {
            case TYPE_INT64: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
                break;
            }
            case TYPE_DOUBLE: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DOUBLE);
                break;
            }
            case TYPE_BOOL: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.BOOLEAN);
                break;
            }
            case TYPE_STRING: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
                break;
            }
            case TYPE_BYTES: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.VARBINARY);
                break;
            }
            case TYPE_NUMERIC: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DECIMAL);
                break;
            }
            case TYPE_DATE: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.DATE);
                break;
            }
            case TYPE_TIME: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIME);
                break;
            }
            case TYPE_DATETIME: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE);
                break;
            }
            case TYPE_TIMESTAMP: {
                nonNullType = rexBuilder.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
                break;
            }
            case TYPE_ARRAY: {
                nonNullType = ZetaSqlCalciteTranslationUtils.toCalciteArrayType(type.asArray().getElementType(), nullable, rexBuilder);
                break;
            }
            case TYPE_STRUCT: {
                nonNullType = ZetaSqlCalciteTranslationUtils.toCalciteStructType(type.asStruct(), nullable, rexBuilder);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unknown ZetaSQL type: " + type.getKind().name());
            }
        }
        return rexBuilder.getTypeFactory().createTypeWithNullability(nonNullType, nullable);
    }

    private static RelDataType toCalciteArrayType(Type elementType, boolean nullable, RexBuilder rexBuilder) {
        return rexBuilder.getTypeFactory().createArrayType(ZetaSqlCalciteTranslationUtils.toCalciteType(elementType, nullable, rexBuilder), -1L);
    }

    private static RelDataType toCalciteStructType(StructType structType, boolean nullable, RexBuilder rexBuilder) {
        com.google.common.collect.ImmutableList fields = structType.getFieldList();
        List<String> fieldNames = ZetaSqlCalciteTranslationUtils.getFieldNameList((List<StructType.StructField>)fields);
        List fieldTypes = fields.stream().map(f -> ZetaSqlCalciteTranslationUtils.toCalciteType(f.getType(), nullable, rexBuilder)).collect(Collectors.toList());
        return rexBuilder.getTypeFactory().createStructType(fieldTypes, fieldNames);
    }

    private static List<String> getFieldNameList(List<StructType.StructField> fields) {
        ImmutableList.Builder b = ImmutableList.builder();
        HashSet<String> usedName = new HashSet<String>();
        for (int i = 0; i < fields.size(); ++i) {
            String name = fields.get(i).getName();
            if ("".equals(name) || name.startsWith("_field_") || usedName.contains(name)) {
                name = "_field_" + (i + 1);
            }
            b.add((Object)name);
            usedName.add(name);
        }
        return b.build();
    }

    public static RexNode toRexNode(Value value, RexBuilder rexBuilder) {
        Type type = value.getType();
        if (value.isNull()) {
            return rexBuilder.makeNullLiteral(ZetaSqlCalciteTranslationUtils.toCalciteType(type, true, rexBuilder));
        }
        switch (type.getKind()) {
            case TYPE_INT64: {
                return rexBuilder.makeExactLiteral(new BigDecimal(value.getInt64Value()), ZetaSqlCalciteTranslationUtils.toCalciteType(type, false, rexBuilder));
            }
            case TYPE_DOUBLE: {
                double val = value.getDoubleValue();
                String wrapperFun = null;
                if (val == Double.POSITIVE_INFINITY) {
                    wrapperFun = "double_positive_inf";
                } else if (val == Double.NEGATIVE_INFINITY) {
                    wrapperFun = "double_negative_inf";
                } else if (Double.isNaN(val)) {
                    wrapperFun = "double_nan";
                }
                RelDataType returnType = ZetaSqlCalciteTranslationUtils.toCalciteType(type, false, rexBuilder);
                if (wrapperFun == null) {
                    return rexBuilder.makeApproxLiteral(new BigDecimal(val), returnType);
                }
                if ("double_nan".equals(wrapperFun)) {
                    return rexBuilder.makeCall((SqlOperator)SqlOperators.createZetaSqlFunction(wrapperFun, returnType.getSqlTypeName()), new RexNode[]{rexBuilder.makeApproxLiteral(BigDecimal.valueOf(Math.random()), returnType)});
                }
                return rexBuilder.makeCall((SqlOperator)SqlOperators.createZetaSqlFunction(wrapperFun, returnType.getSqlTypeName()), new RexNode[0]);
            }
            case TYPE_BOOL: {
                return rexBuilder.makeLiteral(value.getBoolValue());
            }
            case TYPE_STRING: {
                return rexBuilder.makeLiteral((Object)value.getStringValue(), ZetaSqlCalciteTranslationUtils.toCalciteType(type, false, rexBuilder), true);
            }
            case TYPE_BYTES: {
                return rexBuilder.makeBinaryLiteral(new ByteString(value.getBytesValue().toByteArray()));
            }
            case TYPE_NUMERIC: {
                return rexBuilder.makeCall((SqlOperator)SqlOperators.createZetaSqlFunction("numeric_literal", ZetaSqlCalciteTranslationUtils.toCalciteType(type, false, rexBuilder).getSqlTypeName()), new RexNode[]{rexBuilder.makeExactLiteral(value.getNumericValue(), ZetaSqlCalciteTranslationUtils.toCalciteType(type, false, rexBuilder))});
            }
            case TYPE_DATE: {
                return rexBuilder.makeDateLiteral(ZetaSqlCalciteTranslationUtils.dateValueToDateString(value));
            }
            case TYPE_TIME: {
                return rexBuilder.makeTimeLiteral(ZetaSqlCalciteTranslationUtils.timeValueToTimeString(value), rexBuilder.getTypeFactory().getTypeSystem().getMaxPrecision(SqlTypeName.TIME));
            }
            case TYPE_DATETIME: {
                return rexBuilder.makeTimestampWithLocalTimeZoneLiteral(ZetaSqlCalciteTranslationUtils.datetimeValueToTimestampString(value), rexBuilder.getTypeFactory().getTypeSystem().getMaxPrecision(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
            }
            case TYPE_TIMESTAMP: {
                return rexBuilder.makeTimestampLiteral(ZetaSqlCalciteTranslationUtils.timestampValueToTimestampString(value), rexBuilder.getTypeFactory().getTypeSystem().getMaxPrecision(SqlTypeName.TIMESTAMP));
            }
            case TYPE_ARRAY: {
                return ZetaSqlCalciteTranslationUtils.arrayValueToRexNode(value, rexBuilder);
            }
            case TYPE_STRUCT: {
                return ZetaSqlCalciteTranslationUtils.structValueToRexNode(value, rexBuilder);
            }
            case TYPE_ENUM: {
                return ZetaSqlCalciteTranslationUtils.enumValueToRexNode(value, rexBuilder);
            }
        }
        throw new UnsupportedOperationException("Unknown ZetaSQL type: " + type.getKind().name());
    }

    private static RexNode arrayValueToRexNode(Value value, RexBuilder rexBuilder) {
        return rexBuilder.makeCall(ZetaSqlCalciteTranslationUtils.toCalciteArrayType(value.getType().asArray().getElementType(), value.getElementList().stream().anyMatch(v -> v.isNull()), rexBuilder), (SqlOperator)SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR, value.getElementList().stream().map(v -> ZetaSqlCalciteTranslationUtils.toRexNode(v, rexBuilder)).collect(Collectors.toList()));
    }

    private static RexNode structValueToRexNode(Value value, RexBuilder rexBuilder) {
        return rexBuilder.makeCall(ZetaSqlCalciteTranslationUtils.toCalciteStructType(value.getType().asStruct(), false, rexBuilder), (SqlOperator)SqlStdOperatorTable.ROW, value.getFieldList().stream().map(v -> ZetaSqlCalciteTranslationUtils.toRexNode(v, rexBuilder)).collect(Collectors.toList()));
    }

    private static RexNode enumValueToRexNode(Value value, RexBuilder rexBuilder) {
        String enumDescriptorName = value.getType().asEnum().getDescriptor().getFullName();
        if (!"zetasql.functions.DateTimestampPart".equals(enumDescriptorName)) {
            throw new UnsupportedOperationException("Unknown ZetaSQL Enum type: " + enumDescriptorName);
        }
        TimeUnit timeUnit = (TimeUnit)TIME_UNIT_CASTING_MAP.get((Object)value.getEnumValue());
        if (timeUnit == null) {
            throw new UnsupportedOperationException("Unknown ZetaSQL Enum value: " + value.getEnumName());
        }
        return rexBuilder.makeFlag((Enum)TimeUnitRange.of((TimeUnit)timeUnit, null));
    }

    private static DateString dateValueToDateString(Value value) {
        return DateString.fromDaysSinceEpoch((int)value.getDateValue());
    }

    private static TimeString timeValueToTimeString(Value value) {
        LocalTime localTime = value.getLocalTimeValue();
        return new TimeString(localTime.getHour(), localTime.getMinute(), localTime.getSecond()).withNanos(localTime.getNano());
    }

    private static TimestampString datetimeValueToTimestampString(Value value) {
        LocalDateTime dateTime = value.getLocalDateTimeValue();
        return new TimestampString(dateTime.getYear(), dateTime.getMonthValue(), dateTime.getDayOfMonth(), dateTime.getHour(), dateTime.getMinute(), dateTime.getSecond()).withNanos(dateTime.getNano());
    }

    private static TimestampString timestampValueToTimestampString(Value value) {
        long micros = value.getTimestampUnixMicros();
        if (micros % 1000L != 0L) {
            throw new UnsupportedOperationException(String.format("%s has sub-millisecond precision, which Beam ZetaSQL does not currently support.", micros));
        }
        return TimestampString.fromMillisSinceEpoch((long)(micros / 1000L));
    }
}

