/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation.impl;

import java.util.TimeZone;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.zetasql.DateTimeUtils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Internal
public class DateFunctions {
    public DateTime date(Integer year, Integer month, Integer day) {
        return DateTimeUtils.parseDate(String.join((CharSequence)"-", year.toString(), month.toString(), day.toString()));
    }

    public DateTime date(DateTime ts) {
        return this.date(ts, "UTC");
    }

    public DateTime date(DateTime ts, String timezone) {
        return ts.withZoneRetainFields(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timezone)));
    }
}

