/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import java.util.ArrayList;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.rel.type.RelRecordType;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlCallBinding;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_26_0.org.apache.calcite.sql.validate.SqlValidator;

class SqlWindowTableFunction
extends SqlFunction {
    public static final SqlReturnTypeInference ARG0_TABLE_FUNCTION_WINDOWING = opBinding -> {
        RelDataType inputRowType = opBinding.getOperandType(0);
        ArrayList<RelDataTypeFieldImpl> newFields = new ArrayList<RelDataTypeFieldImpl>(inputRowType.getFieldList());
        RelDataType timestampType = opBinding.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
        RelDataTypeFieldImpl windowStartField = new RelDataTypeFieldImpl("window_start", newFields.size(), timestampType);
        newFields.add(windowStartField);
        RelDataTypeFieldImpl windowEndField = new RelDataTypeFieldImpl("window_end", newFields.size(), timestampType);
        newFields.add(windowEndField);
        return new RelRecordType(inputRowType.getStructKind(), newFields);
    };

    public SqlWindowTableFunction(String name) {
        super(name, SqlKind.OTHER_FUNCTION, ARG0_TABLE_FUNCTION_WINDOWING, null, null, SqlFunctionCategory.SYSTEM);
    }

    public SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)3);
    }

    public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        return true;
    }

    private boolean throwValidationSignatureErrorOrReturnFalse(SqlCallBinding callBinding, boolean throwOnFailure) {
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    public String getAllowedSignatures(String opNameToUse) {
        return this.getName() + "(TABLE table_name, DESCRIPTOR(col1, col2 ...), datetime interval)";
    }

    public boolean argumentMustBeScalar(int ordinal) {
        return ordinal != 0;
    }
}

