/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.ZetaSqlUnnest;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.CorrelationId;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

class ArrayScanToJoinConverter
extends RelConverter<ResolvedNodes.ResolvedArrayScan> {
    ArrayScanToJoinConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedArrayScan zetaNode) {
        return zetaNode.getArrayExpr() instanceof ResolvedNodes.ResolvedColumnRef && zetaNode.getInputScan() != null && zetaNode.getJoinExpr() != null;
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedArrayScan zetaNode) {
        return Collections.singletonList(zetaNode.getInputScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedArrayScan zetaNode, List<RelNode> inputs) {
        boolean ordinality;
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        RelNode leftInput = inputs.get(0);
        ResolvedNodes.ResolvedColumnRef columnRef = (ResolvedNodes.ResolvedColumnRef)zetaNode.getArrayExpr();
        CorrelationId correlationId = this.getCluster().createCorrel();
        this.getCluster().getQuery().mapCorrel(correlationId.getName(), leftInput);
        String columnName = String.format("%s%s", zetaNode.getElementColumn().getTableName(), zetaNode.getElementColumn().getName());
        projects.add(this.getCluster().getRexBuilder().makeFieldAccess(this.getCluster().getRexBuilder().makeCorrel(leftInput.getRowType(), correlationId), this.getExpressionConverter().indexOfProjectionColumnRef(columnRef.getColumn().getId(), (List<ResolvedColumn>)zetaNode.getInputScan().getColumnList())));
        LogicalProject projectNode = LogicalProject.create((RelNode)ArrayScanToJoinConverter.createOneRow(this.getCluster()), projects, (List)ImmutableList.of((Object)columnName));
        boolean bl = ordinality = zetaNode.getArrayOffsetColumn() != null;
        assert (zetaNode.getElementColumn().getId() == 1L);
        assert (!ordinality || zetaNode.getArrayOffsetColumn().getColumn().getId() == 2L);
        ZetaSqlUnnest uncollectNode = ZetaSqlUnnest.create(projectNode.getTraitSet(), (RelNode)projectNode, ordinality);
        ArrayList<RexInputRef> rightProjects = new ArrayList<RexInputRef>();
        ArrayList<String> rightNames = new ArrayList<String>();
        rightProjects.add(this.getCluster().getRexBuilder().makeInputRef((RelNode)uncollectNode, 0));
        rightNames.add(columnName);
        if (ordinality) {
            rightProjects.add(this.getCluster().getRexBuilder().makeInputRef((RelNode)uncollectNode, 1));
            rightNames.add(String.format(zetaNode.getArrayOffsetColumn().getColumn().getTableName(), zetaNode.getArrayOffsetColumn().getColumn().getName()));
        }
        LogicalProject rightInput = LogicalProject.create((RelNode)uncollectNode, rightProjects, rightNames);
        RexNode condition = this.getExpressionConverter().convertRexNodeFromResolvedExpr(zetaNode.getJoinExpr());
        JoinRelType joinRelType = zetaNode.getIsOuter() ? JoinRelType.LEFT : JoinRelType.INNER;
        return LogicalJoin.create((RelNode)leftInput, (RelNode)rightInput, (RexNode)condition, (Set)ImmutableSet.of(), (JoinRelType)joinRelType);
    }
}

