/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.unnest;

import java.util.Collection;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.NodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamSqlRelUtils;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.ZetaSqlUnnest;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.JoinRelType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BeamZetaSqlUnnestRel
extends ZetaSqlUnnest
implements BeamRelNode {
    private final RelDataType unnestType;
    private final List<Integer> unnestIndices;

    public BeamZetaSqlUnnestRel(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RelDataType unnestType, List<Integer> unnestIndices) {
        super(cluster, traitSet, input, false);
        this.unnestType = unnestType;
        this.unnestIndices = unnestIndices;
    }

    public ZetaSqlUnnest copy(RelTraitSet traitSet, RelNode input) {
        return new BeamZetaSqlUnnestRel(this.getCluster(), traitSet, input, this.unnestType, this.unnestIndices);
    }

    @Override
    protected RelDataType deriveRowType() {
        return SqlValidatorUtil.deriveJoinRowType((RelDataType)this.input.getRowType(), (RelDataType)this.unnestType, (JoinRelType)JoinRelType.INNER, (RelDataTypeFactory)this.getCluster().getTypeFactory(), null, (List)ImmutableList.of());
    }

    public NodeStats estimateNodeStats(RelMetadataQuery mq) {
        return BeamSqlRelUtils.getNodeStats((RelNode)this.input, (RelMetadataQuery)mq).multiply(2.0);
    }

    public BeamCostModel beamComputeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        NodeStats estimates = BeamSqlRelUtils.getNodeStats((RelNode)this, (RelMetadataQuery)mq);
        return BeamCostModel.FACTORY.makeCost(estimates.getRowCount(), estimates.getRate());
    }

    @Override
    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("unnestIndices", this.unnestIndices);
    }

    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private static class UnnestFn
    extends DoFn<Row, Row> {
        private final Schema outputSchema;
        private final List<Integer> unnestIndices;

        private UnnestFn(Schema outputSchema, List<Integer> unnestIndices) {
            this.outputSchema = outputSchema;
            this.unnestIndices = unnestIndices;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element Row row, DoFn.OutputReceiver<Row> out) {
            Row rowWithArrayField = row;
            Schema schemaWithArrayField = this.outputSchema;
            for (int i = this.unnestIndices.size() - 1; i > 0; --i) {
                rowWithArrayField = rowWithArrayField.getRow(this.unnestIndices.get(i).intValue());
                schemaWithArrayField = schemaWithArrayField.getField(this.unnestIndices.get(i).intValue()).getType().getRowSchema();
            }
            @Nullable Collection rawValues = rowWithArrayField.getArray(this.unnestIndices.get(0).intValue());
            if (rawValues == null) {
                return;
            }
            for (Object uncollectedValue : rawValues) {
                out.output((Object)Row.withSchema((Schema)this.outputSchema).addValues(row.getBaseValues()).addValue(uncollectedValue).build());
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            PCollection outer = pinput.get(0);
            Schema joinedSchema = CalciteUtils.toSchema((RelDataType)BeamZetaSqlUnnestRel.this.getRowType());
            return ((PCollection)outer.apply((PTransform)ParDo.of((DoFn)new UnnestFn(joinedSchema, BeamZetaSqlUnnestRel.this.unnestIndices)))).setRowSchema(joinedSchema);
        }
    }
}

