/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.LanguageOptions;
import com.google.zetasql.Value;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.BeamSqlPipelineOptions;
import org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.planner.RelMdNodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamCalcRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamUncollectRule;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamUnnestRule;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCalcMergeRule;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCalcRule;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSQLPlannerImpl;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ZetaSqlScalarFunctionImpl;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.BeamZetaSqlUncollectRule;
import org.apache.beam.sdk.extensions.sql.zetasql.unnest.BeamZetaSqlUnnestRule;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.CallImplementor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.enumerable.RexImpTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRuleCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalCalc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rules.FilterCalcMergeRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rules.ProjectCalcMergeRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexInputRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLiteral;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RuleSets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZetaSQLQueryPlanner
implements QueryPlanner {
    public static final Collection<RelOptRule> DEFAULT_CALC = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.builder().add((Object[])new RelOptRule[]{BeamZetaSqlCalcRule.INSTANCE, BeamZetaSqlCalcMergeRule.INSTANCE}).build();
    private static final Logger LOG = LoggerFactory.getLogger(ZetaSQLQueryPlanner.class);
    private final ZetaSQLPlannerImpl plannerImpl;
    public static final QueryPlanner.Factory FACTORY = new QueryPlanner.Factory(){

        public QueryPlanner createPlanner(JdbcConnection jdbcConnection, Collection<RuleSet> ruleSets) {
            return new ZetaSQLQueryPlanner(jdbcConnection, ruleSets);
        }
    };

    public ZetaSQLQueryPlanner(FrameworkConfig config) {
        this.plannerImpl = new ZetaSQLPlannerImpl(config);
    }

    public ZetaSQLQueryPlanner(JdbcConnection jdbcConnection, Collection<RuleSet> ruleSets) {
        this.plannerImpl = new ZetaSQLPlannerImpl(ZetaSQLQueryPlanner.defaultConfig(jdbcConnection, ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(ruleSets, DEFAULT_CALC)));
        this.setDefaultTimezone(((BeamSqlPipelineOptions)jdbcConnection.getPipelineOptions().as(BeamSqlPipelineOptions.class)).getZetaSqlDefaultTimezone());
    }

    public static Collection<RuleSet> getZetaSqlRuleSets() {
        return ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(BeamRuleSets.getRuleSets(), DEFAULT_CALC);
    }

    public static Collection<RuleSet> getZetaSqlRuleSets(Collection<RelOptRule> calc) {
        return ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(BeamRuleSets.getRuleSets(), calc);
    }

    static boolean hasOnlyJavaUdfInProjects(RelOptRuleCall x) {
        List resList = x.getRelList();
        for (RelNode relNode : resList) {
            if (!(relNode instanceof LogicalCalc)) continue;
            LogicalCalc logicalCalc = (LogicalCalc)relNode;
            for (RexNode rexNode : logicalCalc.getProgram().getExprList()) {
                SqlTypeName typeName;
                if (rexNode instanceof RexCall) {
                    RexCall call = (RexCall)rexNode;
                    SqlOperator operator = call.getOperator();
                    CallImplementor implementor = RexImpTable.INSTANCE.get(operator);
                    if (implementor == null) {
                        return false;
                    }
                    if (operator instanceof SqlUserDefinedFunction) {
                        SqlUserDefinedFunction udf = (SqlUserDefinedFunction)call.op;
                        if (udf.function instanceof ZetaSqlScalarFunctionImpl) {
                            ZetaSqlScalarFunctionImpl scalarFunction = (ZetaSqlScalarFunctionImpl)udf.function;
                            if (scalarFunction.functionGroup.equals("user_defined_java_scalar_functions")) continue;
                            return false;
                        }
                        return false;
                    }
                    return false;
                }
                if (rexNode instanceof RexLiteral) {
                    typeName = ((RexLiteral)rexNode).getTypeName();
                    switch (typeName) {
                        case NULL: 
                        case BOOLEAN: 
                        case CHAR: 
                        case BINARY: 
                        case DECIMAL: {
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    continue;
                }
                if (rexNode instanceof RexInputRef) {
                    typeName = ((RexInputRef)rexNode).getType().getSqlTypeName();
                    switch (typeName) {
                        case BOOLEAN: 
                        case DECIMAL: 
                        case BIGINT: 
                        case DOUBLE: 
                        case VARCHAR: 
                        case VARBINARY: {
                            break;
                        }
                        default: {
                            return false;
                        }
                    }
                    continue;
                }
                return false;
            }
        }
        return true;
    }

    static boolean hasNoJavaUdfInProjects(RelOptRuleCall x) {
        List resList = x.getRelList();
        for (RelNode relNode : resList) {
            if (!(relNode instanceof LogicalCalc)) continue;
            LogicalCalc logicalCalc = (LogicalCalc)relNode;
            for (RexNode rexNode : logicalCalc.getProgram().getExprList()) {
                RexCall call;
                if (!(rexNode instanceof RexCall) || !((call = (RexCall)rexNode).getOperator() instanceof SqlUserDefinedFunction)) continue;
                SqlUserDefinedFunction udf = (SqlUserDefinedFunction)call.op;
                if (!(udf.function instanceof ZetaSqlScalarFunctionImpl)) continue;
                ZetaSqlScalarFunctionImpl scalarFunction = (ZetaSqlScalarFunctionImpl)udf.function;
                if (!scalarFunction.functionGroup.equals("user_defined_java_scalar_functions")) continue;
                return false;
            }
        }
        return true;
    }

    private static Collection<RuleSet> modifyRuleSetsForZetaSql(Collection<RuleSet> ruleSets, Collection<RelOptRule> calc) {
        ImmutableList.Builder ret = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.builder();
        for (RuleSet ruleSet : ruleSets) {
            ImmutableList.Builder bd = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.builder();
            for (RelOptRule rule : ruleSet) {
                if (rule instanceof JoinCommuteRule || rule instanceof FilterCalcMergeRule || rule instanceof ProjectCalcMergeRule) continue;
                if (rule instanceof BeamCalcRule) {
                    bd.addAll(calc);
                    continue;
                }
                if (rule instanceof BeamUnnestRule) {
                    bd.add((Object)BeamZetaSqlUnnestRule.INSTANCE);
                    continue;
                }
                if (rule instanceof BeamUncollectRule) {
                    bd.add((Object)BeamZetaSqlUncollectRule.INSTANCE);
                    continue;
                }
                bd.add((Object)rule);
            }
            ret.add((Object)RuleSets.ofList((Iterable)bd.build()));
        }
        return ret.build();
    }

    public String getDefaultTimezone() {
        return this.plannerImpl.getDefaultTimezone();
    }

    public void setDefaultTimezone(String timezone) {
        this.plannerImpl.setDefaultTimezone(timezone);
    }

    public static LanguageOptions getLanguageOptions() {
        return ZetaSQLPlannerImpl.getLanguageOptions();
    }

    public BeamRelNode convertToBeamRel(String sqlStatement) {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofNone());
    }

    public BeamRelNode convertToBeamRel(String sqlStatement, Map<String, Value> queryParams) throws ParseException, SqlConversionException {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofNamed(queryParams));
    }

    public BeamRelNode convertToBeamRel(String sqlStatement, List<Value> queryParams) throws ParseException, SqlConversionException {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofPositional(queryParams));
    }

    public BeamRelNode convertToBeamRel(String sqlStatement, QueryPlanner.QueryParameters queryParameters) throws ParseException, SqlConversionException {
        return this.convertToBeamRelInternal(sqlStatement, queryParameters);
    }

    public SqlNode parse(String sqlStatement) throws ParseException {
        throw new UnsupportedOperationException(String.format("%s.parse(String) is not implemented and should need be called", this.getClass().getCanonicalName()));
    }

    private BeamRelNode convertToBeamRelInternal(String sql, QueryPlanner.QueryParameters queryParams) {
        RelRoot root = this.plannerImpl.rel(sql, queryParams);
        RelTraitSet desiredTraits = root.rel.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE).replace((RelTrait)root.collation).simplify();
        root.rel.getCluster().setMetadataProvider(ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)CalciteQueryPlanner.NonCumulativeCostImpl.SOURCE, (Object)RelMdNodeStats.SOURCE, (Object)root.rel.getCluster().getMetadataProvider())));
        RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)root.rel.getCluster().getMetadataProvider()));
        root.rel.getCluster().invalidateMetadataQuery();
        BeamRelNode beamRelNode = (BeamRelNode)this.plannerImpl.transform(0, desiredTraits, root.rel);
        LOG.info("BEAMPlan>\n" + RelOptUtil.toString((RelNode)beamRelNode));
        return beamRelNode;
    }

    private static FrameworkConfig defaultConfig(JdbcConnection connection, Collection<RuleSet> ruleSets) {
        CalciteConnectionConfig config = connection.config();
        SqlParser.ConfigBuilder parserConfig = SqlParser.configBuilder().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()).setConformance(config.conformance()).setCaseSensitive(config.caseSensitive());
        SqlParserImplFactory parserFactory = (SqlParserImplFactory)config.parserFactory(SqlParserImplFactory.class, null);
        if (parserFactory != null) {
            parserConfig.setParserFactory(parserFactory);
        }
        SchemaPlus schema = connection.getRootSchema();
        SchemaPlus defaultSchema = connection.getCurrentSchemaPlus();
        org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList traitDefs = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)schema), (List)org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.of((Object)defaultSchema.getName()), (RelDataTypeFactory)connection.getTypeFactory(), connection.config());
        SqlOperatorTable opTab0 = (SqlOperatorTable)connection.config().fun(SqlOperatorTable.class, (Object)SqlStdOperatorTable.instance());
        return Frameworks.newConfigBuilder().parserConfig(parserConfig.build()).defaultSchema(defaultSchema).traitDefs((List)traitDefs).ruleSets(ruleSets.toArray(new RuleSet[0])).costFactory((RelOptCostFactory)BeamCostModel.FACTORY).typeSystem(connection.getTypeFactory().getTypeSystem()).operatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{opTab0, catalogReader})).build();
    }
}

