/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.unnest;

import java.util.List;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Convention;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelInput;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelWriter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.SingleRel;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlUtil;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.MapSqlType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ZetaSqlUnnest
extends SingleRel {
    public final @UnknownKeyFor @NonNull @Initialized boolean withOrdinality;

    public ZetaSqlUnnest(@UnknownKeyFor @NonNull @Initialized RelOptCluster cluster, @UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized boolean withOrdinality) {
        super(cluster, traitSet, input);
        this.withOrdinality = withOrdinality;
    }

    public ZetaSqlUnnest(@UnknownKeyFor @NonNull @Initialized RelInput input) {
        this(input.getCluster(), input.getTraitSet(), input.getInput(), input.getBoolean("withOrdinality", false));
    }

    public static @UnknownKeyFor @NonNull @Initialized ZetaSqlUnnest create(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input, @UnknownKeyFor @NonNull @Initialized boolean withOrdinality) {
        RelOptCluster cluster = input.getCluster();
        return new ZetaSqlUnnest(cluster, traitSet, input, withOrdinality);
    }

    public @UnknownKeyFor @NonNull @Initialized RelWriter explainTerms(@UnknownKeyFor @NonNull @Initialized RelWriter pw) {
        return super.explainTerms(pw).itemIf("withOrdinality", (Object)this.withOrdinality, this.withOrdinality);
    }

    public final @UnknownKeyFor @NonNull @Initialized RelNode copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized RelNode> inputs) {
        return this.copy(traitSet, (RelNode)ZetaSqlUnnest.sole(inputs));
    }

    public @UnknownKeyFor @NonNull @Initialized RelNode copy(@UnknownKeyFor @NonNull @Initialized RelTraitSet traitSet, @UnknownKeyFor @NonNull @Initialized RelNode input) {
        assert (traitSet.containsIfApplicable((RelTrait)Convention.NONE));
        return new ZetaSqlUnnest(this.getCluster(), traitSet, input, this.withOrdinality);
    }

    protected @UnknownKeyFor @NonNull @Initialized RelDataType deriveRowType() {
        return ZetaSqlUnnest.deriveUncollectRowType(this.input, this.withOrdinality);
    }

    public static @UnknownKeyFor @NonNull @Initialized RelDataType deriveUncollectRowType(@UnknownKeyFor @NonNull @Initialized RelNode rel, @UnknownKeyFor @NonNull @Initialized boolean withOrdinality) {
        RelDataType inputType = rel.getRowType();
        assert (inputType.isStruct()) : inputType + " is not a struct";
        List fields = inputType.getFieldList();
        RelDataTypeFactory typeFactory = rel.getCluster().getTypeFactory();
        RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
        if (fields.size() == 1 && ((RelDataTypeField)fields.get(0)).getType().getSqlTypeName() == SqlTypeName.ANY) {
            return builder.add(((RelDataTypeField)fields.get(0)).getName(), SqlTypeName.ANY).nullable(true).build();
        }
        for (RelDataTypeField field : fields) {
            if (field.getType() instanceof MapSqlType) {
                builder.add("KEY", field.getType().getKeyType());
                builder.add("VALUE", field.getType().getValueType());
                continue;
            }
            RelDataType ret = field.getType().getComponentType();
            assert (null != ret);
            builder.add(SqlUtil.deriveAliasFromOrdinal((int)field.getIndex()), ret);
        }
        if (withOrdinality) {
            builder.add("ORDINALITY", SqlTypeName.INTEGER);
        }
        return builder.build();
    }
}

