/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import java.util.ArrayList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFieldImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelRecordType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlCallBinding;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlValidator;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class SqlWindowTableFunction
extends SqlFunction {
    public static final @UnknownKeyFor @NonNull @Initialized SqlReturnTypeInference ARG0_TABLE_FUNCTION_WINDOWING = opBinding -> {
        RelDataType inputRowType = opBinding.getOperandType(0);
        ArrayList<RelDataTypeFieldImpl> newFields = new ArrayList<RelDataTypeFieldImpl>(inputRowType.getFieldList());
        RelDataType timestampType = opBinding.getTypeFactory().createSqlType(SqlTypeName.TIMESTAMP);
        RelDataTypeFieldImpl windowStartField = new RelDataTypeFieldImpl("window_start", newFields.size(), timestampType);
        newFields.add(windowStartField);
        RelDataTypeFieldImpl windowEndField = new RelDataTypeFieldImpl("window_end", newFields.size(), timestampType);
        newFields.add(windowEndField);
        return new RelRecordType(inputRowType.getStructKind(), newFields);
    };

    public SqlWindowTableFunction(@UnknownKeyFor @NonNull @Initialized String name) {
        super(name, SqlKind.OTHER_FUNCTION, ARG0_TABLE_FUNCTION_WINDOWING, null, null, SqlFunctionCategory.SYSTEM);
    }

    public @UnknownKeyFor @NonNull @Initialized SqlOperandCountRange getOperandCountRange() {
        return SqlOperandCountRanges.of((int)3);
    }

    public @UnknownKeyFor @NonNull @Initialized boolean checkOperandTypes(@UnknownKeyFor @NonNull @Initialized SqlCallBinding callBinding, @UnknownKeyFor @NonNull @Initialized boolean throwOnFailure) {
        SqlNode operand0 = callBinding.operand(0);
        SqlValidator validator = callBinding.getValidator();
        RelDataType type = validator.getValidatedNodeType(operand0);
        if (type.getSqlTypeName() != SqlTypeName.ROW) {
            return this.throwValidationSignatureErrorOrReturnFalse(callBinding, throwOnFailure);
        }
        return true;
    }

    private @UnknownKeyFor @NonNull @Initialized boolean throwValidationSignatureErrorOrReturnFalse(@UnknownKeyFor @NonNull @Initialized SqlCallBinding callBinding, @UnknownKeyFor @NonNull @Initialized boolean throwOnFailure) {
        if (throwOnFailure) {
            throw callBinding.newValidationSignatureError();
        }
        return false;
    }

    public @UnknownKeyFor @NonNull @Initialized String getAllowedSignatures(@UnknownKeyFor @NonNull @Initialized String opNameToUse) {
        return this.getName() + "(TABLE table_name, DESCRIPTOR(col1, col2 ...), datetime interval)";
    }

    public @UnknownKeyFor @NonNull @Initialized boolean argumentMustBeScalar(@UnknownKeyFor @NonNull @Initialized int ordinal) {
        return ordinal != 0;
    }
}

