/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.LanguageOptions;
import com.google.zetasql.ParseResumeLocation;
import com.google.zetasql.SimpleCatalog;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ExpressionConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.QueryStatementConverter;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.UserFunctionDefinitions;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptPlanner;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexExecutor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Program;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Util;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class ZetaSQLPlannerImpl {
    private final @UnknownKeyFor @NonNull @Initialized SchemaPlus defaultSchemaPlus;
    private final @UnknownKeyFor @NonNull @Initialized FrameworkConfig config;
    private @UnknownKeyFor @NonNull @Initialized RelOptPlanner planner;
    private @UnknownKeyFor @NonNull @Initialized JavaTypeFactory typeFactory;
    private final @UnknownKeyFor @NonNull @Initialized RexExecutor executor;
    private final @UnknownKeyFor @NonNull @Initialized ImmutableList<@UnknownKeyFor @NonNull @Initialized Program> programs;
    private @UnknownKeyFor @NonNull @Initialized String defaultTimezone = "UTC";

    ZetaSQLPlannerImpl(@UnknownKeyFor @NonNull @Initialized FrameworkConfig config) {
        this.config = config;
        this.executor = config.getExecutor();
        this.programs = config.getPrograms();
        Frameworks.withPlanner((cluster, relOptSchema, rootSchema) -> {
            Util.discard((Object)rootSchema);
            this.typeFactory = (JavaTypeFactory)cluster.getTypeFactory();
            this.planner = cluster.getPlanner();
            this.planner.setExecutor(this.executor);
            return null;
        }, (FrameworkConfig)config);
        this.defaultSchemaPlus = config.getDefaultSchema();
    }

    public @UnknownKeyFor @NonNull @Initialized RelRoot rel(@UnknownKeyFor @NonNull @Initialized String sql, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized QueryPlanner.QueryParameters params) {
        ResolvedNodes.ResolvedStatement statement;
        RelOptCluster cluster = RelOptCluster.create((RelOptPlanner)this.planner, (RexBuilder)new RexBuilder((RelDataTypeFactory)this.typeFactory));
        QueryTrait trait = new QueryTrait();
        SqlAnalyzer analyzer = new SqlAnalyzer(trait, this.defaultSchemaPlus, (JavaTypeFactory)cluster.getTypeFactory());
        AnalyzerOptions options = SqlAnalyzer.getAnalyzerOptions(params, this.defaultTimezone);
        List<List<String>> tables = analyzer.extractTableNames(sql, options);
        TableResolution.registerTables(this.defaultSchemaPlus, tables);
        SimpleCatalog catalog = analyzer.createPopulatedCatalog(this.defaultSchemaPlus.getName(), options, tables);
        ImmutableMap.Builder udfBuilder = ImmutableMap.builder();
        ImmutableMap.Builder udtvfBuilder = ImmutableMap.builder();
        ParseResumeLocation parseResumeLocation = new ParseResumeLocation(sql);
        do {
            if ((statement = analyzer.analyzeNextStatement(parseResumeLocation, options, catalog)).nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_FUNCTION_STMT) {
                ResolvedNodes.ResolvedCreateFunctionStmt createFunctionStmt = (ResolvedNodes.ResolvedCreateFunctionStmt)statement;
                udfBuilder.put((Object)createFunctionStmt.getNamePath(), (Object)createFunctionStmt);
                continue;
            }
            if (statement.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_TABLE_FUNCTION_STMT) {
                ResolvedNodes.ResolvedCreateTableFunctionStmt createTableFunctionStmt = (ResolvedNodes.ResolvedCreateTableFunctionStmt)statement;
                udtvfBuilder.put((Object)createTableFunctionStmt.getNamePath(), (Object)createTableFunctionStmt.getQuery());
                continue;
            }
            if (statement.nodeKind() != ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_QUERY_STMT) continue;
            if (SqlAnalyzer.isEndOfInput(parseResumeLocation)) break;
            throw new UnsupportedOperationException("No additional statements are allowed after a SELECT statement.");
        } while (!SqlAnalyzer.isEndOfInput(parseResumeLocation));
        if (!(statement instanceof ResolvedNodes.ResolvedQueryStmt)) {
            throw new UnsupportedOperationException("Statement list must end in a SELECT statement, not " + statement.nodeKindString());
        }
        UserFunctionDefinitions userFunctionDefinitions = new UserFunctionDefinitions((ImmutableMap<List<String>, ResolvedNodes.ResolvedCreateFunctionStmt>)udfBuilder.build(), (ImmutableMap<List<String>, ResolvedNode>)udtvfBuilder.build());
        ExpressionConverter expressionConverter = new ExpressionConverter(cluster, params, userFunctionDefinitions);
        ConversionContext context = ConversionContext.of(this.config, expressionConverter, cluster, trait);
        RelNode convertedNode = QueryStatementConverter.convertRootQuery(context, (ResolvedNodes.ResolvedQueryStmt)statement);
        return RelRoot.of((RelNode)convertedNode, (SqlKind)SqlKind.ALL);
    }

    @UnknownKeyFor @NonNull @Initialized RelNode transform(@UnknownKeyFor @NonNull @Initialized int i, @UnknownKeyFor @NonNull @Initialized RelTraitSet relTraitSet, @UnknownKeyFor @NonNull @Initialized RelNode relNode) {
        Program program = (Program)this.programs.get(i);
        return program.run(this.planner, relNode, relTraitSet, (List)ImmutableList.of(), (List)ImmutableList.of());
    }

    @UnknownKeyFor @NonNull @Initialized String getDefaultTimezone() {
        return this.defaultTimezone;
    }

    void setDefaultTimezone(@UnknownKeyFor @NonNull @Initialized String timezone) {
        this.defaultTimezone = timezone;
    }

    static @UnknownKeyFor @NonNull @Initialized LanguageOptions getLanguageOptions() {
        return SqlAnalyzer.baseAnalyzerOptions().getLanguageOptions();
    }
}

