/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation.impl;

import java.util.regex.Pattern;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.function.Strict;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.runtime.SqlFunctions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class StringFunctions {
    public static final @UnknownKeyFor @NonNull @Initialized String SUBSTR_PARAMETER_EXCEED_INTEGER = "SUBSTR function only allows: -2147483648 <= position or length <= 2147483647";
    private static final @UnknownKeyFor @NonNull @Initialized String JAVA_REGEX_SPECIALS = "[]()|^-+*?{}$\\.";

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized Boolean startsWith(@UnknownKeyFor @NonNull @Initialized String str1, @UnknownKeyFor @NonNull @Initialized String str2) {
        return str1.startsWith(str2);
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized Boolean endsWith(@UnknownKeyFor @NonNull @Initialized String str1, @UnknownKeyFor @NonNull @Initialized String str2) {
        return str1.endsWith(str2);
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String concat(@UnknownKeyFor @NonNull @Initialized String arg) {
        return arg;
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String concat(@UnknownKeyFor @NonNull @Initialized String arg1, @UnknownKeyFor @NonNull @Initialized String arg2) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2);
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String concat(@UnknownKeyFor @NonNull @Initialized String arg1, @UnknownKeyFor @NonNull @Initialized String arg2, @UnknownKeyFor @NonNull @Initialized String arg3) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2, arg3);
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String concat(@UnknownKeyFor @NonNull @Initialized String arg1, @UnknownKeyFor @NonNull @Initialized String arg2, @UnknownKeyFor @NonNull @Initialized String arg3, @UnknownKeyFor @NonNull @Initialized String arg4) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2, arg3, arg4);
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String concat(@UnknownKeyFor @NonNull @Initialized String arg1, @UnknownKeyFor @NonNull @Initialized String arg2, @UnknownKeyFor @NonNull @Initialized String arg3, @UnknownKeyFor @NonNull @Initialized String arg4, @UnknownKeyFor @NonNull @Initialized String arg5) {
        return StringFunctions.concatIfNotIncludeNull(arg1, arg2, arg3, arg4, arg5);
    }

    @Strict
    private static @UnknownKeyFor @NonNull @Initialized String concatIfNotIncludeNull(String ... args) {
        return String.join((CharSequence)"", args);
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String replace(@UnknownKeyFor @NonNull @Initialized String origin, @UnknownKeyFor @NonNull @Initialized String target, @UnknownKeyFor @NonNull @Initialized String replacement) {
        if (target.length() == 0) {
            return origin;
        }
        return origin.replace(target, replacement);
    }

    public static @UnknownKeyFor @NonNull @Initialized String trim(@UnknownKeyFor @NonNull @Initialized String str) {
        return StringFunctions.trim(str, " ");
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String trim(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized String seek) {
        return SqlFunctions.trim((boolean)true, (boolean)true, (String)seek, (String)str, (boolean)false);
    }

    public static @UnknownKeyFor @NonNull @Initialized String ltrim(@UnknownKeyFor @NonNull @Initialized String str) {
        return StringFunctions.ltrim(str, " ");
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String ltrim(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized String seek) {
        return SqlFunctions.trim((boolean)true, (boolean)false, (String)seek, (String)str, (boolean)false);
    }

    public static @UnknownKeyFor @NonNull @Initialized String rtrim(@UnknownKeyFor @NonNull @Initialized String str) {
        return StringFunctions.rtrim(str, " ");
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String rtrim(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized String seek) {
        return SqlFunctions.trim((boolean)false, (boolean)true, (String)seek, (String)str, (boolean)false);
    }

    public static @UnknownKeyFor @NonNull @Initialized String substr(@UnknownKeyFor @NonNull @Initialized String str, @UnknownKeyFor @NonNull @Initialized long from, @UnknownKeyFor @NonNull @Initialized long len) {
        if (from > Integer.MAX_VALUE || len > Integer.MAX_VALUE || from < Integer.MIN_VALUE || len < Integer.MIN_VALUE) {
            throw new RuntimeException(SUBSTR_PARAMETER_EXCEED_INTEGER);
        }
        return SqlFunctions.substring((String)str, (int)((int)from), (int)((int)len));
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized String reverse(@UnknownKeyFor @NonNull @Initialized String str) {
        return new StringBuilder(str).reverse().toString();
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized Long charLength(@UnknownKeyFor @NonNull @Initialized String str) {
        return str.length();
    }

    @Strict
    public static @UnknownKeyFor @NonNull @Initialized Boolean like(@UnknownKeyFor @NonNull @Initialized String s, @UnknownKeyFor @NonNull @Initialized String pattern) {
        String regex = StringFunctions.sqlToRegexLike(pattern, '\\');
        return Pattern.matches(regex, s);
    }

    private static @UnknownKeyFor @NonNull @Initialized String sqlToRegexLike(@UnknownKeyFor @NonNull @Initialized String sqlPattern, @UnknownKeyFor @NonNull @Initialized char escapeChar) {
        int len = sqlPattern.length();
        StringBuilder javaPattern = new StringBuilder(len + len);
        for (int i = 0; i < len; ++i) {
            char c = sqlPattern.charAt(i);
            if (c == escapeChar) {
                char nextChar;
                if (i == sqlPattern.length() - 1) {
                    throw new IllegalArgumentException("LIKE pattern ends with a backslash");
                }
                if (JAVA_REGEX_SPECIALS.indexOf(nextChar = sqlPattern.charAt(++i)) >= 0) {
                    javaPattern.append('\\');
                }
                javaPattern.append(nextChar);
                continue;
            }
            if (c == '_') {
                javaPattern.append('.');
                continue;
            }
            if (c == '%') {
                javaPattern.append("(?s:.*)");
                continue;
            }
            if (JAVA_REGEX_SPECIALS.indexOf(c) >= 0) {
                javaPattern.append('\\');
            }
            javaPattern.append(c);
        }
        return javaPattern.toString();
    }
}

