/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation.impl;

import java.util.TimeZone;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.zetasql.DateTimeUtils;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.linq4j.function.Strict;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

@Internal
public class TimestampFunctions {
    public static DateTime timestamp(String timestampStr) {
        return TimestampFunctions.timestamp(timestampStr, "UTC");
    }

    @Strict
    public static DateTime timestamp(String timestampStr, String timezone) {
        return DateTimeUtils.findDateTimePattern(timestampStr).withZone(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timezone))).parseDateTime(timestampStr);
    }

    @Strict
    public static DateTime timestamp(Integer numOfDays) {
        return TimestampFunctions.timestamp(numOfDays, "UTC");
    }

    @Strict
    public static DateTime timestamp(Integer numOfDays, String timezone) {
        return new DateTime((long)numOfDays.intValue() * DateTimeUtils.MILLIS_PER_DAY, DateTimeZone.UTC).withZoneRetainFields(DateTimeZone.forTimeZone((TimeZone)TimeZone.getTimeZone(timezone)));
    }
}

