/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.ScalarFunctionImpl;
import org.apache.beam.sdk.extensions.sql.impl.UdafImpl;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRelDataTypeSystem;
import org.apache.beam.sdk.extensions.sql.impl.udaf.StringAgg;
import org.apache.beam.sdk.extensions.sql.zetasql.DateTimeUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.impl.BeamBuiltinMethods;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.impl.CastFunctionImpl;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.jdbc.JavaTypeFactoryImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.AggregateFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Function;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.FunctionParameter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.ScalarFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlKind;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperator;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlSyntax;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.FamilyOperandTypeChecker;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.InferTypes;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.OperandTypes;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlUserDefinedAggFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Optionality;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.Util;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

@Internal
public class SqlOperators {
    public static final SqlOperator ZETASQL_TIMESTAMP_ADD = SqlOperators.createZetaSqlFunction("timestamp_add", SqlTypeName.TIMESTAMP);
    private static final RelDataType OTHER = SqlOperators.createSqlType(SqlTypeName.OTHER, false);
    private static final RelDataType TIMESTAMP = SqlOperators.createSqlType(SqlTypeName.TIMESTAMP, false);
    private static final RelDataType NULLABLE_TIMESTAMP = SqlOperators.createSqlType(SqlTypeName.TIMESTAMP, true);
    private static final RelDataType BIGINT = SqlOperators.createSqlType(SqlTypeName.BIGINT, false);
    private static final RelDataType NULLABLE_BIGINT = SqlOperators.createSqlType(SqlTypeName.BIGINT, true);
    public static final SqlOperator STRING_AGG_STRING_FN = SqlOperators.createUdafOperator("string_agg", x -> SqlOperators.createTypeFactory().createSqlType(SqlTypeName.VARCHAR), (AggregateFunction)new UdafImpl((Combine.CombineFn)new StringAgg.StringAggString()));
    public static final SqlOperator START_WITHS = SqlOperators.createUdfOperator("STARTS_WITH", BeamBuiltinMethods.STARTS_WITH_METHOD);
    public static final SqlOperator CONCAT = SqlOperators.createUdfOperator("CONCAT", BeamBuiltinMethods.CONCAT_METHOD);
    public static final SqlOperator REPLACE = SqlOperators.createUdfOperator("REPLACE", BeamBuiltinMethods.REPLACE_METHOD);
    public static final SqlOperator TRIM = SqlOperators.createUdfOperator("TRIM", BeamBuiltinMethods.TRIM_METHOD);
    public static final SqlOperator LTRIM = SqlOperators.createUdfOperator("LTRIM", BeamBuiltinMethods.LTRIM_METHOD);
    public static final SqlOperator RTRIM = SqlOperators.createUdfOperator("RTRIM", BeamBuiltinMethods.RTRIM_METHOD);
    public static final SqlOperator SUBSTR = SqlOperators.createUdfOperator("SUBSTR", BeamBuiltinMethods.SUBSTR_METHOD);
    public static final SqlOperator REVERSE = SqlOperators.createUdfOperator("REVERSE", BeamBuiltinMethods.REVERSE_METHOD);
    public static final SqlOperator CHAR_LENGTH = SqlOperators.createUdfOperator("CHAR_LENGTH", BeamBuiltinMethods.CHAR_LENGTH_METHOD);
    public static final SqlOperator ENDS_WITH = SqlOperators.createUdfOperator("ENDS_WITH", BeamBuiltinMethods.ENDS_WITH_METHOD);
    public static final SqlOperator LIKE = SqlOperators.createUdfOperator("LIKE", BeamBuiltinMethods.LIKE_METHOD, SqlSyntax.BINARY);
    public static final SqlOperator VALIDATE_TIMESTAMP = SqlOperators.createUdfOperator("validateTimestamp", DateTimeUtils.class, "validateTimestamp", x -> NULLABLE_TIMESTAMP, (List<RelDataType>)ImmutableList.of((Object)TIMESTAMP));
    public static final SqlOperator VALIDATE_TIME_INTERVAL = SqlOperators.createUdfOperator("validateIntervalArgument", DateTimeUtils.class, "validateTimeInterval", x -> NULLABLE_BIGINT, (List<RelDataType>)ImmutableList.of((Object)BIGINT, (Object)OTHER));
    public static final SqlOperator TIMESTAMP_OP = SqlOperators.createUdfOperator("TIMESTAMP", BeamBuiltinMethods.TIMESTAMP_METHOD);
    public static final SqlOperator DATE_OP = SqlOperators.createUdfOperator("DATE", BeamBuiltinMethods.DATE_METHOD);
    public static final SqlUserDefinedFunction CAST_OP = new SqlUserDefinedFunction(new SqlIdentifier("CAST", SqlParserPos.ZERO), null, null, null, null, (Function)new CastFunctionImpl());

    public static SqlFunction createZetaSqlFunction(String name, SqlTypeName returnType) {
        return new SqlFunction(name, SqlKind.OTHER_FUNCTION, x -> SqlOperators.createSqlType(returnType, true), null, null, SqlFunctionCategory.USER_DEFINED_FUNCTION);
    }

    private static SqlUserDefinedAggFunction createUdafOperator(String name, SqlReturnTypeInference returnTypeInference, AggregateFunction function) {
        return new SqlUserDefinedAggFunction(new SqlIdentifier(name, SqlParserPos.ZERO), returnTypeInference, null, null, function, false, false, Optionality.FORBIDDEN, SqlOperators.createTypeFactory());
    }

    private static SqlUserDefinedFunction createUdfOperator(String name, Class<?> methodClass, String methodName, SqlReturnTypeInference returnTypeInference, List<RelDataType> paramTypes) {
        return new SqlUserDefinedFunction(new SqlIdentifier(name, SqlParserPos.ZERO), returnTypeInference, null, null, paramTypes, ScalarFunctionImpl.create(methodClass, (String)methodName));
    }

    private static SqlUserDefinedFunction createUdfOperator(String name, Method method) {
        return SqlOperators.createUdfOperator(name, method, SqlSyntax.FUNCTION);
    }

    private static SqlUserDefinedFunction createUdfOperator(String name, Method method, final SqlSyntax syntax) {
        Function function = ScalarFunctionImpl.create((Method)method);
        RelDataTypeFactory typeFactory = SqlOperators.createTypeFactory();
        ArrayList<RelDataType> argTypes = new ArrayList<RelDataType>();
        ArrayList<SqlTypeFamily> typeFamilies = new ArrayList<SqlTypeFamily>();
        for (FunctionParameter o : function.getParameters()) {
            RelDataType type = o.getType(typeFactory);
            argTypes.add(type);
            typeFamilies.add((SqlTypeFamily)Util.first((Object)type.getSqlTypeName().getFamily(), (Object)SqlTypeFamily.ANY));
        }
        FamilyOperandTypeChecker typeChecker = OperandTypes.family(typeFamilies, i -> ((FunctionParameter)function.getParameters().get((int)i)).isOptional());
        List<RelDataType> paramTypes = SqlOperators.toSql(typeFactory, argTypes);
        return new SqlUserDefinedFunction(new SqlIdentifier(name, SqlParserPos.ZERO), SqlOperators.infer((ScalarFunction)function), InferTypes.explicit(argTypes), (SqlOperandTypeChecker)typeChecker, paramTypes, function){

            public SqlSyntax getSyntax() {
                return syntax;
            }
        };
    }

    private static RelDataType createSqlType(SqlTypeName typeName, boolean withNullability) {
        RelDataTypeFactory typeFactory = SqlOperators.createTypeFactory();
        RelDataType type = typeFactory.createSqlType(typeName);
        if (withNullability) {
            type = typeFactory.createTypeWithNullability(type, true);
        }
        return type;
    }

    private static RelDataTypeFactory createTypeFactory() {
        return new SqlTypeFactoryImpl(BeamRelDataTypeSystem.INSTANCE);
    }

    private static SqlReturnTypeInference infer(ScalarFunction function) {
        return opBinding -> {
            RelDataTypeFactory typeFactory = opBinding.getTypeFactory();
            RelDataType type = function instanceof ScalarFunctionImpl ? ((ScalarFunctionImpl)function).getReturnType(typeFactory, opBinding) : function.getReturnType(typeFactory);
            return SqlOperators.toSql(typeFactory, type);
        };
    }

    private static List<RelDataType> toSql(RelDataTypeFactory typeFactory, List<RelDataType> types) {
        return Lists.transform(types, type -> SqlOperators.toSql(typeFactory, type));
    }

    private static RelDataType toSql(RelDataTypeFactory typeFactory, RelDataType type) {
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return JavaTypeFactoryImpl.toSql((RelDataTypeFactory)typeFactory, (RelDataType)type);
    }
}

