/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.common.collect.ImmutableList;
import com.google.zetasql.ArrayType;
import com.google.zetasql.StructType;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.ZetaSQLType;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexBuilder;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.type.SqlTypeName;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

@Internal
public final class ZetaSqlCalciteTranslationUtils {
    private ZetaSqlCalciteTranslationUtils() {
    }

    public static Type toZetaType(RelDataType calciteType) {
        switch (calciteType.getSqlTypeName()) {
            case BIGINT: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64);
            }
            case DOUBLE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE);
            }
            case BOOLEAN: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BOOL);
            }
            case VARCHAR: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING);
            }
            case VARBINARY: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BYTES);
            }
            case DATE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DATE);
            }
            case TIME: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIME);
            }
            case TIMESTAMP: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP);
            }
            case ARRAY: {
                return TypeFactory.createArrayType((Type)ZetaSqlCalciteTranslationUtils.toZetaType(calciteType.getComponentType()));
            }
            case ROW: {
                List structFields = calciteType.getFieldList().stream().map(f -> new StructType.StructField(f.getName(), ZetaSqlCalciteTranslationUtils.toZetaType(f.getType()))).collect(Collectors.toList());
                return TypeFactory.createStructType(structFields);
            }
        }
        throw new UnsupportedOperationException("Unsupported RelDataType: " + calciteType);
    }

    public static SqlTypeName toCalciteTypeName(ZetaSQLType.TypeKind type) {
        switch (type) {
            case TYPE_INT64: {
                return SqlTypeName.BIGINT;
            }
            case TYPE_DOUBLE: {
                return SqlTypeName.DOUBLE;
            }
            case TYPE_BOOL: {
                return SqlTypeName.BOOLEAN;
            }
            case TYPE_STRING: {
                return SqlTypeName.VARCHAR;
            }
            case TYPE_BYTES: {
                return SqlTypeName.VARBINARY;
            }
            case TYPE_DATE: {
                return SqlTypeName.DATE;
            }
            case TYPE_TIME: {
                return SqlTypeName.TIME;
            }
            case TYPE_TIMESTAMP: {
                return SqlTypeName.TIMESTAMP;
            }
        }
        throw new UnsupportedOperationException("Unknown ZetaSQL type: " + type.name());
    }

    public static RelDataType toRelDataType(RexBuilder rexBuilder, Type type, boolean isNullable) {
        if (type.getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_ARRAY)) {
            return ZetaSqlCalciteTranslationUtils.toArrayRelDataType(rexBuilder, type.asArray(), isNullable);
        }
        if (type.getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_STRUCT)) {
            return ZetaSqlCalciteTranslationUtils.toStructRelDataType(rexBuilder, type.asStruct(), isNullable);
        }
        return ZetaSqlCalciteTranslationUtils.toSimpleRelDataType(type.getKind(), rexBuilder, isNullable);
    }

    public static RelDataType toArrayRelDataType(RexBuilder rexBuilder, ArrayType arrayType, boolean isNullable) {
        return rexBuilder.getTypeFactory().createArrayType(ZetaSqlCalciteTranslationUtils.toRelDataType(rexBuilder, arrayType.getElementType(), isNullable), -1L);
    }

    private static List<String> toNameList(List<StructType.StructField> fields) {
        ImmutableList.Builder b = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.builder();
        for (int i = 0; i < fields.size(); ++i) {
            String name = fields.get(i).getName();
            if ("".equals(name)) {
                name = "$col" + i;
            }
            b.add((Object)name);
        }
        return b.build();
    }

    public static RelDataType toStructRelDataType(RexBuilder rexBuilder, StructType structType, boolean isNullable) {
        ImmutableList fields = structType.getFieldList();
        List<String> fieldNames = ZetaSqlCalciteTranslationUtils.toNameList((List<StructType.StructField>)fields);
        List fieldTypes = fields.stream().map(f -> ZetaSqlCalciteTranslationUtils.toRelDataType(rexBuilder, f.getType(), isNullable)).collect(Collectors.toList());
        return rexBuilder.getTypeFactory().createStructType(fieldTypes, fieldNames);
    }

    public static RelDataType toSimpleRelDataType(ZetaSQLType.TypeKind kind, RexBuilder rexBuilder) {
        return ZetaSqlCalciteTranslationUtils.toSimpleRelDataType(kind, rexBuilder, true);
    }

    public static RelDataType toSimpleRelDataType(ZetaSQLType.TypeKind kind, RexBuilder rexBuilder, boolean isNullable) {
        RelDataType relDataType = ZetaSqlCalciteTranslationUtils.relDataTypeFactory(ZetaSqlCalciteTranslationUtils.toCalciteTypeName(kind)).apply(rexBuilder);
        return ZetaSqlCalciteTranslationUtils.nullable(rexBuilder, relDataType, isNullable);
    }

    private static RelDataType nullable(RexBuilder r, RelDataType relDataType, boolean isNullable) {
        return r.getTypeFactory().createTypeWithNullability(relDataType, isNullable);
    }

    private static Function<RexBuilder, RelDataType> relDataTypeFactory(SqlTypeName typeName) {
        return r -> r.getTypeFactory().createSqlType(typeName);
    }
}

