/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Uncollect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class ArrayScanToUncollectConverter
extends RelConverter<ResolvedNodes.ResolvedArrayScan> {
    ArrayScanToUncollectConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public boolean canConvert(ResolvedNodes.ResolvedArrayScan zetaNode) {
        return zetaNode.getInputScan() == null;
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedArrayScan zetaNode, List<RelNode> inputs) {
        RexNode arrayLiteralExpression = this.getExpressionConverter().convertResolvedLiteral((ResolvedNodes.ResolvedLiteral)zetaNode.getArrayExpr());
        String fieldName = String.format("%s%s", zetaNode.getElementColumn().getTableName(), zetaNode.getElementColumn().getName());
        LogicalProject projectNode = LogicalProject.create((RelNode)ArrayScanToUncollectConverter.createOneRow(this.getCluster()), Collections.singletonList(arrayLiteralExpression), (List)ImmutableList.of((Object)fieldName));
        return Uncollect.create((RelTraitSet)projectNode.getTraitSet(), (RelNode)projectNode, (boolean)false);
    }
}

