/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.Value;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.extensions.sql.impl.CalciteQueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.JdbcConnection;
import org.apache.beam.sdk.extensions.sql.impl.ParseException;
import org.apache.beam.sdk.extensions.sql.impl.QueryPlanner;
import org.apache.beam.sdk.extensions.sql.impl.SqlConversionException;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamCostModel;
import org.apache.beam.sdk.extensions.sql.impl.planner.BeamRuleSets;
import org.apache.beam.sdk.extensions.sql.impl.planner.RelMdNodeStats;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamLogicalConvention;
import org.apache.beam.sdk.extensions.sql.impl.rel.BeamRelNode;
import org.apache.beam.sdk.extensions.sql.impl.rule.BeamCalcRule;
import org.apache.beam.sdk.extensions.sql.zetasql.BeamZetaSqlCalcRule;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSQLPlannerImpl;
import org.apache.beam.vendor.calcite.v1_20_0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.jdbc.CalciteSchema;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.ConventionTraitDef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCostFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTrait;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.prepare.CalciteCatalogReader;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelRoot;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.ChainedRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.JaninoRelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rules.JoinCommuteRule;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParser;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserImplFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.util.ChainedSqlOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.FrameworkConfig;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.Frameworks;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RelConversionException;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RuleSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.tools.RuleSets;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class ZetaSQLQueryPlanner
implements QueryPlanner {
    private final ZetaSQLPlannerImpl plannerImpl;

    public ZetaSQLQueryPlanner(FrameworkConfig config) {
        this.plannerImpl = new ZetaSQLPlannerImpl(config);
    }

    public ZetaSQLQueryPlanner(JdbcConnection jdbcConnection, RuleSet[] ruleSets) {
        this.plannerImpl = new ZetaSQLPlannerImpl(this.defaultConfig(jdbcConnection, ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(ruleSets)));
    }

    public static RuleSet[] getZetaSqlRuleSets() {
        return ZetaSQLQueryPlanner.modifyRuleSetsForZetaSql(BeamRuleSets.getRuleSets());
    }

    private static RuleSet[] modifyRuleSetsForZetaSql(RuleSet[] ruleSets) {
        RuleSet[] ret = new RuleSet[ruleSets.length];
        for (int i = 0; i < ruleSets.length; ++i) {
            ImmutableList.Builder bd = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.builder();
            for (RelOptRule rule : ruleSets[i]) {
                if (rule instanceof JoinCommuteRule) continue;
                if (rule instanceof BeamCalcRule) {
                    bd.add((Object)BeamZetaSqlCalcRule.INSTANCE);
                    continue;
                }
                bd.add((Object)rule);
            }
            ret[i] = RuleSets.ofList((Iterable)bd.build());
        }
        return ret;
    }

    public BeamRelNode convertToBeamRel(String sqlStatement) {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofNone());
    }

    public BeamRelNode convertToBeamRel(String sqlStatement, Map<String, Value> queryParams) throws ParseException, SqlConversionException {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofNamed(queryParams));
    }

    public BeamRelNode convertToBeamRel(String sqlStatement, List<Value> queryParams) throws ParseException, SqlConversionException {
        return this.convertToBeamRel(sqlStatement, QueryPlanner.QueryParameters.ofPositional(queryParams));
    }

    public BeamRelNode convertToBeamRel(String sqlStatement, QueryPlanner.QueryParameters queryParameters) throws ParseException, SqlConversionException {
        try {
            return this.convertToBeamRelInternal(sqlStatement, queryParameters);
        }
        catch (RelConversionException e) {
            throw new SqlConversionException(e.getCause());
        }
    }

    public SqlNode parse(String sqlStatement) throws ParseException {
        throw new UnsupportedOperationException(String.format("%s.parse(String) is not implemented and should need be called", this.getClass().getCanonicalName()));
    }

    private BeamRelNode convertToBeamRelInternal(String sql, QueryPlanner.QueryParameters queryParams) throws RelConversionException {
        RelRoot root = this.plannerImpl.rel(sql, queryParams);
        RelTraitSet desiredTraits = root.rel.getTraitSet().replace((RelTrait)BeamLogicalConvention.INSTANCE).replace((RelTrait)root.collation).simplify();
        root.rel.getCluster().setMetadataProvider(ChainedRelMetadataProvider.of((List)ImmutableList.of((Object)CalciteQueryPlanner.NonCumulativeCostImpl.SOURCE, (Object)RelMdNodeStats.SOURCE, (Object)root.rel.getCluster().getMetadataProvider())));
        RelMetadataQuery.THREAD_PROVIDERS.set(JaninoRelMetadataProvider.of((RelMetadataProvider)root.rel.getCluster().getMetadataProvider()));
        root.rel.getCluster().invalidateMetadataQuery();
        return (BeamRelNode)this.plannerImpl.transform(0, desiredTraits, root.rel);
    }

    private FrameworkConfig defaultConfig(JdbcConnection connection, RuleSet[] ruleSets) {
        CalciteConnectionConfig config = connection.config();
        SqlParser.ConfigBuilder parserConfig = SqlParser.configBuilder().setQuotedCasing(config.quotedCasing()).setUnquotedCasing(config.unquotedCasing()).setQuoting(config.quoting()).setConformance(config.conformance()).setCaseSensitive(config.caseSensitive());
        SqlParserImplFactory parserFactory = (SqlParserImplFactory)config.parserFactory(SqlParserImplFactory.class, null);
        if (parserFactory != null) {
            parserConfig.setParserFactory(parserFactory);
        }
        SchemaPlus schema = connection.getRootSchema();
        SchemaPlus defaultSchema = connection.getCurrentSchemaPlus();
        org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList traitDefs = org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.of((Object)ConventionTraitDef.INSTANCE);
        CalciteCatalogReader catalogReader = new CalciteCatalogReader(CalciteSchema.from((SchemaPlus)schema), (List)org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList.of((Object)defaultSchema.getName()), (RelDataTypeFactory)connection.getTypeFactory(), connection.config());
        SqlOperatorTable opTab0 = (SqlOperatorTable)connection.config().fun(SqlOperatorTable.class, (Object)SqlStdOperatorTable.instance());
        return Frameworks.newConfigBuilder().parserConfig(parserConfig.build()).defaultSchema(defaultSchema).traitDefs((List)traitDefs).ruleSets(ruleSets).costFactory((RelOptCostFactory)BeamCostModel.FACTORY).typeSystem(connection.getTypeFactory().getTypeSystem()).operatorTable(ChainedSqlOperatorTable.of((SqlOperatorTable[])new SqlOperatorTable[]{opTab0, catalogReader})).build();
    }
}

