/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.PreparedExpression;
import com.google.zetasql.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.extensions.sql.impl.rel.AbstractBeamCalcRel;
import org.apache.beam.sdk.extensions.sql.impl.utils.CalciteUtils;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamBigQuerySqlDialect;
import org.apache.beam.sdk.extensions.sql.meta.provider.bigquery.BeamSqlUnparseContext;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlAnalyzer;
import org.apache.beam.sdk.extensions.sql.zetasql.ZetaSqlUtils;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelOptCluster;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.RelTraitSet;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.Calc;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexLocalRef;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexProgram;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlDialect;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlIdentifier;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

@Internal
public class BeamZetaSqlCalcRel
extends AbstractBeamCalcRel {
    private static final SqlDialect DIALECT = BeamBigQuerySqlDialect.DEFAULT;
    private final SqlImplementor.Context context;

    private static String columnName(int i) {
        return "_" + i;
    }

    public BeamZetaSqlCalcRel(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexProgram program) {
        super(cluster, traits, input, program);
        IntFunction<SqlNode> fn = i -> new SqlIdentifier(BeamZetaSqlCalcRel.columnName(i), SqlParserPos.ZERO);
        this.context = new BeamSqlUnparseContext(fn);
    }

    public Calc copy(RelTraitSet traitSet, RelNode input, RexProgram program) {
        return new BeamZetaSqlCalcRel(this.getCluster(), traitSet, input, program);
    }

    public PTransform<PCollectionList<Row>, PCollection<Row>> buildPTransform() {
        return new Transform();
    }

    private String unparseRexNode(RexNode rex) {
        return this.context.toSql(this.getProgram(), rex).toSqlString(DIALECT).getSql();
    }

    private static class CalcFn
    extends DoFn<Row, Row> {
        private final List<String> projects;
        @Nullable
        private final String condition;
        private final Schema inputSchema;
        private final Schema outputSchema;
        private transient List<PreparedExpression> projectExps;
        @Nullable
        private transient PreparedExpression conditionExp;

        CalcFn(List<String> projects, @Nullable String condition, Schema inputSchema, Schema outputSchema) {
            Preconditions.checkArgument((projects.size() == outputSchema.getFieldCount() ? 1 : 0) != 0);
            this.projects = ImmutableList.copyOf(projects);
            this.condition = condition;
            this.inputSchema = inputSchema;
            this.outputSchema = outputSchema;
        }

        @DoFn.Setup
        public void setup() {
            AnalyzerOptions options = SqlAnalyzer.initAnalyzerOptions();
            for (int i = 0; i < this.inputSchema.getFieldCount(); ++i) {
                options.addExpressionColumn(BeamZetaSqlCalcRel.columnName(i), ZetaSqlUtils.beamFieldTypeToZetaSqlType(this.inputSchema.getField(i).getType()));
            }
            this.projectExps = new ArrayList<PreparedExpression>();
            for (String project : this.projects) {
                PreparedExpression projectExp = new PreparedExpression(project);
                projectExp.prepare(options);
                this.projectExps.add(projectExp);
            }
            if (this.condition != null) {
                this.conditionExp = new PreparedExpression(this.condition);
                this.conditionExp.prepare(options);
            }
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            HashMap<String, Value> columns = new HashMap<String, Value>();
            Row row = (Row)c.element();
            for (int i = 0; i < this.inputSchema.getFieldCount(); ++i) {
                columns.put(BeamZetaSqlCalcRel.columnName(i), ZetaSqlUtils.javaObjectToZetaSqlValue(row.getValue(i), this.inputSchema.getField(i).getType()));
            }
            Map params = Collections.emptyMap();
            if (this.conditionExp != null && !this.conditionExp.execute(columns, params).getBoolValue()) {
                return;
            }
            Row.Builder output = Row.withSchema((Schema)this.outputSchema);
            for (int i = 0; i < this.outputSchema.getFieldCount(); ++i) {
                Value v = this.projectExps.get(i).execute(columns, params);
                output.addValue(ZetaSqlUtils.zetaSqlValueToJavaObject(v, this.outputSchema.getField(i).getType()));
            }
            c.output((Object)output.build());
        }

        @DoFn.Teardown
        public void teardown() {
            for (PreparedExpression projectExp : this.projectExps) {
                projectExp.close();
            }
            if (this.conditionExp != null) {
                this.conditionExp.close();
            }
        }
    }

    private class Transform
    extends PTransform<PCollectionList<Row>, PCollection<Row>> {
        private Transform() {
        }

        public PCollection<Row> expand(PCollectionList<Row> pinput) {
            Preconditions.checkArgument((pinput.size() == 1 ? 1 : 0) != 0, (String)"%s expected a single input PCollection, but received %d.", (Object)BeamZetaSqlCalcRel.class.getSimpleName(), (int)pinput.size());
            PCollection upstream = pinput.get(0);
            List<String> projects = BeamZetaSqlCalcRel.this.getProgram().getProjectList().stream().map(x$0 -> BeamZetaSqlCalcRel.this.unparseRexNode(x$0)).collect(Collectors.toList());
            RexLocalRef condition = BeamZetaSqlCalcRel.this.getProgram().getCondition();
            Schema outputSchema = CalciteUtils.toSchema((RelDataType)BeamZetaSqlCalcRel.this.getRowType());
            CalcFn calcFn = new CalcFn(projects, condition == null ? null : BeamZetaSqlCalcRel.this.unparseRexNode((RexNode)condition), upstream.getSchema(), outputSchema);
            calcFn.setup();
            return ((PCollection)upstream.apply((PTransform)ParDo.of((DoFn)calcFn))).setRowSchema(outputSchema);
        }
    }
}

