/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.common.collect.ImmutableList;
import com.google.protobuf.ByteString;
import com.google.zetasql.ArrayType;
import com.google.zetasql.StructType;
import com.google.zetasql.Type;
import com.google.zetasql.TypeFactory;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.math.LongMath;
import org.joda.time.Instant;

@Internal
public final class ZetaSqlUtils {
    private static final long MICROS_PER_MILLI = 1000L;

    private ZetaSqlUtils() {
    }

    public static Type beamFieldTypeToZetaSqlType(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case INT64: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_INT64);
            }
            case DECIMAL: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_NUMERIC);
            }
            case DOUBLE: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_DOUBLE);
            }
            case STRING: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_STRING);
            }
            case DATETIME: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_TIMESTAMP);
            }
            case BOOLEAN: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BOOL);
            }
            case BYTES: {
                return TypeFactory.createSimpleType((ZetaSQLType.TypeKind)ZetaSQLType.TypeKind.TYPE_BYTES);
            }
            case ARRAY: {
                return ZetaSqlUtils.createZetaSqlArrayTypeFromBeamElementFieldType(fieldType.getCollectionElementType());
            }
            case ROW: {
                return ZetaSqlUtils.createZetaSqlStructTypeFromBeamSchema(fieldType.getRowSchema());
            }
        }
        throw new IllegalArgumentException("Unsupported Beam fieldType: " + fieldType.getTypeName());
    }

    private static ArrayType createZetaSqlArrayTypeFromBeamElementFieldType(Schema.FieldType elementFieldType) {
        return TypeFactory.createArrayType((Type)ZetaSqlUtils.beamFieldTypeToZetaSqlType(elementFieldType));
    }

    private static StructType createZetaSqlStructTypeFromBeamSchema(Schema schema) {
        return TypeFactory.createStructType((Collection)schema.getFields().stream().map(ZetaSqlUtils::beamFieldToZetaSqlStructField).collect(Collectors.toList()));
    }

    private static StructType.StructField beamFieldToZetaSqlStructField(Schema.Field field) {
        return new StructType.StructField(field.getName(), ZetaSqlUtils.beamFieldTypeToZetaSqlType(field.getType()));
    }

    public static Value javaObjectToZetaSqlValue(Object object, Schema.FieldType fieldType) {
        if (object == null) {
            return Value.createNullValue((Type)ZetaSqlUtils.beamFieldTypeToZetaSqlType(fieldType));
        }
        switch (fieldType.getTypeName()) {
            case INT64: {
                return Value.createInt64Value((long)((Long)object));
            }
            case DOUBLE: {
                return Value.createDoubleValue((double)((Double)object));
            }
            case STRING: {
                return Value.createStringValue((String)((String)object));
            }
            case DATETIME: {
                return ZetaSqlUtils.jodaInstantToZetaSqlTimestampValue((Instant)object);
            }
            case BOOLEAN: {
                return Value.createBoolValue((boolean)((Boolean)object));
            }
            case BYTES: {
                return Value.createBytesValue((ByteString)ByteString.copyFrom((byte[])((byte[])object)));
            }
            case ARRAY: {
                return ZetaSqlUtils.javaListToZetaSqlArrayValue((List)object, fieldType.getCollectionElementType());
            }
            case ROW: {
                return ZetaSqlUtils.beamRowToZetaSqlStructValue((Row)object, fieldType.getRowSchema());
            }
        }
        throw new IllegalArgumentException("Unsupported Beam fieldType: " + fieldType.getTypeName());
    }

    private static Value jodaInstantToZetaSqlTimestampValue(Instant instant) {
        return ZetaSqlUtils.javaLongToZetaSqlTimestampValue(instant.getMillis());
    }

    private static Value javaLongToZetaSqlTimestampValue(Long millis) {
        return Value.createTimestampValueFromUnixMicros((long)LongMath.checkedMultiply((long)millis, (long)1000L));
    }

    private static Value javaListToZetaSqlArrayValue(List<Object> elements, Schema.FieldType elementType) {
        List values = elements.stream().map(e -> ZetaSqlUtils.javaObjectToZetaSqlValue(e, elementType)).collect(Collectors.toList());
        return Value.createArrayValue((ArrayType)ZetaSqlUtils.createZetaSqlArrayTypeFromBeamElementFieldType(elementType), values);
    }

    private static Value beamRowToZetaSqlStructValue(Row row, Schema schema) {
        ArrayList<Value> values = new ArrayList<Value>(row.getFieldCount());
        for (int i = 0; i < row.getFieldCount(); ++i) {
            values.add(ZetaSqlUtils.javaObjectToZetaSqlValue(row.getValue(i), schema.getField(i).getType()));
        }
        return Value.createStructValue((StructType)ZetaSqlUtils.createZetaSqlStructTypeFromBeamSchema(schema), values);
    }

    public static Object zetaSqlValueToJavaObject(Value value, Schema.FieldType fieldType) {
        if (value.isNull()) {
            return null;
        }
        switch (fieldType.getTypeName()) {
            case INT64: {
                return value.getInt64Value();
            }
            case DECIMAL: {
                return value.getNumericValue();
            }
            case DOUBLE: {
                if (value.getType().getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_INT64)) {
                    return (double)value.getInt64Value();
                }
                return value.getDoubleValue();
            }
            case STRING: {
                return value.getStringValue();
            }
            case DATETIME: {
                return ZetaSqlUtils.zetaSqlTimestampValueToJodaInstant(value);
            }
            case BOOLEAN: {
                return value.getBoolValue();
            }
            case BYTES: {
                return value.getBytesValue().toByteArray();
            }
            case ARRAY: {
                return ZetaSqlUtils.zetaSqlArrayValueToJavaList(value, fieldType.getCollectionElementType());
            }
            case ROW: {
                return ZetaSqlUtils.zetaSqlStructValueToBeamRow(value, fieldType.getRowSchema());
            }
        }
        throw new IllegalArgumentException("Unsupported Beam fieldType: " + fieldType.getTypeName());
    }

    private static Instant zetaSqlTimestampValueToJodaInstant(Value timestampValue) {
        long millis = timestampValue.getTimestampUnixMicros() / 1000L;
        return Instant.ofEpochMilli((long)millis);
    }

    private static List<Object> zetaSqlArrayValueToJavaList(Value arrayValue, Schema.FieldType elementType) {
        return arrayValue.getElementList().stream().map(e -> ZetaSqlUtils.zetaSqlValueToJavaObject(e, elementType)).collect(Collectors.toList());
    }

    private static Row zetaSqlStructValueToBeamRow(Value structValue, Schema schema) {
        ArrayList<Object> objects = new ArrayList<Object>(schema.getFieldCount());
        ImmutableList values = structValue.getFieldList();
        for (int i = 0; i < values.size(); ++i) {
            objects.add(ZetaSqlUtils.zetaSqlValueToJavaObject((Value)values.get(i), schema.getField(i).getType()));
        }
        return Row.withSchema((Schema)schema).addValues(objects).build();
    }
}

