/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql;

import com.google.zetasql.Analyzer;
import com.google.zetasql.AnalyzerOptions;
import com.google.zetasql.Function;
import com.google.zetasql.SimpleCatalog;
import com.google.zetasql.Value;
import com.google.zetasql.ZetaSQLBuiltinFunctionOptions;
import com.google.zetasql.ZetaSQLFunctions;
import com.google.zetasql.ZetaSQLOptions;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.beam.sdk.extensions.sql.zetasql.QueryTrait;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlStdOperatorMappingTable;
import org.apache.beam.sdk.extensions.sql.zetasql.TableResolution;
import org.apache.beam.sdk.extensions.sql.zetasql.TypeUtils;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.plan.Context;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.SchemaPlus;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.schema.Table;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;

class SqlAnalyzer {
    static final String PRE_DEFINED_WINDOW_FUNCTIONS = "pre_defined_window_functions";
    private static final ImmutableList<String> FUNCTION_LIST = ImmutableList.of((Object)"CREATE FUNCTION TUMBLE(ts TIMESTAMP, window_size STRING) AS (1);", (Object)"CREATE FUNCTION TUMBLE_START(window_size STRING) AS (1);", (Object)"CREATE FUNCTION TUMBLE_END(window_size STRING) AS (1);", (Object)"CREATE FUNCTION HOP(ts TIMESTAMP, emit_frequency STRING, window_size STRING) AS (1);", (Object)"CREATE FUNCTION HOP_START(emit_frequency STRING, window_size STRING) AS (1);", (Object)"CREATE FUNCTION HOP_END(emit_frequency STRING, window_size STRING) AS (1);", (Object)"CREATE FUNCTION SESSION(ts TIMESTAMP, session_gap STRING) AS (1);", (Object)"CREATE FUNCTION SESSION_START(session_gap STRING) AS (1);", (Object)"CREATE FUNCTION SESSION_END(session_gap STRING) AS (1);");
    private final Builder builder;

    private SqlAnalyzer(Builder builder) {
        this.builder = builder;
    }

    static Builder withQueryParams(Map<String, Value> params) {
        return new Builder().withQueryParams((Map<String, Value>)ImmutableMap.copyOf(params));
    }

    ResolvedNodes.ResolvedStatement analyze(String sql) {
        AnalyzerOptions options = SqlAnalyzer.initAnalyzerOptions(this.builder.queryParams);
        List tables = Analyzer.extractTableNamesFromStatement((String)sql);
        SimpleCatalog catalog = this.createPopulatedCatalog(this.builder.topLevelSchema.getName(), options, tables);
        return Analyzer.analyzeStatement((String)sql, (AnalyzerOptions)options, (SimpleCatalog)catalog);
    }

    static AnalyzerOptions initAnalyzerOptions() {
        AnalyzerOptions options = new AnalyzerOptions();
        options.setErrorMessageMode(ZetaSQLOptions.ErrorMessageMode.ERROR_MESSAGE_MULTI_LINE_WITH_CARET);
        options.setDefaultTimezone("UTC");
        options.getLanguageOptions().setProductMode(ZetaSQLOptions.ProductMode.PRODUCT_EXTERNAL);
        options.getLanguageOptions().setEnabledLanguageFeatures(new HashSet<ZetaSQLOptions.LanguageFeature>(Arrays.asList(ZetaSQLOptions.LanguageFeature.FEATURE_DISALLOW_GROUP_BY_FLOAT, ZetaSQLOptions.LanguageFeature.FEATURE_V_1_2_CIVIL_TIME, ZetaSQLOptions.LanguageFeature.FEATURE_V_1_1_SELECT_STAR_EXCEPT_REPLACE)));
        options.getLanguageOptions().setSupportedStatementKinds((Set)ImmutableSet.of((Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_QUERY_STMT, (Object)ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CREATE_FUNCTION_STMT));
        return options;
    }

    private static AnalyzerOptions initAnalyzerOptions(Map<String, Value> queryParams) {
        AnalyzerOptions options = SqlAnalyzer.initAnalyzerOptions();
        for (Map.Entry<String, Value> entry : queryParams.entrySet()) {
            options.addQueryParameter(entry.getKey(), entry.getValue().getType());
        }
        return options;
    }

    private SimpleCatalog createPopulatedCatalog(String catalogName, AnalyzerOptions options, List<List<String>> tables) {
        SimpleCatalog catalog = new SimpleCatalog(catalogName);
        this.addBuiltinFunctionsToCatalog(catalog, options);
        tables.forEach(table -> this.addTableToLeafCatalog(this.builder.queryTrait, catalog, (List<String>)table));
        return catalog;
    }

    private void addBuiltinFunctionsToCatalog(SimpleCatalog catalog, AnalyzerOptions options) {
        ZetaSQLBuiltinFunctionOptions zetasqlBuiltinFunctionOptions = new ZetaSQLBuiltinFunctionOptions(options.getLanguageOptions());
        SqlStdOperatorMappingTable.ZETASQL_BUILTIN_FUNCTION_WHITELIST.forEach(arg_0 -> ((ZetaSQLBuiltinFunctionOptions)zetasqlBuiltinFunctionOptions).includeFunctionSignatureId(arg_0));
        catalog.addZetaSQLFunctions(zetasqlBuiltinFunctionOptions);
        FUNCTION_LIST.stream().map(func -> (ResolvedNodes.ResolvedCreateFunctionStmt)Analyzer.analyzeStatement((String)func, (AnalyzerOptions)options, (SimpleCatalog)catalog)).map(resolvedFunc -> new Function(String.join((CharSequence)".", (Iterable<? extends CharSequence>)resolvedFunc.getNamePath()), PRE_DEFINED_WINDOW_FUNCTIONS, ZetaSQLFunctions.FunctionEnums.Mode.SCALAR, (List)ImmutableList.of((Object)resolvedFunc.getSignature()))).forEach(arg_0 -> ((SimpleCatalog)catalog).addFunction(arg_0));
    }

    private void addTableToLeafCatalog(QueryTrait trait, SimpleCatalog topLevelCatalog, List<String> tablePath) {
        SimpleCatalog leafCatalog = this.createNestedCatalogs(topLevelCatalog, tablePath);
        Table calciteTable = TableResolution.resolveCalciteTable(this.builder.topLevelSchema, tablePath);
        if (calciteTable == null) {
            throw new RuntimeException("Wasn't able to find resolve the path " + tablePath + " in " + this.builder.topLevelSchema.getName());
        }
        RelDataType rowType = calciteTable.getRowType((RelDataTypeFactory)this.builder.typeFactory);
        TableResolution.SimpleTableWithPath tableWithPath = TableResolution.SimpleTableWithPath.of(tablePath);
        trait.addResolvedTable(tableWithPath);
        this.addFieldsToTable(tableWithPath, rowType);
        leafCatalog.addSimpleTable(tableWithPath.getTable());
    }

    private void addFieldsToTable(TableResolution.SimpleTableWithPath tableWithPath, RelDataType rowType) {
        for (RelDataTypeField field : rowType.getFieldList()) {
            tableWithPath.getTable().addSimpleColumn(field.getName(), TypeUtils.toZetaType(field.getType()));
        }
    }

    private SimpleCatalog createNestedCatalogs(SimpleCatalog catalog, List<String> tablePath) {
        SimpleCatalog currentCatalog = catalog;
        for (int i = 0; i < tablePath.size() - 1; ++i) {
            String nextCatalogName = tablePath.get(i);
            Optional<SimpleCatalog> existing = this.tryGetExisting(currentCatalog, nextCatalogName);
            currentCatalog = existing.isPresent() ? existing.get() : this.addNewCatalog(currentCatalog, nextCatalogName);
        }
        return currentCatalog;
    }

    private Optional<SimpleCatalog> tryGetExisting(SimpleCatalog currentCatalog, String nextCatalogName) {
        return currentCatalog.getCatalogList().stream().filter(c -> nextCatalogName.equals(c.getFullName())).findFirst();
    }

    private SimpleCatalog addNewCatalog(SimpleCatalog currentCatalog, String nextCatalogName) {
        SimpleCatalog nextCatalog = new SimpleCatalog(nextCatalogName);
        currentCatalog.addSimpleCatalog(nextCatalog);
        return nextCatalog;
    }

    static class Builder {
        private Map<String, Value> queryParams;
        private QueryTrait queryTrait;
        private SchemaPlus topLevelSchema;
        private JavaTypeFactory typeFactory;

        private Builder() {
        }

        Builder withQueryParams(Map<String, Value> params) {
            this.queryParams = ImmutableMap.copyOf(params);
            return this;
        }

        Builder withQueryTrait(QueryTrait trait) {
            this.queryTrait = trait;
            return this;
        }

        Builder withTopLevelSchema(SchemaPlus schema) {
            this.topLevelSchema = schema;
            return this;
        }

        Builder withCalciteContext(Context context) {
            return this;
        }

        Builder withTypeFactory(JavaTypeFactory typeFactory) {
            this.typeFactory = typeFactory;
            return this;
        }

        ResolvedNodes.ResolvedStatement analyze(String sql) {
            return new SqlAnalyzer(this).analyze(sql);
        }
    }
}

