/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.sql.zetasql.translation;

import com.google.zetasql.FunctionArgumentType;
import com.google.zetasql.FunctionSignature;
import com.google.zetasql.ZetaSQLResolvedNodeKind;
import com.google.zetasql.ZetaSQLType;
import com.google.zetasql.resolvedast.ResolvedColumn;
import com.google.zetasql.resolvedast.ResolvedNode;
import com.google.zetasql.resolvedast.ResolvedNodes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.extensions.sql.zetasql.SqlStdOperatorMappingTable;
import org.apache.beam.sdk.extensions.sql.zetasql.TypeUtils;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.ConversionContext;
import org.apache.beam.sdk.extensions.sql.zetasql.translation.RelConverter;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelCollation;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelCollations;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.RelNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.core.AggregateCall;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.logical.LogicalProject;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rel.type.RelDataType;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.rex.RexNode;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.SqlAggFunction;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.beam.vendor.calcite.v1_20_0.org.apache.calcite.util.ImmutableBitSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class AggregateScanConverter
extends RelConverter<ResolvedNodes.ResolvedAggregateScan> {
    private static final String AVG_ILLEGAL_LONG_INPUT_TYPE = "AVG(LONG) is not supported. You might want to use AVG(CAST(expression AS DOUBLE).";

    AggregateScanConverter(ConversionContext context) {
        super(context);
    }

    @Override
    public List<ResolvedNode> getInputs(ResolvedNodes.ResolvedAggregateScan zetaNode) {
        return Collections.singletonList(zetaNode.getInputScan());
    }

    @Override
    public RelNode convert(ResolvedNodes.ResolvedAggregateScan zetaNode, List<RelNode> inputs) {
        Object aggregateCalls;
        RelNode input = this.convertAggregateScanInputScanToLogicalProject(zetaNode, inputs.get(0));
        int groupFieldsListSize = zetaNode.getGroupByList().size();
        ImmutableBitSet groupSet = groupFieldsListSize != 0 ? ImmutableBitSet.of((Iterable)IntStream.rangeClosed(0, groupFieldsListSize - 1).boxed().collect(Collectors.toList())) : ImmutableBitSet.of();
        if (zetaNode.getAggregateList().isEmpty()) {
            aggregateCalls = ImmutableList.of();
        } else {
            aggregateCalls = new ArrayList();
            int columnRefoff = groupFieldsListSize;
            for (ResolvedNodes.ResolvedComputedColumn computedColumn : zetaNode.getAggregateList()) {
                aggregateCalls.add(this.convertAggCall(computedColumn, columnRefoff));
                ++columnRefoff;
            }
        }
        LogicalAggregate logicalAggregate = new LogicalAggregate(this.getCluster(), input.getTraitSet(), input, groupSet, (List)ImmutableList.of((Object)groupSet), (List)aggregateCalls);
        return logicalAggregate;
    }

    private RelNode convertAggregateScanInputScanToLogicalProject(ResolvedNodes.ResolvedAggregateScan node, RelNode input) {
        ArrayList<RexNode> projects = new ArrayList<RexNode>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (ResolvedNodes.ResolvedComputedColumn computedColumn : node.getGroupByList()) {
            projects.add(this.getExpressionConverter().convertRexNodeFromResolvedExpr(computedColumn.getExpr(), (List<ResolvedColumn>)node.getInputScan().getColumnList(), input.getRowType().getFieldList()));
            fieldNames.add(this.getTrait().resolveAlias(computedColumn.getColumn()));
        }
        for (ResolvedNodes.ResolvedComputedColumn resolvedComputedColumn : node.getAggregateList()) {
            ResolvedNodes.ResolvedAggregateFunctionCall aggregateFunctionCall = (ResolvedNodes.ResolvedAggregateFunctionCall)resolvedComputedColumn.getExpr();
            if (aggregateFunctionCall.getArgumentList() != null && aggregateFunctionCall.getArgumentList().size() == 1) {
                ResolvedNodes.ResolvedExpr resolvedExpr = (ResolvedNodes.ResolvedExpr)aggregateFunctionCall.getArgumentList().get(0);
                projects.add(this.getExpressionConverter().convertRexNodeFromResolvedExpr(resolvedExpr, (List<ResolvedColumn>)node.getInputScan().getColumnList(), input.getRowType().getFieldList()));
                fieldNames.add(this.getTrait().resolveAlias(resolvedComputedColumn.getColumn()));
                continue;
            }
            if (aggregateFunctionCall.getArgumentList() == null || aggregateFunctionCall.getArgumentList().size() <= 1) continue;
            throw new RuntimeException(aggregateFunctionCall.getFunction().getName() + " has more than one argument.");
        }
        return LogicalProject.create((RelNode)input, projects, fieldNames);
    }

    private AggregateCall convertAggCall(ResolvedNodes.ResolvedComputedColumn computedColumn, int columnRefOff) {
        FunctionSignature signature;
        ResolvedNodes.ResolvedAggregateFunctionCall aggregateFunctionCall = (ResolvedNodes.ResolvedAggregateFunctionCall)computedColumn.getExpr();
        if (aggregateFunctionCall.getFunction().getName().equals("avg") && ((FunctionArgumentType)(signature = aggregateFunctionCall.getSignature()).getFunctionArgumentList().get(0)).getType().getKind().equals((Object)ZetaSQLType.TypeKind.TYPE_INT64)) {
            throw new RuntimeException(AVG_ILLEGAL_LONG_INPUT_TYPE);
        }
        if (aggregateFunctionCall.getDistinct()) {
            throw new RuntimeException("Does not support " + aggregateFunctionCall.getFunction().getSqlName() + " DISTINCT. 'SELECT DISTINCT' syntax could be used to deduplicate before aggregation.");
        }
        SqlAggFunction sqlAggFunction = (SqlAggFunction)SqlStdOperatorMappingTable.ZETASQL_FUNCTION_TO_CALCITE_SQL_OPERATOR.get((Object)aggregateFunctionCall.getFunction().getName());
        if (sqlAggFunction == null) {
            throw new RuntimeException("Does not support ZetaSQL aggregate function: " + aggregateFunctionCall.getFunction().getName());
        }
        ArrayList<Integer> argList = new ArrayList<Integer>();
        for (ResolvedNodes.ResolvedExpr expr : ((ResolvedNodes.ResolvedAggregateFunctionCall)computedColumn.getExpr()).getArgumentList()) {
            if (expr.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_CAST || expr.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_COLUMN_REF || expr.nodeKind() == ZetaSQLResolvedNodeKind.ResolvedNodeKind.RESOLVED_GET_STRUCT_FIELD) {
                argList.add(columnRefOff);
                continue;
            }
            throw new RuntimeException("Aggregate function only accepts Column Reference or CAST(Column Reference) as its input.");
        }
        RelDataType returnType = sqlAggFunction.equals((Object)SqlStdOperatorTable.ANY_VALUE) ? TypeUtils.toSimpleRelDataType(computedColumn.getColumn().getType().getKind(), this.getCluster().getRexBuilder(), true) : TypeUtils.toSimpleRelDataType(computedColumn.getColumn().getType().getKind(), this.getCluster().getRexBuilder(), false);
        String aggName = this.getTrait().resolveAlias(computedColumn.getColumn());
        return AggregateCall.create((SqlAggFunction)sqlAggFunction, (boolean)false, (boolean)false, (boolean)false, argList, (int)-1, (RelCollation)RelCollations.EMPTY, (RelDataType)returnType, (String)aggName);
    }
}

