/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Duration;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.extensions.protobuf.ProtoDomain;
import org.apache.beam.sdk.extensions.protobuf.ProtoSchemaTranslator;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class ProtoDynamicMessageSchema<T>
implements Serializable {
    public static final long serialVersionUID = 1L;
    private final Context context;
    private transient SerializableFunction<T, Row> toRowFunction;
    private transient SerializableFunction<Row, T> fromRowFunction;
    private transient List<Convert> converters;

    private ProtoDynamicMessageSchema(String messageName, ProtoDomain domain) {
        this.context = new DescriptorContext(messageName, domain);
        this.readResolve();
    }

    private ProtoDynamicMessageSchema(Context context) {
        this.context = context;
        this.readResolve();
    }

    public static ProtoDynamicMessageSchema forDescriptor(ProtoDomain domain, String messageName) {
        return new ProtoDynamicMessageSchema(messageName, domain);
    }

    public static ProtoDynamicMessageSchema<DynamicMessage> forDescriptor(ProtoDomain domain, Descriptors.Descriptor descriptor) {
        return new ProtoDynamicMessageSchema<DynamicMessage>(descriptor.getFullName(), domain);
    }

    static ProtoDynamicMessageSchema<?> forContext(Context context, Schema.Field field) {
        return new ProtoDynamicMessageSchema(context.getSubContext(field));
    }

    static ProtoDynamicMessageSchema<Message> forSchema(Schema schema) {
        return new ProtoDynamicMessageSchema<Message>(new Context<Message>(schema, Message.class));
    }

    private Object readResolve() {
        this.converters = this.createConverters(this.context.getSchema());
        this.toRowFunction = new MessageToRowFunction();
        this.fromRowFunction = new RowToMessageFunction();
        return this;
    }

    Convert createConverter(Schema.Field field) {
        Schema.FieldType fieldType = field.getType();
        String messageName = ProtoSchemaTranslator.getMessageName(fieldType);
        if (messageName != null && messageName.length() > 0) {
            Schema.Field valueField = Schema.Field.of((String)"value", (Schema.FieldType)ProtoSchemaTranslator.withFieldNumber(Schema.FieldType.BOOLEAN, 1));
            switch (messageName) {
                case "google.protobuf.StringValue": 
                case "google.protobuf.DoubleValue": 
                case "google.protobuf.FloatValue": 
                case "google.protobuf.BoolValue": 
                case "google.protobuf.Int64Value": 
                case "google.protobuf.Int32Value": 
                case "google.protobuf.UInt64Value": 
                case "google.protobuf.UInt32Value": {
                    return new WrapperConvert(field, new PrimitiveConvert(valueField));
                }
                case "google.protobuf.BytesValue": {
                    return new WrapperConvert(field, new BytesConvert(valueField));
                }
            }
        }
        switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case BOOLEAN: {
                return new PrimitiveConvert(field);
            }
            case BYTES: {
                return new BytesConvert(field);
            }
            case ARRAY: 
            case ITERABLE: {
                return new ArrayConvert(this, field);
            }
            case MAP: {
                return new MapConvert(this, field);
            }
            case LOGICAL_TYPE: {
                String identifier;
                switch (identifier = field.getType().getLogicalType().getIdentifier()) {
                    case "Fixed32": 
                    case "Fixed64": 
                    case "SFixed32": 
                    case "SFixed64": 
                    case "Sint32": 
                    case "Sint64": 
                    case "Uint32": 
                    case "Uint64": {
                        return new LogicalTypeConvert(field, fieldType.getLogicalType());
                    }
                    case "beam:logical_type:nanos_instant:v1": {
                        return new TimestampConvert(field);
                    }
                    case "beam:logical_type:nanos_duration:v1": {
                        return new DurationConvert(field);
                    }
                    case "Enum": {
                        return new EnumConvert(field, fieldType.getLogicalType());
                    }
                    case "OneOf": {
                        return new OneOfConvert(this, field, fieldType.getLogicalType());
                    }
                }
                throw new IllegalStateException("Unexpected logical type : " + identifier);
            }
            case ROW: {
                return new MessageConvert(this, field);
            }
        }
        throw new IllegalStateException("Unexpected value: " + fieldType);
    }

    private List<Convert> createConverters(Schema schema) {
        ArrayList<Convert> fieldOverlays = new ArrayList<Convert>();
        for (Schema.Field field : schema.getFields()) {
            fieldOverlays.add(this.createConverter(field));
        }
        return fieldOverlays;
    }

    public Schema getSchema() {
        return this.context.getSchema();
    }

    public SerializableFunction<T, Row> getToRowFunction() {
        return this.toRowFunction;
    }

    public SerializableFunction<Row, T> getFromRowFunction() {
        return this.fromRowFunction;
    }

    private class RowToMessageFunction
    implements SerializableFunction<Row, T> {
        private RowToMessageFunction() {
        }

        public T apply(Row input) {
            DynamicMessage.Builder builder = ProtoDynamicMessageSchema.this.context.invokeNewBuilder();
            Iterator values = input.getValues().iterator();
            Iterator convertIterator = ProtoDynamicMessageSchema.this.converters.iterator();
            for (int i = 0; i < input.getValues().size(); ++i) {
                Convert convert = (Convert)convertIterator.next();
                Object value = values.next();
                convert.setOnProtoMessage((Message.Builder)builder, value);
            }
            return builder.build();
        }
    }

    private class MessageToRowFunction
    implements SerializableFunction<T, Row> {
        private MessageToRowFunction() {
        }

        public Row apply(T input) {
            Schema schema = ProtoDynamicMessageSchema.this.context.getSchema();
            Row.Builder builder = Row.withSchema((Schema)schema);
            for (Convert convert : ProtoDynamicMessageSchema.this.converters) {
                builder.addValue(convert.getFromProtoMessage((Message)input));
            }
            return builder.build();
        }
    }

    static class LogicalTypeConvert
    extends Convert<Object, Object> {
        private Schema.LogicalType logicalType;

        LogicalTypeConvert(Schema.Field field, Schema.LogicalType logicalType) {
            super(field);
            this.logicalType = logicalType;
        }

        @Override
        Object getFromProtoMessage(Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        Object convertFromProtoValue(Object object) {
            return this.logicalType.toBaseType(object);
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            message.setField(this.getFieldDescriptor(message), value);
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            return value;
        }
    }

    static class NullableConvert
    extends Convert<Object, Object> {
        private Convert fieldOverlay;

        NullableConvert(Schema.Field field, Convert fieldOverlay) {
            super(field);
            this.fieldOverlay = fieldOverlay;
        }

        @Override
        Object getFromProtoMessage(Message message) {
            if (message.hasField(this.getFieldDescriptor(message))) {
                return this.fieldOverlay.getFromProtoMessage(message);
            }
            return null;
        }

        @Override
        Object convertFromProtoValue(Object object) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            if (value != null) {
                this.fieldOverlay.setOnProtoMessage(message, value);
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }
    }

    static class OneOfConvert
    extends Convert<OneOfType.Value, Row> {
        OneOfType logicalType;
        Map<Integer, Convert> oneOfConvert = new HashMap<Integer, Convert>();

        OneOfConvert(ProtoDynamicMessageSchema protoSchema, Schema.Field field, Schema.LogicalType logicalType) {
            super(field);
            this.logicalType = (OneOfType)logicalType;
            for (Schema.Field oneOfField : this.logicalType.getOneOfSchema().getFields()) {
                int fieldNumber = ProtoSchemaTranslator.getFieldNumber(oneOfField.getType());
                this.oneOfConvert.put(fieldNumber, new NullableConvert(oneOfField, protoSchema.createConverter(oneOfField)));
            }
        }

        @Override
        Object getFromProtoMessage(Message message) {
            for (Map.Entry<Integer, Convert> entry : this.oneOfConvert.entrySet()) {
                Object value = entry.getValue().getFromProtoMessage(message);
                if (value == null) continue;
                return this.logicalType.createValue(entry.getKey().intValue(), value);
            }
            return null;
        }

        @Override
        OneOfType.Value convertFromProtoValue(Object in) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Row value) {
            OneOfType.Value oneOf = this.logicalType.toInputType(value);
            int caseIndex = oneOf.getCaseType().getValue();
            this.oneOfConvert.get(caseIndex).setOnProtoMessage(message, oneOf.getValue());
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            throw new IllegalStateException("Value conversion can't be done outside a protobuf message");
        }
    }

    static class EnumConvert
    extends Convert<Object, Object> {
        EnumerationType logicalType;

        EnumConvert(Schema.Field field, Schema.LogicalType logicalType) {
            super(field);
            this.logicalType = (EnumerationType)logicalType;
        }

        @Override
        Object getFromProtoMessage(Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        EnumerationType.Value convertFromProtoValue(Object in) {
            return this.logicalType.valueOf(((Descriptors.EnumValueDescriptor)in).getNumber());
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            Descriptors.EnumDescriptor enumType = fieldDescriptor.getEnumType();
            return enumType.findValueByNumber(((Integer)value).intValue());
        }
    }

    static class ArrayConvert
    extends Convert<List, List> {
        private Convert element;

        ArrayConvert(ProtoDynamicMessageSchema protoSchema, Schema.Field field) {
            super(field);
            Schema.FieldType collectionElementType = field.getType().getCollectionElementType();
            this.element = protoSchema.createConverter(Schema.Field.of((String)"ELEMENT", (Schema.FieldType)ProtoSchemaTranslator.withMessageName(collectionElementType, ProtoSchemaTranslator.getMessageName(field.getType()))));
        }

        @Override
        List getFromProtoMessage(Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        List convertFromProtoValue(Object value) {
            List list = (List)value;
            ArrayList arrayList = new ArrayList();
            list.forEach(entry -> arrayList.add(this.element.convertFromProtoValue(entry)));
            return arrayList;
        }

        @Override
        void setOnProtoMessage(Message.Builder message, List list) {
            if (list != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                ArrayList targetList = new ArrayList();
                list.forEach(e -> targetList.add(this.element.convertToProtoValue(fieldDescriptor, e)));
                message.setField(fieldDescriptor, targetList);
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            return value;
        }
    }

    static class MapConvert
    extends Convert<Map, Map> {
        private Convert key;
        private Convert value;

        MapConvert(ProtoDynamicMessageSchema protoSchema, Schema.Field field) {
            super(field);
            Schema.FieldType fieldType = field.getType();
            this.key = protoSchema.createConverter(Schema.Field.of((String)"KEY", (Schema.FieldType)ProtoSchemaTranslator.withMessageName(fieldType.getMapKeyType(), ProtoSchemaTranslator.getMapKeyMessageName(fieldType))));
            this.value = protoSchema.createConverter(Schema.Field.of((String)"VALUE", (Schema.FieldType)ProtoSchemaTranslator.withMessageName(fieldType.getMapValueType(), ProtoSchemaTranslator.getMapValueMessageName(fieldType))));
        }

        @Override
        Map getFromProtoMessage(Message message) {
            List list = (List)message.getField(this.getFieldDescriptor(message));
            HashMap rowMap = new HashMap();
            if (list.size() == 0) {
                return rowMap;
            }
            list.forEach(entryMessage -> {
                Descriptors.Descriptor entryDescriptor = entryMessage.getDescriptorForType();
                Descriptors.FieldDescriptor keyFieldDescriptor = entryDescriptor.findFieldByName("key");
                Descriptors.FieldDescriptor valueFieldDescriptor = entryDescriptor.findFieldByName("value");
                rowMap.put(this.key.convertFromProtoValue(entryMessage.getField(keyFieldDescriptor)), this.value.convertFromProtoValue(entryMessage.getField(valueFieldDescriptor)));
            });
            return rowMap;
        }

        @Override
        Map convertFromProtoValue(Object object) {
            throw new RuntimeException("?");
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Map map) {
            if (map != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                ArrayList messageMap = new ArrayList();
                map.forEach((k, v) -> {
                    DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)fieldDescriptor.getMessageType());
                    Descriptors.FieldDescriptor keyFieldDescriptor = fieldDescriptor.getMessageType().findFieldByName("key");
                    builder.setField(keyFieldDescriptor, this.key.convertToProtoValue(keyFieldDescriptor, k));
                    Descriptors.FieldDescriptor valueFieldDescriptor = fieldDescriptor.getMessageType().findFieldByName("value");
                    builder.setField(valueFieldDescriptor, this.value.convertToProtoValue(valueFieldDescriptor, v));
                    messageMap.add(builder.build());
                });
                message.setField(fieldDescriptor, messageMap);
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            return value;
        }
    }

    static class MessageConvert
    extends Convert<Object, Object> {
        private final SerializableFunction fromRowFunction;
        private final SerializableFunction toRowFunction;

        MessageConvert(ProtoDynamicMessageSchema rootProtoSchema, Schema.Field field) {
            super(field);
            ProtoDynamicMessageSchema<?> protoSchema = ProtoDynamicMessageSchema.forContext(rootProtoSchema.context, field);
            this.toRowFunction = protoSchema.getToRowFunction();
            this.fromRowFunction = protoSchema.getFromRowFunction();
        }

        @Override
        Object getFromProtoMessage(Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            if (message.hasField(fieldDescriptor)) {
                return this.convertFromProtoValue(message.getField(fieldDescriptor));
            }
            return null;
        }

        @Override
        Object convertFromProtoValue(Object object) {
            return this.toRowFunction.apply(object);
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            if (value != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            return this.fromRowFunction.apply(value);
        }
    }

    static class DurationConvert
    extends Convert<Object, Object> {
        DurationConvert(Schema.Field field) {
            super(field);
        }

        @Override
        Object getFromProtoMessage(Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            if (message.hasField(fieldDescriptor)) {
                Message wrapper = (Message)message.getField(fieldDescriptor);
                return this.convertFromProtoValue(wrapper);
            }
            return null;
        }

        @Override
        java.time.Duration convertFromProtoValue(Object object) {
            Message timestamp = (Message)object;
            Descriptors.Descriptor timestampDescriptor = timestamp.getDescriptorForType();
            Descriptors.FieldDescriptor secondField = timestampDescriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor nanoField = timestampDescriptor.findFieldByNumber(2);
            long second = (Long)timestamp.getField(secondField);
            int nano = (Integer)timestamp.getField(nanoField);
            return java.time.Duration.ofSeconds(second, nano);
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            if (value != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            Row row = (Row)value;
            return Duration.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }

    static class TimestampConvert
    extends Convert<Object, Object> {
        TimestampConvert(Schema.Field field) {
            super(field);
        }

        @Override
        Object getFromProtoMessage(Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            if (message.hasField(fieldDescriptor)) {
                Message wrapper = (Message)message.getField(fieldDescriptor);
                return this.convertFromProtoValue(wrapper);
            }
            return null;
        }

        @Override
        Object convertFromProtoValue(Object object) {
            Message timestamp = (Message)object;
            Descriptors.Descriptor timestampDescriptor = timestamp.getDescriptorForType();
            Descriptors.FieldDescriptor secondField = timestampDescriptor.findFieldByNumber(1);
            Descriptors.FieldDescriptor nanoField = timestampDescriptor.findFieldByNumber(2);
            long second = (Long)timestamp.getField(secondField);
            int nano = (Integer)timestamp.getField(nanoField);
            return Instant.ofEpochSecond(second, nano);
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            if (value != null) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            Row row = (Row)value;
            return Timestamp.newBuilder().setSeconds(row.getInt64(0).longValue()).setNanos(row.getInt32(1).intValue()).build();
        }
    }

    static class WrapperConvert
    extends Convert<Object, Object> {
        private Convert valueConvert;

        WrapperConvert(Schema.Field field, Convert valueConvert) {
            super(field);
            this.valueConvert = valueConvert;
        }

        @Override
        Object getFromProtoMessage(Message message) {
            if (message.hasField(this.getFieldDescriptor(message))) {
                Message wrapper = (Message)message.getField(this.getFieldDescriptor(message));
                return this.valueConvert.getFromProtoMessage(wrapper);
            }
            return null;
        }

        @Override
        Object convertFromProtoValue(Object object) {
            return object;
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            if (value != null) {
                DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)this.getFieldDescriptor(message).getMessageType());
                this.valueConvert.setOnProtoMessage((Message.Builder)builder, value);
                message.setField(this.getFieldDescriptor(message), (Object)builder.build());
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            return value;
        }
    }

    static class BytesConvert
    extends PrimitiveConvert {
        BytesConvert(Schema.Field field) {
            super(field);
        }

        @Override
        Object convertFromProtoValue(Object object) {
            return ((ByteString)object).toByteArray();
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            if (value != null && ((byte[])value).length > 0) {
                Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
                message.setField(fieldDescriptor, this.convertToProtoValue(fieldDescriptor, value));
            }
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            if (value != null) {
                return ByteString.copyFrom((byte[])((byte[])value));
            }
            return null;
        }
    }

    static class PrimitiveConvert
    extends Convert<Object, Object> {
        PrimitiveConvert(Schema.Field field) {
            super(field);
        }

        @Override
        Object getFromProtoMessage(Message message) {
            Descriptors.FieldDescriptor fieldDescriptor = this.getFieldDescriptor(message);
            return this.convertFromProtoValue(message.getField(fieldDescriptor));
        }

        @Override
        Object convertFromProtoValue(Object object) {
            return object;
        }

        @Override
        void setOnProtoMessage(Message.Builder message, Object value) {
            message.setField(this.getFieldDescriptor(message), value);
        }

        @Override
        Object convertToProtoValue(Descriptors.FieldDescriptor fieldDescriptor, Object value) {
            return value;
        }
    }

    static abstract class Convert<ValueT, InT> {
        private int number;

        Convert(Schema.Field field) {
            try {
                this.number = ProtoSchemaTranslator.getFieldNumber(field.getType());
            }
            catch (NumberFormatException e) {
                this.number = -1;
            }
        }

        Descriptors.FieldDescriptor getFieldDescriptor(Message message) {
            return message.getDescriptorForType().findFieldByNumber(this.number);
        }

        Descriptors.FieldDescriptor getFieldDescriptor(Message.Builder message) {
            return message.getDescriptorForType().findFieldByNumber(this.number);
        }

        abstract Object getFromProtoMessage(Message var1);

        abstract ValueT convertFromProtoValue(Object var1);

        abstract void setOnProtoMessage(Message.Builder var1, InT var2);

        abstract Object convertToProtoValue(Descriptors.FieldDescriptor var1, Object var2);
    }

    static class DescriptorContext
    extends Context<DynamicMessage> {
        private final String messageName;
        private final ProtoDomain domain;
        private transient Descriptors.Descriptor descriptor;

        DescriptorContext(String messageName, ProtoDomain domain) {
            super(ProtoSchemaTranslator.getSchema(domain.getDescriptor(messageName)), DynamicMessage.class);
            this.messageName = messageName;
            this.domain = domain;
        }

        @Override
        public DynamicMessage.Builder invokeNewBuilder() {
            if (this.descriptor == null) {
                this.descriptor = this.domain.getDescriptor(this.messageName);
            }
            return DynamicMessage.newBuilder((Descriptors.Descriptor)this.descriptor);
        }

        @Override
        public Context getSubContext(Schema.Field field) {
            String messageName = ProtoSchemaTranslator.getMessageName(field.getType());
            return new DescriptorContext(messageName, this.domain);
        }
    }

    static class Context<T>
    implements Serializable {
        private final Schema schema;
        private Class<T> baseClass;

        Context(Schema schema, Class<T> baseClass) {
            this.schema = schema;
            this.baseClass = baseClass;
        }

        public Schema getSchema() {
            return this.schema;
        }

        public Class<T> getBaseClass() {
            return this.baseClass;
        }

        public DynamicMessage.Builder invokeNewBuilder() {
            throw new IllegalStateException("Should not be calling invokeNewBuilder");
        }

        public Context getSubContext(Schema.Field field) {
            return new Context<Message>(field.getType().getRowSchema(), Message.class);
        }
    }
}

