/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.protobuf;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

public final class ProtoDomain
implements Serializable {
    public static final long serialVersionUID = 1L;
    private transient DescriptorProtos.FileDescriptorSet fileDescriptorSet;
    private transient int hashCode;
    private transient Map<String, Descriptors.FileDescriptor> fileDescriptorMap;
    private transient Map<String, Descriptors.Descriptor> descriptorMap;
    private transient Map<Integer, Descriptors.FieldDescriptor> fileOptionMap;
    private transient Map<Integer, Descriptors.FieldDescriptor> messageOptionMap;
    private transient Map<Integer, Descriptors.FieldDescriptor> fieldOptionMap;

    ProtoDomain() {
        this(DescriptorProtos.FileDescriptorSet.newBuilder().build());
    }

    private ProtoDomain(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        this.fileDescriptorSet = fileDescriptorSet;
        this.hashCode = Arrays.hashCode(this.fileDescriptorSet.toByteArray());
        this.crosswire();
    }

    private static Map<String, DescriptorProtos.FileDescriptorProto> extractProtoMap(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        HashMap<String, DescriptorProtos.FileDescriptorProto> map = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        fileDescriptorSet.getFileList().forEach(fdp -> map.put(fdp.getName(), (DescriptorProtos.FileDescriptorProto)fdp));
        return map;
    }

    @Nullable
    private static Descriptors.FileDescriptor convertToFileDescriptorMap(String name, Map<String, DescriptorProtos.FileDescriptorProto> inMap, Map<String, Descriptors.FileDescriptor> outMap) {
        if (outMap.containsKey(name)) {
            return outMap.get(name);
        }
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = inMap.get(name);
        if (fileDescriptorProto == null) {
            if ("google/protobuf/descriptor.proto".equals(name)) {
                outMap.put("google/protobuf/descriptor.proto", DescriptorProtos.FieldOptions.getDescriptor().getFile());
                return DescriptorProtos.FieldOptions.getDescriptor().getFile();
            }
            return null;
        }
        ArrayList dependencies = new ArrayList();
        if (fileDescriptorProto.getDependencyCount() > 0) {
            fileDescriptorProto.getDependencyList().forEach(dependencyName -> {
                Descriptors.FileDescriptor fileDescriptor = ProtoDomain.convertToFileDescriptorMap(dependencyName, inMap, outMap);
                if (fileDescriptor != null) {
                    dependencies.add(fileDescriptor);
                }
            });
        }
        try {
            Descriptors.FileDescriptor fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])dependencies.toArray(new Descriptors.FileDescriptor[0]));
            outMap.put(name, fileDescriptor);
            return fileDescriptor;
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException(e);
        }
    }

    private static void visitFileDescriptorTree(Map map, Descriptors.FileDescriptor fileDescriptor) {
        if (!map.containsKey(fileDescriptor.getName())) {
            map.put(fileDescriptor.getName(), fileDescriptor);
            List dependencies = fileDescriptor.getDependencies();
            dependencies.forEach(fd -> ProtoDomain.visitFileDescriptorTree(map, fd));
        }
    }

    public static ProtoDomain buildFrom(Descriptors.Descriptor descriptor) {
        return ProtoDomain.buildFrom(descriptor.getFile());
    }

    public static ProtoDomain buildFrom(DescriptorProtos.FileDescriptorSet fileDescriptorSet) {
        return new ProtoDomain(fileDescriptorSet);
    }

    public static ProtoDomain buildFrom(Descriptors.FileDescriptor fileDescriptor) {
        HashMap fileDescriptorMap = new HashMap();
        ProtoDomain.visitFileDescriptorTree(fileDescriptorMap, fileDescriptor);
        DescriptorProtos.FileDescriptorSet.Builder builder = DescriptorProtos.FileDescriptorSet.newBuilder();
        fileDescriptorMap.values().forEach(fd -> builder.addFile(fd.toProto()));
        return new ProtoDomain(builder.build());
    }

    public static ProtoDomain buildFrom(InputStream inputStream) throws IOException {
        return ProtoDomain.buildFrom(DescriptorProtos.FileDescriptorSet.parseFrom((InputStream)inputStream));
    }

    private void crosswire() {
        HashMap<String, DescriptorProtos.FileDescriptorProto> map = new HashMap<String, DescriptorProtos.FileDescriptorProto>();
        this.fileDescriptorSet.getFileList().forEach(fdp -> map.put(fdp.getName(), (DescriptorProtos.FileDescriptorProto)fdp));
        HashMap<String, Descriptors.FileDescriptor> outMap = new HashMap<String, Descriptors.FileDescriptor>();
        map.forEach((fileName, proto) -> ProtoDomain.convertToFileDescriptorMap(fileName, map, outMap));
        this.fileDescriptorMap = outMap;
        this.indexOptionsByNumber(this.fileDescriptorMap.values());
        this.indexDescriptorByName();
    }

    private void indexDescriptorByName() {
        this.descriptorMap = new HashMap<String, Descriptors.Descriptor>();
        this.fileDescriptorMap.values().forEach(fileDescriptor -> fileDescriptor.getMessageTypes().forEach(this::indexDescriptor));
    }

    private void indexDescriptor(Descriptors.Descriptor descriptor) {
        this.descriptorMap.put(descriptor.getFullName(), descriptor);
        descriptor.getNestedTypes().forEach(this::indexDescriptor);
    }

    private void indexOptionsByNumber(Collection<Descriptors.FileDescriptor> fileDescriptors) {
        this.fieldOptionMap = new HashMap<Integer, Descriptors.FieldDescriptor>();
        this.fileOptionMap = new HashMap<Integer, Descriptors.FieldDescriptor>();
        this.messageOptionMap = new HashMap<Integer, Descriptors.FieldDescriptor>();
        fileDescriptors.forEach(fileDescriptor -> fileDescriptor.getExtensions().forEach(extension -> {
            switch (extension.toProto().getExtendee()) {
                case ".google.protobuf.FileOptions": {
                    this.fileOptionMap.put(extension.getNumber(), (Descriptors.FieldDescriptor)extension);
                    break;
                }
                case ".google.protobuf.MessageOptions": {
                    this.messageOptionMap.put(extension.getNumber(), (Descriptors.FieldDescriptor)extension);
                    break;
                }
                case ".google.protobuf.FieldOptions": {
                    this.fieldOptionMap.put(extension.getNumber(), (Descriptors.FieldDescriptor)extension);
                    break;
                }
            }
        }));
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        byte[] buffer = this.fileDescriptorSet.toByteArray();
        oos.writeInt(buffer.length);
        oos.write(buffer);
    }

    private void readObject(ObjectInputStream ois) throws IOException {
        byte[] buffer = new byte[ois.readInt()];
        ois.readFully(buffer);
        this.fileDescriptorSet = DescriptorProtos.FileDescriptorSet.parseFrom((byte[])buffer);
        this.hashCode = Arrays.hashCode(buffer);
        this.crosswire();
    }

    public Descriptors.FileDescriptor getFileDescriptor(String name) {
        return this.fileDescriptorMap.get(name);
    }

    public Descriptors.Descriptor getDescriptor(String fullName) {
        return this.descriptorMap.get(fullName);
    }

    public Descriptors.FieldDescriptor getFieldOptionById(int id) {
        return this.fieldOptionMap.get(id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProtoDomain that = (ProtoDomain)o;
        return this.hashCode == that.hashCode;
    }

    public int hashCode() {
        return Objects.hash(this.hashCode);
    }

    public boolean contains(Descriptors.Descriptor descriptor) {
        return this.getDescriptor(descriptor.getFullName()) != null;
    }
}

