/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.extensions.jackson;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class ParseJsons<@UnknownKeyFor OutputT>
extends PTransform<PCollection<String>, PCollection<OutputT>> {
    private static final @UnknownKeyFor @NonNull @Initialized ObjectMapper DEFAULT_MAPPER = new ObjectMapper();
    private final @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends OutputT> outputClass;
    private @UnknownKeyFor @NonNull @Initialized ObjectMapper customMapper;

    public static <OutputT> @UnknownKeyFor @NonNull @Initialized ParseJsons<OutputT> of(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends OutputT> outputClass) {
        return new ParseJsons<OutputT>(outputClass);
    }

    private ParseJsons(@UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized ? extends OutputT> outputClass) {
        this.outputClass = outputClass;
    }

    public @UnknownKeyFor @NonNull @Initialized ParseJsons<OutputT> withMapper(@UnknownKeyFor @NonNull @Initialized ObjectMapper mapper) {
        ParseJsons<? extends OutputT> newTransform = new ParseJsons<OutputT>(this.outputClass);
        newTransform.customMapper = mapper;
        return newTransform;
    }

    public <NewFailureT> @UnknownKeyFor @NonNull @Initialized ParseJsons. @UnknownKeyFor @NonNull @Initialized ParseJsonsWithFailures<NewFailureT> exceptionsInto(@UnknownKeyFor @NonNull @Initialized TypeDescriptor<NewFailureT> failureTypeDescriptor) {
        return new ParseJsonsWithFailures<NewFailureT>(null, failureTypeDescriptor);
    }

    public <FailureT> @UnknownKeyFor @NonNull @Initialized ParseJsons. @UnknownKeyFor @NonNull @Initialized ParseJsonsWithFailures<FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized InferableFunction<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<@UnknownKeyFor @NonNull @Initialized String>, FailureT> exceptionHandler) {
        return new ParseJsonsWithFailures<FailureT>(exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized ParseJsons. @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized ParseJsonsWithFailures<KV<String, Map<String, String>>> exceptionsVia() {
        DefaultExceptionAsMapHandler<String> exceptionHandler = new DefaultExceptionAsMapHandler<String>(){};
        return new ParseJsonsWithFailures<KV<String, Map<String, String>>>((InferableFunction<WithFailures.ExceptionElement<String>, KV<String, Map<String, String>>>)exceptionHandler, (TypeDescriptor<KV<String, Map<String, String>>>)exceptionHandler.getOutputTypeDescriptor());
    }

    private OutputT readValue(@UnknownKeyFor @NonNull @Initialized String input) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ObjectMapper mapper = Optional.ofNullable(this.customMapper).orElse(DEFAULT_MAPPER);
        return (OutputT)mapper.readValue(input, this.outputClass);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<OutputT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
        return (PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<String, OutputT>(){

            public OutputT apply(@UnknownKeyFor @NonNull @Initialized String input) {
                try {
                    return ParseJsons.this.readValue(input);
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to parse a " + ParseJsons.this.outputClass.getName() + " from JSON value: " + input, e);
                }
            }
        }));
    }

    private static class DefaultExceptionAsMapHandler<@UnknownKeyFor OutputT>
    extends SimpleFunction<WithFailures.ExceptionElement<OutputT>, KV<OutputT, Map<String, String>>> {
        private DefaultExceptionAsMapHandler() {
        }

        public @UnknownKeyFor @NonNull @Initialized KV<OutputT, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> apply(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<OutputT> f) throws @UnknownKeyFor @NonNull @Initialized RuntimeException {
            if (!(f.exception() instanceof IOException)) {
                throw new RuntimeException(f.exception());
            }
            return KV.of((Object)f.element(), (Object)ImmutableMap.of((Object)"className", (Object)f.exception().getClass().getName(), (Object)"message", (Object)f.exception().getMessage(), (Object)"stackTrace", (Object)Arrays.toString(f.exception().getStackTrace())));
        }
    }

    public class ParseJsonsWithFailures<@UnknownKeyFor FailureT>
    extends PTransform<PCollection<String>, WithFailures.Result<PCollection<OutputT>, FailureT>> {
        private @Nullable @UnknownKeyFor @Initialized InferableFunction<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<@UnknownKeyFor @NonNull @Initialized String>, FailureT> exceptionHandler;
        private final transient @Nullable @UnknownKeyFor @Initialized TypeDescriptor<FailureT> failureType;

        ParseJsonsWithFailures(@UnknownKeyFor @NonNull @Initialized InferableFunction<// Could not load outer class - annotation placement on inner may be incorrect
        WithFailures.ExceptionElement<String>, FailureT> exceptionHandler, TypeDescriptor<FailureT> failureType) {
            this.exceptionHandler = exceptionHandler;
            this.failureType = failureType;
        }

        public @UnknownKeyFor @NonNull @Initialized ParseJsons. @UnknownKeyFor @NonNull @Initialized ParseJsonsWithFailures<FailureT> exceptionsVia(@UnknownKeyFor @NonNull @Initialized ProcessFunction<// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.ExceptionElement<@UnknownKeyFor @NonNull @Initialized String>, FailureT> exceptionHandler) {
            return new ParseJsonsWithFailures<FailureT>(new InferableFunction<WithFailures.ExceptionElement<String>, FailureT>(exceptionHandler){}, this.failureType);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized WithFailures.Result<@UnknownKeyFor @NonNull @Initialized PCollection<OutputT>, FailureT> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized String> input) {
            return (WithFailures.Result)input.apply((PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<OutputT>(){}).via(Contextful.fn((Contextful.Fn & Serializable)(input1, c) -> ParseJsons.this.readValue(input1), (Requirements)Requirements.empty())).exceptionsInto(this.failureType).exceptionsVia(this.exceptionHandler));
        }
    }
}

