/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.Collection;
import java.util.Objects;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.Iterables;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.spark.api.java.function.Function;
import org.joda.time.Instant;

public class SparkAssignWindowFn<T, W extends BoundedWindow>
implements Function<WindowedValue<T>, WindowedValue<T>> {
    private WindowFn<? super T, W> fn;

    public SparkAssignWindowFn(WindowFn<? super T, W> fn) {
        this.fn = fn;
    }

    public WindowedValue<T> call(WindowedValue<T> windowedValue) throws Exception {
        final BoundedWindow boundedWindow = (BoundedWindow)Iterables.getOnlyElement(windowedValue.getWindows());
        final Object element = windowedValue.getValue();
        final Instant timestamp = windowedValue.getTimestamp();
        WindowFn<? super T, W> windowFn = this.fn;
        Objects.requireNonNull(windowFn);
        Collection windows = this.fn.assignWindows(new WindowFn.AssignContext(windowFn){

            public T element() {
                return element;
            }

            public Instant timestamp() {
                return timestamp;
            }

            public BoundedWindow window() {
                return boundedWindow;
            }
        });
        return WindowedValue.of((Object)element, (Instant)timestamp, (Collection)windows, (PaneInfo)PaneInfo.NO_FIRING);
    }
}

