/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.base.Preconditions;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.Iterables;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.construction.TransformInputs;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.runners.spark.translation.WindowingHelpers;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.streaming.api.java.JavaStreamingContext;

public class EvaluationContext {
    private final JavaSparkContext jsc;
    private JavaStreamingContext jssc;
    private final Pipeline pipeline;
    private final Map<PValue, Dataset> datasets = new LinkedHashMap<PValue, Dataset>();
    private final Map<PValue, Dataset> pcollections = new LinkedHashMap<PValue, Dataset>();
    private final Set<Dataset> leaves = new LinkedHashSet<Dataset>();
    private final Map<PValue, Object> pobjects = new LinkedHashMap<PValue, Object>();
    private AppliedPTransform<?, ?, ?> currentTransform;
    private final SparkPCollectionView pviews = new SparkPCollectionView();
    private final Map<PCollection, Long> cacheCandidates = new HashMap<PCollection, Long>();
    private final PipelineOptions options;
    private final SerializablePipelineOptions serializableOptions;

    public EvaluationContext(JavaSparkContext jsc, Pipeline pipeline, PipelineOptions options) {
        this.jsc = jsc;
        this.pipeline = pipeline;
        this.options = options;
        this.serializableOptions = new SerializablePipelineOptions(options);
    }

    public EvaluationContext(JavaSparkContext jsc, Pipeline pipeline, PipelineOptions options, JavaStreamingContext jssc) {
        this(jsc, pipeline, options);
        this.jssc = jssc;
    }

    public JavaSparkContext getSparkContext() {
        return this.jsc;
    }

    public JavaStreamingContext getStreamingContext() {
        return this.jssc;
    }

    public Pipeline getPipeline() {
        return this.pipeline;
    }

    public PipelineOptions getOptions() {
        return this.options;
    }

    public SerializablePipelineOptions getSerializableOptions() {
        return this.serializableOptions;
    }

    public void setCurrentTransform(AppliedPTransform<?, ?, ?> transform) {
        this.currentTransform = transform;
    }

    public AppliedPTransform<?, ?, ?> getCurrentTransform() {
        return this.currentTransform;
    }

    public <T extends PValue> T getInput(PTransform<T, ?> transform) {
        PValue input = (PValue)Iterables.getOnlyElement(TransformInputs.nonAdditionalInputs(this.getCurrentTransform()));
        return (T)input;
    }

    public <T> Map<TupleTag<?>, PValue> getInputs(PTransform<?, ?> transform) {
        Preconditions.checkArgument(this.currentTransform != null, "can only be called with non-null currentTransform");
        Preconditions.checkArgument(this.currentTransform.getTransform() == transform, "can only be called with current transform");
        return this.currentTransform.getInputs();
    }

    public <T extends PValue> T getOutput(PTransform<?, T> transform) {
        PValue output = Iterables.getOnlyElement(this.getOutputs(transform).values());
        return (T)output;
    }

    public Map<TupleTag<?>, PValue> getOutputs(PTransform<?, ?> transform) {
        Preconditions.checkArgument(this.currentTransform != null, "can only be called with non-null currentTransform");
        Preconditions.checkArgument(this.currentTransform.getTransform() == transform, "can only be called with current transform");
        return this.currentTransform.getOutputs();
    }

    public Map<TupleTag<?>, Coder<?>> getOutputCoders() {
        return this.currentTransform.getOutputs().entrySet().stream().filter(e -> e.getValue() instanceof PCollection).collect(Collectors.toMap(e -> (TupleTag)e.getKey(), e -> ((PCollection)e.getValue()).getCoder()));
    }

    private boolean shouldCache(PValue pvalue) {
        return pvalue instanceof PCollection && this.cacheCandidates.containsKey(pvalue) && this.cacheCandidates.get(pvalue) > 1L;
    }

    public void putDataset(PTransform<?, ? extends PValue> transform, Dataset dataset, boolean forceCache) {
        this.putDataset(this.getOutput(transform), dataset, forceCache);
    }

    public void putDataset(PTransform<?, ? extends PValue> transform, Dataset dataset) {
        this.putDataset(transform, dataset, false);
    }

    public void putDataset(PValue pvalue, Dataset dataset, boolean forceCache) {
        try {
            dataset.setName(pvalue.getName());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if ((forceCache || this.shouldCache(pvalue)) && pvalue instanceof PCollection) {
            Coder coder = ((PCollection)pvalue).getCoder();
            Coder wCoder = ((PCollection)pvalue).getWindowingStrategy().getWindowFn().windowCoder();
            dataset.cache(this.storageLevel(), (Coder<?>)WindowedValue.getFullCoder((Coder)coder, (Coder)wCoder));
        }
        this.datasets.put(pvalue, dataset);
        this.leaves.add(dataset);
    }

    <T> void putBoundedDatasetFromValues(PTransform<?, ? extends PValue> transform, Iterable<T> values, Coder<T> coder) {
        PValue output = this.getOutput(transform);
        if (this.shouldCache(output)) {
            Iterable elems = Iterables.transform(values, WindowingHelpers.windowValueFunction());
            WindowedValue.ValueOnlyWindowedValueCoder windowCoder = WindowedValue.getValueOnlyCoder(coder);
            JavaRDD rdd = this.getSparkContext().parallelize(CoderHelpers.toByteArrays(elems, windowCoder)).map(CoderHelpers.fromByteFunction(windowCoder));
            this.putDataset(transform, new BoundedDataset(rdd));
        } else {
            this.datasets.put(this.getOutput(transform), new BoundedDataset<T>(values, this.jsc, coder));
        }
    }

    public Dataset borrowDataset(PTransform<? extends PValue, ?> transform) {
        return this.borrowDataset(this.getInput(transform));
    }

    public Dataset borrowDataset(PValue pvalue) {
        Dataset dataset = this.datasets.get(pvalue);
        this.leaves.remove(dataset);
        return dataset;
    }

    public void computeOutputs() {
        for (Dataset dataset : this.leaves) {
            dataset.action();
        }
    }

    public <T> T get(PValue value) {
        if (this.pobjects.containsKey(value)) {
            Object result = this.pobjects.get(value);
            return (T)result;
        }
        if (this.pcollections.containsKey(value)) {
            JavaRDD rdd = ((BoundedDataset)this.pcollections.get(value)).getRDD();
            Object res = Iterables.getOnlyElement(rdd.collect());
            this.pobjects.put(value, res);
            return res;
        }
        throw new IllegalStateException("Cannot resolve un-known PObject: " + value);
    }

    public SparkPCollectionView getPViews() {
        return this.pviews;
    }

    public void putPView(PCollectionView<?> view, Iterable<WindowedValue<?>> value, Coder<Iterable<WindowedValue<?>>> coder) {
        this.pviews.putPView(view, value, coder);
    }

    public Map<PCollection, Long> getCacheCandidates() {
        return this.cacheCandidates;
    }

    <T> Iterable<WindowedValue<T>> getWindowedValues(PCollection<T> pcollection) {
        BoundedDataset boundedDataset = (BoundedDataset)this.datasets.get(pcollection);
        this.leaves.remove(boundedDataset);
        return boundedDataset.getValues(pcollection);
    }

    public String storageLevel() {
        return ((SparkPipelineOptions)this.serializableOptions.get().as(SparkPipelineOptions.class)).getStorageLevel();
    }
}

