/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.repackaged.beam_runners_spark.com.google.common.collect.Iterables;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.translation.WindowingHelpers;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.PCollection;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.storage.StorageLevel;

public class BoundedDataset<T>
implements Dataset {
    @Nullable
    private transient JavaSparkContext jsc;
    private Iterable<WindowedValue<T>> windowedValues;
    private Coder<T> coder;
    private JavaRDD<WindowedValue<T>> rdd;

    BoundedDataset(JavaRDD<WindowedValue<T>> rdd) {
        this.rdd = rdd;
    }

    BoundedDataset(Iterable<T> values, JavaSparkContext jsc, Coder<T> coder) {
        this.windowedValues = Iterables.transform(values, WindowingHelpers.windowValueFunction());
        this.jsc = jsc;
        this.coder = coder;
    }

    public JavaRDD<WindowedValue<T>> getRDD() {
        if (this.rdd == null) {
            WindowedValue.ValueOnlyWindowedValueCoder windowCoder = WindowedValue.getValueOnlyCoder(this.coder);
            this.rdd = this.jsc.parallelize(CoderHelpers.toByteArrays(this.windowedValues, windowCoder)).map(CoderHelpers.fromByteFunction(windowCoder));
        }
        return this.rdd;
    }

    Iterable<WindowedValue<T>> getValues(PCollection<T> pcollection) {
        if (this.windowedValues == null) {
            WindowFn windowFn = pcollection.getWindowingStrategy().getWindowFn();
            Coder windowCoder = windowFn.windowCoder();
            Object windowedValueCoder = windowFn instanceof GlobalWindows ? WindowedValue.ValueOnlyWindowedValueCoder.of((Coder)pcollection.getCoder()) : WindowedValue.FullWindowedValueCoder.of((Coder)pcollection.getCoder(), (Coder)windowCoder);
            JavaRDD bytesRDD = this.rdd.map(CoderHelpers.toByteFunction(windowedValueCoder));
            List clientBytes = bytesRDD.collect();
            this.windowedValues = clientBytes.stream().map(arg_0 -> BoundedDataset.lambda$getValues$0((WindowedValue.WindowedValueCoder)windowedValueCoder, arg_0)).collect(Collectors.toList());
        }
        return this.windowedValues;
    }

    @Override
    public void cache(String storageLevel, Coder<?> coder) {
        StorageLevel level = StorageLevel.fromString((String)storageLevel);
        if (TranslationUtils.avoidRddSerialization(level)) {
            this.rdd = this.getRDD().persist(level);
        } else {
            Coder<?> windowedValueCoder = coder;
            this.rdd = this.getRDD().map(CoderHelpers.toByteFunction(windowedValueCoder)).persist(level).map(CoderHelpers.fromByteFunction(windowedValueCoder));
        }
    }

    @Override
    public void action() {
        this.rdd.foreach(TranslationUtils.emptyVoidFunction());
    }

    @Override
    public void setName(String name) {
        this.rdd.setName(name);
    }

    private static /* synthetic */ WindowedValue lambda$getValues$0(WindowedValue.WindowedValueCoder windowedValueCoder, byte[] bytes) {
        return (WindowedValue)CoderHelpers.fromByteArray(bytes, windowedValueCoder);
    }
}

