/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation.streaming;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpoint {
    private static final String TEMP_FILE_SUFFIX = ".tmp";
    private static final String BACKUP_FILE_SUFFIX = ".bak";

    private static void write(FileSystem fileSystem, Path checkpointFilePath, byte[] value) throws IOException {
        Path tmpPath = checkpointFilePath.suffix(TEMP_FILE_SUFFIX);
        Path backupPath = checkpointFilePath.suffix(BACKUP_FILE_SUFFIX);
        if (fileSystem.exists(checkpointFilePath)) {
            if (fileSystem.exists(backupPath)) {
                fileSystem.delete(backupPath, false);
            }
            fileSystem.rename(checkpointFilePath, backupPath);
        }
        FSDataOutputStream os = fileSystem.create(tmpPath, true);
        os.write(value);
        os.close();
        fileSystem.rename(tmpPath, checkpointFilePath);
    }

    public static void writeObject(FileSystem fileSystem, Path checkpointFilePath, Object value) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(value);
        oos.close();
        Checkpoint.write(fileSystem, checkpointFilePath, bos.toByteArray());
    }

    private static byte[] read(FileSystem fileSystem, Path checkpointFilePath) throws IOException {
        Path backupCheckpointPath = checkpointFilePath.suffix(BACKUP_FILE_SUFFIX);
        FSDataInputStream is = null;
        if (fileSystem.exists(checkpointFilePath)) {
            is = fileSystem.open(checkpointFilePath);
        } else if (fileSystem.exists(backupCheckpointPath)) {
            is = fileSystem.open(backupCheckpointPath);
        }
        return is != null ? IOUtils.toByteArray((InputStream)is) : null;
    }

    public static <T> T readObject(FileSystem fileSystem, Path checkpointfilePath) throws IOException, ClassNotFoundException {
        byte[] bytes = Checkpoint.read(fileSystem, checkpointfilePath);
        if (bytes == null) {
            return null;
        }
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(bytes));
        Object value = objectInputStream.readObject();
        objectInputStream.close();
        return (T)value;
    }

    public static class CheckpointDir {
        private static final Logger LOG = LoggerFactory.getLogger(CheckpointDir.class);
        private static final String SPARK_CHECKPOINT_DIR = "spark-checkpoint";
        private static final String BEAM_CHECKPOINT_DIR = "beam-checkpoint";
        private static final String KNOWN_RELIABLE_FS_PATTERN = "^(hdfs|s3|gs)";
        private final Path rootCheckpointDir;
        private final Path sparkCheckpointDir;
        private final Path beamCheckpointDir;

        public CheckpointDir(String rootCheckpointDir) {
            if (!rootCheckpointDir.matches(KNOWN_RELIABLE_FS_PATTERN)) {
                LOG.warn("The specified checkpoint dir {} does not match a reliable filesystem so in case of failures this job may not recover properly or even at all.", (Object)rootCheckpointDir);
            }
            LOG.info("Checkpoint dir set to: {}", (Object)rootCheckpointDir);
            this.rootCheckpointDir = new Path(rootCheckpointDir);
            this.sparkCheckpointDir = new Path(rootCheckpointDir, SPARK_CHECKPOINT_DIR);
            this.beamCheckpointDir = new Path(rootCheckpointDir, BEAM_CHECKPOINT_DIR);
        }

        public Path getRootCheckpointDir() {
            return this.rootCheckpointDir;
        }

        public Path getSparkCheckpointDir() {
            return this.sparkCheckpointDir;
        }

        public Path getBeamCheckpointDir() {
            return this.beamCheckpointDir;
        }
    }
}

