/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.Collection;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.spark.sql.Dataset;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class FlattenTranslatorBatch<@UnknownKeyFor T>
implements TransformTranslator<PTransform<PCollectionList<T>, PCollection<T>>> {
    FlattenTranslatorBatch() {
    }

    @Override
    public void translateTransform(@UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionList<T>, @UnknownKeyFor @NonNull @Initialized PCollection<T>> transform, @UnknownKeyFor @NonNull @Initialized TranslationContext context) {
        Collection<PCollection<?>> pcollectionList = context.getInputs().values();
        Dataset result = null;
        if (pcollectionList.isEmpty()) {
            result = context.emptyDataset();
        } else {
            for (PValue pValue : pcollectionList) {
                Preconditions.checkArgument((boolean)(pValue instanceof PCollection), (String)"Got non-PCollection input to flatten: %s of type %s", (Object)pValue, (Object)pValue.getClass().getSimpleName());
                PCollection pCollection = (PCollection)pValue;
                Dataset current = context.getDataset((PValue)pCollection);
                if (result == null) {
                    result = current;
                    continue;
                }
                result = result.union(current);
            }
        }
        context.putDataset(context.getOutput(), result);
    }
}

