/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.util;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.beam.runners.spark.translation.SparkCombineFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaStreamingContext;

public class SparkCompat {
    public static <T> JavaDStream<WindowedValue<T>> joinStreams(JavaStreamingContext streamingContext, List<JavaDStream<WindowedValue<T>>> dStreams) {
        try {
            if (streamingContext.sparkContext().version().startsWith("3")) {
                Method method = streamingContext.getClass().getDeclaredMethod("union", JavaDStream[].class);
                Object result = method.invoke((Object)streamingContext, new Object[]{dStreams.toArray(new JavaDStream[0])});
                return (JavaDStream)result;
            }
            Method method = streamingContext.getClass().getDeclaredMethod("union", JavaDStream.class, List.class);
            Object result = method.invoke((Object)streamingContext, dStreams.remove(0), dStreams);
            return (JavaDStream)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error invoking Spark union", e);
        }
    }

    public static <K, InputT, AccumT, OutputT> JavaPairRDD<K, WindowedValue<OutputT>> extractOutput(JavaPairRDD<K, SparkCombineFn.WindowedAccumulator<KV<K, InputT>, InputT, AccumT, ?>> accumulatePerKey, SparkCombineFn<KV<K, InputT>, InputT, AccumT, OutputT> sparkCombineFn) {
        try {
            if (accumulatePerKey.context().version().startsWith("3")) {
                FlatMapFunction & Serializable flatMapFunction = (FlatMapFunction & Serializable)windowedAccumulator -> sparkCombineFn.extractOutputStream((SparkCombineFn.WindowedAccumulator)windowedAccumulator).iterator();
                Method method = accumulatePerKey.getClass().getDeclaredMethod("flatMapValues", FlatMapFunction.class);
                Object result = method.invoke(accumulatePerKey, flatMapFunction);
                return (JavaPairRDD)result;
            }
            Function & Serializable flatMapFunction = (Function & Serializable)windowedAccumulator -> sparkCombineFn.extractOutputStream((SparkCombineFn.WindowedAccumulator)windowedAccumulator).collect(Collectors.toList());
            Method method = accumulatePerKey.getClass().getDeclaredMethod("flatMapValues", Function.class);
            Object result = method.invoke(accumulatePerKey, flatMapFunction);
            return (JavaPairRDD)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Error invoking Spark flatMapValues", e);
        }
    }
}

