/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.ParDoTranslation;
import org.apache.beam.runners.spark.SparkPipelineOptions;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.io.SourceRDD;
import org.apache.beam.runners.spark.metrics.MetricsAccumulator;
import org.apache.beam.runners.spark.metrics.MetricsContainerStepMapAccumulator;
import org.apache.beam.runners.spark.translation.BoundedDataset;
import org.apache.beam.runners.spark.translation.Dataset;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.GroupCombineFunctions;
import org.apache.beam.runners.spark.translation.GroupNonMergingWindowsFunctions;
import org.apache.beam.runners.spark.translation.MultiDoFnFunction;
import org.apache.beam.runners.spark.translation.ReifyTimestampsAndWindowsFunction;
import org.apache.beam.runners.spark.translation.SparkAssignWindowFn;
import org.apache.beam.runners.spark.translation.SparkCombineFn;
import org.apache.beam.runners.spark.translation.SparkGroupAlsoByWindowViaOutputBufferFn;
import org.apache.beam.runners.spark.translation.SparkPipelineTranslator;
import org.apache.beam.runners.spark.translation.TransformEvaluator;
import org.apache.beam.runners.spark.translation.TranslationUtils;
import org.apache.beam.runners.spark.util.ByteArray;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.runners.spark.util.SparkCompat;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.CombineWithContext;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.DoFnSchemaInformation;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.CombineFnUtil;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.AbstractIterator;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.FluentIterable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.spark.HashPartitioner;
import org.apache.spark.Partitioner;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.storage.StorageLevel;
import org.joda.time.Instant;
import scala.Tuple2;

public final class TransformTranslator {
    private static final Map<String, TransformEvaluator<?>> EVALUATORS = new HashMap();

    private TransformTranslator() {
    }

    private static <T> TransformEvaluator<Flatten.PCollections<T>> flattenPColl() {
        return new TransformEvaluator<Flatten.PCollections<T>>(){

            @Override
            public void evaluate(Flatten.PCollections<T> transform, EvaluationContext context) {
                JavaRDD unionRDD;
                Collection<PValue> pcs = context.getInputs((PTransform<?, ?>)transform).values();
                if (pcs.isEmpty()) {
                    unionRDD = context.getSparkContext().emptyRDD();
                } else {
                    JavaRDD[] rdds = new JavaRDD[pcs.size()];
                    int index = 0;
                    for (PValue pc : pcs) {
                        Preconditions.checkArgument((boolean)(pc instanceof PCollection), (String)"Flatten had non-PCollection value in input: %s of type %s", (Object)pc, (Object)pc.getClass().getSimpleName());
                        rdds[index] = ((BoundedDataset)context.borrowDataset(pc)).getRDD();
                        ++index;
                    }
                    unionRDD = context.getSparkContext().union(rdds);
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(unionRDD));
            }

            @Override
            public String toNativeString() {
                return "sparkContext.union(...)";
            }
        };
    }

    private static <K, V, W extends BoundedWindow> TransformEvaluator<GroupByKey<K, V>> groupByKey() {
        return new TransformEvaluator<GroupByKey<K, V>>(){

            @Override
            public void evaluate(GroupByKey<K, V> transform, EvaluationContext context) {
                JavaRDD groupedByKey;
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                Coder keyCoder = coder.getKeyCoder();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder.getValueCoder(), (Coder)windowFn.windowCoder());
                Partitioner partitioner = TransformTranslator.getPartitioner(context);
                if (GroupNonMergingWindowsFunctions.isEligibleForGroupByWindow(windowingStrategy)) {
                    groupedByKey = GroupNonMergingWindowsFunctions.groupByKeyAndWindow(inRDD, keyCoder, coder.getValueCoder(), windowingStrategy, partitioner);
                } else {
                    JavaRDD groupedByKeyOnly = GroupCombineFunctions.groupByKeyOnly(inRDD, keyCoder, wvCoder, partitioner);
                    groupedByKey = groupedByKeyOnly.flatMap(new SparkGroupAlsoByWindowViaOutputBufferFn(windowingStrategy, new TranslationUtils.InMemoryStateInternalsFactory(), SystemReduceFn.buffering((Coder)coder.getValueCoder()), context.getSerializableOptions()));
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(groupedByKey));
            }

            @Override
            public String toNativeString() {
                return "groupByKey()";
            }
        };
    }

    private static <K, InputT, OutputT> TransformEvaluator<Combine.GroupedValues<KV<K, InputT>, InputT, OutputT>> combineGrouped() {
        return new TransformEvaluator<Combine.GroupedValues<KV<K, InputT>, InputT, OutputT>>(){

            @Override
            public void evaluate(Combine.GroupedValues<KV<K, InputT>, InputT, OutputT> transform, EvaluationContext context) {
                CombineWithContext.CombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                SparkCombineFn sparkCombineFn = SparkCombineFn.keyed(combineFn, context.getSerializableOptions(), TranslationUtils.getSideInputs(transform.getSideInputs(), context), ((PCollection)context.getInput(transform)).getWindowingStrategy());
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                JavaRDD outRDD = inRDD.map((Function & Serializable)in -> WindowedValue.of((Object)KV.of((Object)((KV)in.getValue()).getKey(), (Object)combineFn.apply((Iterable)((KV)in.getValue()).getValue(), (CombineWithContext.Context)sparkCombineFn.ctxtForValue((WindowedValue<?>)in))), (Instant)in.getTimestamp(), (Collection)in.getWindows(), (PaneInfo)in.getPane()));
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRDD));
            }

            @Override
            public String toNativeString() {
                return "map(new <fn>())";
            }
        };
    }

    private static <InputT, AccumT, OutputT> TransformEvaluator<Combine.Globally<InputT, OutputT>> combineGlobally() {
        return new TransformEvaluator<Combine.Globally<InputT, OutputT>>(){

            @Override
            public void evaluate(Combine.Globally<InputT, OutputT> transform, EvaluationContext context) {
                JavaRDD outRdd;
                Coder aCoder;
                PCollection input = (PCollection)context.getInput(transform);
                Coder iCoder = ((PCollection)context.getInput(transform)).getCoder();
                Coder oCoder = ((PCollection)context.getOutput(transform)).getCoder();
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                CombineWithContext.CombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                WindowedValue.FullWindowedValueCoder wvoCoder = WindowedValue.FullWindowedValueCoder.of((Coder)oCoder, (Coder)windowingStrategy.getWindowFn().windowCoder());
                boolean hasDefault = transform.isInsertDefault();
                SparkCombineFn sparkCombineFn = SparkCombineFn.globally(combineFn, context.getSerializableOptions(), TranslationUtils.getSideInputs(transform.getSideInputs(), context), windowingStrategy);
                try {
                    aCoder = combineFn.getAccumulatorCoder(context.getPipeline().getCoderRegistry(), iCoder);
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException("Could not determine coder for accumulator", e);
                }
                JavaRDD inRdd = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                SparkCombineFn.WindowedAccumulator accumulated = GroupCombineFunctions.combineGlobally(inRdd, sparkCombineFn, aCoder, windowingStrategy);
                if (!accumulated.isEmpty()) {
                    Iterable output = sparkCombineFn.extractOutput(accumulated);
                    outRdd = context.getSparkContext().parallelize(CoderHelpers.toByteArrays(output, wvoCoder)).map(CoderHelpers.fromByteFunction(wvoCoder));
                } else {
                    JavaSparkContext jsc = new JavaSparkContext(inRdd.context());
                    if (hasDefault) {
                        Object defaultValue = combineFn.defaultValue();
                        outRdd = jsc.parallelize((List)Lists.newArrayList((Object[])new byte[][]{CoderHelpers.toByteArray(defaultValue, oCoder)})).map(CoderHelpers.fromByteFunction(oCoder)).map(WindowedValue::valueInGlobalWindow);
                    } else {
                        outRdd = jsc.emptyRDD();
                    }
                }
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRdd));
            }

            @Override
            public String toNativeString() {
                return "aggregate(..., new <fn>(), ...)";
            }
        };
    }

    private static <K, InputT, AccumT, OutputT> TransformEvaluator<Combine.PerKey<K, InputT, OutputT>> combinePerKey() {
        return new TransformEvaluator<Combine.PerKey<K, InputT, OutputT>>(){

            @Override
            public void evaluate(Combine.PerKey<K, InputT, OutputT> transform, EvaluationContext context) {
                Coder vaCoder;
                PCollection input = (PCollection)context.getInput(transform);
                KvCoder inputCoder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                CombineWithContext.CombineFnWithContext combineFn = CombineFnUtil.toFnWithContext((CombineFnBase.GlobalCombineFn)transform.getFn());
                WindowingStrategy windowingStrategy = input.getWindowingStrategy();
                Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs = TranslationUtils.getSideInputs(transform.getSideInputs(), context);
                SparkCombineFn sparkCombineFn = SparkCombineFn.keyed(combineFn, context.getSerializableOptions(), sideInputs, windowingStrategy);
                try {
                    vaCoder = combineFn.getAccumulatorCoder(context.getPipeline().getCoderRegistry(), inputCoder.getValueCoder());
                }
                catch (CannotProvideCoderException e) {
                    throw new IllegalStateException("Could not determine coder for accumulator", e);
                }
                JavaRDD inRdd = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                JavaPairRDD accumulatePerKey = GroupCombineFunctions.combinePerKey(inRdd, sparkCombineFn, inputCoder.getKeyCoder(), inputCoder.getValueCoder(), vaCoder, windowingStrategy);
                JavaPairRDD kwvs = SparkCompat.extractOutput(accumulatePerKey, sparkCombineFn);
                JavaRDD outRdd = kwvs.map(new TranslationUtils.FromPairFunction()).map(new TranslationUtils.ToKVByWindowInValueFunction());
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(outRdd));
            }

            @Override
            public String toNativeString() {
                return "combineByKey(..., new <fn>(), ...)";
            }
        };
    }

    private static <InputT, OutputT> TransformEvaluator<ParDo.MultiOutput<InputT, OutputT>> parDo() {
        return new TransformEvaluator<ParDo.MultiOutput<InputT, OutputT>>(){

            @Override
            public void evaluate(ParDo.MultiOutput<InputT, OutputT> transform, EvaluationContext context) {
                String stepName = context.getCurrentTransform().getFullName();
                DoFn doFn = transform.getFn();
                Preconditions.checkState((!DoFnSignatures.signatureForDoFn((DoFn)doFn).processElement().isSplittable() ? 1 : 0) != 0, (String)"Not expected to directly translate splittable DoFn, should have been overridden: %s", (Object)doFn);
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                MetricsContainerStepMapAccumulator metricsAccum = MetricsAccumulator.getInstance();
                Coder inputCoder = ((PCollection)context.getInput(transform)).getCoder();
                Map<TupleTag<?>, Coder<?>> outputCoders = context.getOutputCoders();
                DoFnSignature signature = DoFnSignatures.getSignature(transform.getFn().getClass());
                boolean stateful = signature.stateDeclarations().size() > 0 || signature.timerDeclarations().size() > 0;
                DoFnSchemaInformation doFnSchemaInformation = ParDoTranslation.getSchemaInformation(context.getCurrentTransform());
                Map sideInputMapping = ParDoTranslation.getSideInputMapping(context.getCurrentTransform());
                MultiDoFnFunction multiDoFnFunction = new MultiDoFnFunction(metricsAccum, stepName, doFn, context.getSerializableOptions(), transform.getMainOutputTag(), transform.getAdditionalOutputTags().getAll(), inputCoder, outputCoders, TranslationUtils.getSideInputs(transform.getSideInputs().values(), context), windowingStrategy, stateful, doFnSchemaInformation, sideInputMapping);
                JavaPairRDD all = stateful ? TransformTranslator.statefulParDoTransform((KvCoder)((PCollection)context.getInput(transform)).getCoder(), (Coder<? extends BoundedWindow>)windowingStrategy.getWindowFn().windowCoder(), inRDD, TransformTranslator.getPartitioner(context), multiDoFnFunction, signature.processElement().requiresTimeSortedInput()) : inRDD.mapPartitionsToPair(multiDoFnFunction);
                Map<TupleTag<?>, PValue> outputs = context.getOutputs((PTransform<?, ?>)transform);
                if (outputs.size() > 1) {
                    StorageLevel level = StorageLevel.fromString((String)context.storageLevel());
                    if (TranslationUtils.canAvoidRddSerialization(level)) {
                        all = all.persist(level);
                    } else {
                        Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap = TranslationUtils.getTupleTagCoders(outputs);
                        all = all.mapToPair(TranslationUtils.getTupleTagEncodeFunction(coderMap)).persist(level).mapToPair(TranslationUtils.getTupleTagDecodeFunction(coderMap));
                    }
                }
                for (Map.Entry<TupleTag<?>, PValue> output : outputs.entrySet()) {
                    JavaPairRDD filtered = all.filter(new TranslationUtils.TupleTagFilter(output.getKey()));
                    JavaRDD values = filtered.values();
                    context.putDataset(output.getValue(), new BoundedDataset(values));
                }
            }

            @Override
            public String toNativeString() {
                return "mapPartitions(new <fn>())";
            }
        };
    }

    private static <K, V, OutputT> JavaPairRDD<TupleTag<?>, WindowedValue<?>> statefulParDoTransform(KvCoder<K, V> kvCoder, Coder<? extends BoundedWindow> windowCoder, JavaRDD<WindowedValue<KV<K, V>>> kvInRDD, Partitioner partitioner, MultiDoFnFunction<KV<K, V>, OutputT> doFnFunction, boolean requiresSortedInput) {
        Coder keyCoder = kvCoder.getKeyCoder();
        WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)kvCoder.getValueCoder(), windowCoder);
        if (!requiresSortedInput) {
            return GroupCombineFunctions.groupByKeyOnly(kvInRDD, keyCoder, wvCoder, partitioner).map((Function & Serializable)input -> {
                Object key = input.getKey();
                Iterable value = (Iterable)input.getValue();
                return FluentIterable.from((Iterable)value).transform(windowedValue -> windowedValue.withValue((Object)KV.of((Object)key, (Object)windowedValue.getValue()))).iterator();
            }).flatMapToPair(doFnFunction);
        }
        JavaPairRDD pairRDD = kvInRDD.map(new ReifyTimestampsAndWindowsFunction()).mapToPair(TranslationUtils.toPairFunction()).mapToPair(CoderHelpers.toByteFunctionWithTs(keyCoder, wvCoder, (Function & Serializable)in -> ((WindowedValue)in._2()).getTimestamp()));
        JavaPairRDD sorted = pairRDD.repartitionAndSortWithinPartitions(TransformTranslator.keyPrefixPartitionerFrom(partitioner));
        return sorted.mapPartitionsToPair(TransformTranslator.wrapDoFnFromSortedRDD(doFnFunction, keyCoder, wvCoder));
    }

    private static Partitioner keyPrefixPartitionerFrom(final Partitioner partitioner) {
        return new Partitioner(){

            public int numPartitions() {
                return partitioner.numPartitions();
            }

            public int getPartition(Object o) {
                ByteArray b = (ByteArray)o;
                return partitioner.getPartition((Object)new ByteArray(Arrays.copyOfRange(b.getValue(), 0, b.getValue().length - 8)));
            }
        };
    }

    private static <K, V, OutputT> PairFlatMapFunction<Iterator<Tuple2<ByteArray, byte[]>>, TupleTag<?>, WindowedValue<?>> wrapDoFnFromSortedRDD(MultiDoFnFunction<KV<K, V>, OutputT> doFnFunction, Coder<K> keyCoder, Coder<WindowedValue<V>> wvCoder) {
        return (PairFlatMapFunction & Serializable)in -> {
            Iterator mappedGroups = Iterators.transform(TransformTranslator.splitBySameKey(in, keyCoder, wvCoder), group -> {
                try {
                    return doFnFunction.call((Iterator)group);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            });
            return TransformTranslator.flatten(mappedGroups);
        };
    }

    @VisibleForTesting
    static <T> Iterator<T> flatten(final Iterator<Iterator<T>> toFlatten) {
        return new AbstractIterator<T>(){
            @Nullable
            Iterator<T> current = null;

            protected T computeNext() {
                while (true) {
                    if (this.current == null) {
                        if (toFlatten.hasNext()) {
                            this.current = (Iterator)toFlatten.next();
                        } else {
                            return this.endOfData();
                        }
                    }
                    if (this.current.hasNext()) {
                        return this.current.next();
                    }
                    this.current = null;
                }
            }
        };
    }

    @VisibleForTesting
    static <K, V> Iterator<Iterator<WindowedValue<KV<K, V>>>> splitBySameKey(final Iterator<Tuple2<ByteArray, byte[]>> in, final Coder<K> keyCoder, final Coder<WindowedValue<V>> wvCoder) {
        return new AbstractIterator<Iterator<WindowedValue<KV<K, V>>>>(){
            @Nullable
            Tuple2<ByteArray, byte[]> read = null;

            protected Iterator<WindowedValue<KV<K, V>>> computeNext() {
                this.readNext();
                if (this.read != null) {
                    byte[] value = ((ByteArray)this.read._1()).getValue();
                    byte[] keyPart = Arrays.copyOfRange(value, 0, value.length - 8);
                    Object key = CoderHelpers.fromByteArray(keyPart, keyCoder);
                    return this.createIteratorForKey(keyPart, key);
                }
                return (Iterator)this.endOfData();
            }

            private void readNext() {
                if (this.read == null && in.hasNext()) {
                    this.read = (Tuple2)in.next();
                }
            }

            private void consumed() {
                this.read = null;
            }

            private Iterator<WindowedValue<KV<K, V>>> createIteratorForKey(final byte[] keyPart, final K key) {
                return new AbstractIterator<WindowedValue<KV<K, V>>>(){

                    protected WindowedValue<KV<K, V>> computeNext() {
                        byte[] value;
                        byte[] prefix;
                        this.readNext();
                        if (read != null && Arrays.equals(prefix = Arrays.copyOfRange(value = ((ByteArray)read._1()).getValue(), 0, value.length - 8), keyPart)) {
                            WindowedValue wv = (WindowedValue)CoderHelpers.fromByteArray((byte[])read._2(), wvCoder);
                            this.consumed();
                            return WindowedValue.of((Object)KV.of((Object)key, (Object)wv.getValue()), (Instant)wv.getTimestamp(), (Collection)wv.getWindows(), (PaneInfo)wv.getPane());
                        }
                        return (WindowedValue)this.endOfData();
                    }
                };
            }
        };
    }

    private static <T> TransformEvaluator<Read.Bounded<T>> readBounded() {
        return new TransformEvaluator<Read.Bounded<T>>(){

            @Override
            public void evaluate(Read.Bounded<T> transform, EvaluationContext context) {
                String stepName = context.getCurrentTransform().getFullName();
                JavaSparkContext jsc = context.getSparkContext();
                JavaRDD input = new SourceRDD.Bounded(jsc.sc(), transform.getSource(), context.getSerializableOptions(), stepName).toJavaRDD();
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(input));
            }

            @Override
            public String toNativeString() {
                return "sparkContext.<readFrom(<source>)>()";
            }
        };
    }

    private static <T, W extends BoundedWindow> TransformEvaluator<Window.Assign<T>> window() {
        return new TransformEvaluator<Window.Assign<T>>(){

            @Override
            public void evaluate(Window.Assign<T> transform, EvaluationContext context) {
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                if (TranslationUtils.skipAssignWindows(transform, context)) {
                    context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(inRDD));
                } else {
                    context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(inRDD.map(new SparkAssignWindowFn(transform.getWindowFn()))));
                }
            }

            @Override
            public String toNativeString() {
                return "map(new <windowFn>())";
            }
        };
    }

    private static <ReadT, WriteT> TransformEvaluator<View.CreatePCollectionView<ReadT, WriteT>> createPCollView() {
        return new TransformEvaluator<View.CreatePCollectionView<ReadT, WriteT>>(){

            @Override
            public void evaluate(View.CreatePCollectionView<ReadT, WriteT> transform, EvaluationContext context) {
                Iterable<WindowedValue<?>> iter = context.getWindowedValues((PCollection)context.getInput(transform));
                PCollectionView output = transform.getView();
                IterableCoder coderInternal = IterableCoder.of((Coder)WindowedValue.getFullCoder((Coder)output.getCoderInternal(), (Coder)output.getWindowingStrategyInternal().getWindowFn().windowCoder()));
                Iterable<WindowedValue<?>> iterCast = iter;
                context.putPView((PCollectionView<?>)output, iterCast, (Coder<Iterable<WindowedValue<?>>>)coderInternal);
            }

            @Override
            public String toNativeString() {
                return "<createPCollectionView>";
            }
        };
    }

    private static <K, V, W extends BoundedWindow> TransformEvaluator<Reshuffle<K, V>> reshuffle() {
        return new TransformEvaluator<Reshuffle<K, V>>(){

            @Override
            public void evaluate(Reshuffle<K, V> transform, EvaluationContext context) {
                JavaRDD inRDD = ((BoundedDataset)context.borrowDataset((PTransform<? extends PValue, ?>)transform)).getRDD();
                WindowingStrategy windowingStrategy = ((PCollection)context.getInput(transform)).getWindowingStrategy();
                KvCoder coder = (KvCoder)((PCollection)context.getInput(transform)).getCoder();
                WindowFn windowFn = windowingStrategy.getWindowFn();
                WindowedValue.FullWindowedValueCoder wvCoder = WindowedValue.FullWindowedValueCoder.of((Coder)coder, (Coder)windowFn.windowCoder());
                JavaRDD reshuffled = GroupCombineFunctions.reshuffle(inRDD, wvCoder);
                context.putDataset((PTransform<?, ? extends PValue>)transform, (Dataset)new BoundedDataset(reshuffled));
            }

            @Override
            public String toNativeString() {
                return "repartition(...)";
            }
        };
    }

    @Nullable
    private static Partitioner getPartitioner(EvaluationContext context) {
        Long bundleSize = ((SparkPipelineOptions)context.getSerializableOptions().get().as(SparkPipelineOptions.class)).getBundleSize();
        return bundleSize > 0L ? null : new HashPartitioner(context.getSparkContext().defaultParallelism().intValue());
    }

    @Nullable
    private static TransformEvaluator<?> getTranslator(PTransform<?, ?> transform) {
        String urn = PTransformTranslation.urnForTransformOrNull(transform);
        return urn == null ? null : EVALUATORS.get(urn);
    }

    static {
        EVALUATORS.put("beam:transform:read:v1", TransformTranslator.readBounded());
        EVALUATORS.put("beam:transform:pardo:v1", TransformTranslator.parDo());
        EVALUATORS.put("beam:transform:group_by_key:v1", TransformTranslator.groupByKey());
        EVALUATORS.put("beam:transform:combine_grouped_values:v1", TransformTranslator.combineGrouped());
        EVALUATORS.put("beam:transform:combine_globally:v1", TransformTranslator.combineGlobally());
        EVALUATORS.put("beam:transform:combine_per_key:v1", TransformTranslator.combinePerKey());
        EVALUATORS.put("beam:transform:flatten:v1", TransformTranslator.flattenPColl());
        EVALUATORS.put("beam:transform:create_view:v1", TransformTranslator.createPCollView());
        EVALUATORS.put("beam:transform:window_into:v1", TransformTranslator.window());
        EVALUATORS.put("beam:transform:reshuffle:v1", TransformTranslator.reshuffle());
    }

    public static class Translator
    implements SparkPipelineTranslator {
        @Override
        public boolean hasTranslation(PTransform<?, ?> transform) {
            return EVALUATORS.containsKey(PTransformTranslation.urnForTransformOrNull(transform));
        }

        @Override
        public <TransformT extends PTransform<?, ?>> TransformEvaluator<TransformT> translateBounded(PTransform<?, ?> transform) {
            TransformEvaluator transformEvaluator = TransformTranslator.getTranslator(transform);
            Preconditions.checkState((transformEvaluator != null ? 1 : 0) != 0, (String)"No TransformEvaluator registered for BOUNDED transform %s", transform);
            return transformEvaluator;
        }

        @Override
        public <TransformT extends PTransform<?, ?>> TransformEvaluator<TransformT> translateUnbounded(PTransform<?, ?> transform) {
            throw new IllegalStateException("TransformTranslator used in a batch pipeline only supports BOUNDED transforms.");
        }
    }
}

