/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.translation.batch;

import java.util.HashMap;
import java.util.Map;
import org.apache.beam.runners.spark.structuredstreaming.SparkStructuredStreamingPipelineOptions;
import org.apache.beam.runners.spark.structuredstreaming.translation.PipelineTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TransformTranslator;
import org.apache.beam.runners.spark.structuredstreaming.translation.TranslationContext;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.CombinePerKeyTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.CreatePCollectionViewTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.FlattenTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.GroupByKeyTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.ParDoTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.ReadSourceTranslatorBatch;
import org.apache.beam.runners.spark.structuredstreaming.translation.batch.WindowAssignTranslatorBatch;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.runners.TransformHierarchy;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.windowing.Window;

public class PipelineTranslatorBatch
extends PipelineTranslator {
    private static final Map<Class<? extends PTransform>, TransformTranslator> TRANSFORM_TRANSLATORS = new HashMap<Class<? extends PTransform>, TransformTranslator>();

    public PipelineTranslatorBatch(SparkStructuredStreamingPipelineOptions options) {
        this.translationContext = new TranslationContext(options);
    }

    @Override
    protected TransformTranslator<?> getTransformTranslator(TransformHierarchy.Node node) {
        PTransform transform = node.getTransform();
        if (transform == null) {
            return null;
        }
        return TRANSFORM_TRANSLATORS.get(transform.getClass());
    }

    static {
        TRANSFORM_TRANSLATORS.put(Combine.PerKey.class, new CombinePerKeyTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(GroupByKey.class, new GroupByKeyTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Flatten.PCollections.class, new FlattenTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Window.Assign.class, new WindowAssignTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(ParDo.MultiOutput.class, new ParDoTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(Read.Bounded.class, new ReadSourceTranslatorBatch());
        TRANSFORM_TRANSLATORS.put(View.CreatePCollectionView.class, new CreatePCollectionViewTranslatorBatch());
    }
}

