/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming.metrics;

import com.codahale.metrics.Metric;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.sdk.metrics.DistributionResult;
import org.apache.beam.sdk.metrics.GaugeResult;
import org.apache.beam.sdk.metrics.MetricKey;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.sdk.metrics.MetricQueryResults;
import org.apache.beam.sdk.metrics.MetricResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

class SparkBeamMetric
implements Metric {
    private static final String ILLEGAL_CHARACTERS = "[^A-Za-z0-9-]";

    SparkBeamMetric() {
    }

    Map<String, ?> renderAll() {
        HashMap<String, Object> metrics = new HashMap<String, Object>();
        MetricResults metricResults = MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)MetricsAccumulator.getInstance().value());
        MetricQueryResults metricQueryResults = metricResults.allMetrics();
        for (MetricResult metricResult : metricQueryResults.getCounters()) {
            metrics.put(this.renderName(metricResult), metricResult.getAttempted());
        }
        for (MetricResult metricResult : metricQueryResults.getDistributions()) {
            DistributionResult result = (DistributionResult)metricResult.getAttempted();
            metrics.put(this.renderName(metricResult) + ".count", result.getCount());
            metrics.put(this.renderName(metricResult) + ".sum", result.getSum());
            metrics.put(this.renderName(metricResult) + ".min", result.getMin());
            metrics.put(this.renderName(metricResult) + ".max", result.getMax());
            metrics.put(this.renderName(metricResult) + ".mean", result.getMean());
        }
        for (MetricResult metricResult : metricQueryResults.getGauges()) {
            metrics.put(this.renderName(metricResult), ((GaugeResult)metricResult.getAttempted()).getValue());
        }
        return metrics;
    }

    @VisibleForTesting
    String renderName(MetricResult<?> metricResult) {
        MetricKey key = metricResult.getKey();
        MetricName name = key.metricName();
        String step = key.stepName();
        ArrayList<String> pieces = new ArrayList<String>();
        if (step != null) {
            if ((step = step.replaceAll(ILLEGAL_CHARACTERS, "_")).endsWith("_")) {
                step = step.substring(0, step.length() - 1);
            }
            pieces.add(step);
        }
        pieces.addAll(ImmutableList.of((Object)name.getNamespace(), (Object)name.getName()).stream().map(str -> str.replaceAll(ILLEGAL_CHARACTERS, "_")).collect(Collectors.toList()));
        return String.join((CharSequence)".", pieces);
    }
}

