/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.structuredstreaming;

import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.beam.runners.core.metrics.MetricsContainerStepMap;
import org.apache.beam.runners.spark.structuredstreaming.metrics.MetricsAccumulator;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.PipelineResult;
import org.apache.beam.sdk.metrics.MetricResults;
import org.apache.beam.sdk.util.UserCodeException;
import org.apache.spark.SparkException;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.streaming.StreamingQuery;
import org.joda.time.Duration;

public class SparkStructuredStreamingPipelineResult
implements PipelineResult {
    final Future pipelineExecution;
    final SparkSession sparkSession;
    PipelineResult.State state;
    boolean isStreaming;

    SparkStructuredStreamingPipelineResult(Future<?> pipelineExecution, SparkSession sparkSession) {
        this.pipelineExecution = pipelineExecution;
        this.sparkSession = sparkSession;
        this.state = PipelineResult.State.RUNNING;
        this.isStreaming = false;
    }

    private static RuntimeException runtimeExceptionFrom(Throwable e) {
        return e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
    }

    private static RuntimeException beamExceptionFrom(Throwable e) {
        if (e instanceof SparkException) {
            if (e.getCause() != null && e.getCause() instanceof UserCodeException) {
                UserCodeException userException = (UserCodeException)e.getCause();
                return new Pipeline.PipelineExecutionException(userException.getCause());
            }
            if (e.getCause() != null) {
                return new Pipeline.PipelineExecutionException(e.getCause());
            }
        }
        return SparkStructuredStreamingPipelineResult.runtimeExceptionFrom(e);
    }

    protected void stop() {
        try {
            if (this.isStreaming) {
                for (StreamingQuery query : this.sparkSession.streams().active()) {
                    query.stop();
                }
            }
        }
        catch (Exception e) {
            throw SparkStructuredStreamingPipelineResult.beamExceptionFrom(e);
        }
        finally {
            this.sparkSession.stop();
            if (Objects.equals(this.state, PipelineResult.State.RUNNING)) {
                this.state = PipelineResult.State.STOPPED;
            }
        }
    }

    private PipelineResult.State awaitTermination(Duration duration) throws TimeoutException, ExecutionException, InterruptedException {
        this.pipelineExecution.get(duration.getMillis(), TimeUnit.MILLISECONDS);
        return PipelineResult.State.DONE;
    }

    public PipelineResult.State getState() {
        return this.state;
    }

    public PipelineResult.State waitUntilFinish() {
        return this.waitUntilFinish(Duration.millis((long)Long.MAX_VALUE));
    }

    public PipelineResult.State waitUntilFinish(Duration duration) {
        try {
            PipelineResult.State finishState = this.awaitTermination(duration);
            this.offerNewState(finishState);
        }
        catch (TimeoutException finishState) {
        }
        catch (ExecutionException e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkStructuredStreamingPipelineResult.beamExceptionFrom(e.getCause());
        }
        catch (Exception e) {
            this.offerNewState(PipelineResult.State.FAILED);
            throw SparkStructuredStreamingPipelineResult.beamExceptionFrom(e);
        }
        return this.state;
    }

    public MetricResults metrics() {
        return MetricsContainerStepMap.asAttemptedOnlyMetricResults((MetricsContainerStepMap)MetricsAccumulator.getInstance().value());
    }

    public PipelineResult.State cancel() throws IOException {
        this.offerNewState(PipelineResult.State.CANCELLED);
        return this.state;
    }

    private void offerNewState(PipelineResult.State newState) {
        PipelineResult.State oldState = this.state;
        this.state = newState;
        if (!oldState.isTerminal() && newState.isTerminal()) {
            this.stop();
        }
    }
}

