/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark;

import java.util.List;
import org.apache.beam.sdk.options.ApplicationNameOptions;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;

public interface SparkCommonPipelineOptions
extends PipelineOptions,
StreamingOptions,
ApplicationNameOptions {
    public static final String DEFAULT_MASTER_URL = "local[4]";

    @Description(value="The url of the spark master to connect to, (e.g. spark://host:port, local[4]).")
    @Default.String(value="local[4]")
    public String getSparkMaster();

    public void setSparkMaster(String var1);

    @Description(value="A checkpoint directory for streaming resilience, ignored in batch. For durability, a reliable filesystem such as HDFS/S3/GS is necessary.")
    @Default.InstanceFactory(value=TmpCheckpointDirFactory.class)
    public String getCheckpointDir();

    public void setCheckpointDir(String var1);

    @Description(value="Jar-Files to send to all workers and put on the classpath. The default value is all files from the classpath.")
    public List<String> getFilesToStage();

    public void setFilesToStage(List<String> var1);

    @Description(value="Enable/disable sending aggregator values to Spark's metric sinks")
    @Default.Boolean(value=true)
    public Boolean getEnableSparkMetricSinks();

    public void setEnableSparkMetricSinks(Boolean var1);

    public static class TmpCheckpointDirFactory
    implements DefaultValueFactory<String> {
        public String create(PipelineOptions options) {
            return "/tmp/" + options.getJobName();
        }
    }
}

