/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.beam.runners.core.InMemoryStateInternals;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.spark.SparkRunner;
import org.apache.beam.runners.spark.coders.CoderHelpers;
import org.apache.beam.runners.spark.repackaged.com.google.common.collect.ImmutableMap;
import org.apache.beam.runners.spark.repackaged.com.google.common.collect.Iterators;
import org.apache.beam.runners.spark.repackaged.com.google.common.collect.Maps;
import org.apache.beam.runners.spark.translation.EvaluationContext;
import org.apache.beam.runners.spark.translation.SparkKeyedCombineFn;
import org.apache.beam.runners.spark.translation.SparkPCollectionView;
import org.apache.beam.runners.spark.util.SideInputBroadcast;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.DoFnSignatures;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.WindowedValue;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.spark.api.java.function.PairFunction;
import org.apache.spark.api.java.function.VoidFunction;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.streaming.api.java.JavaDStream;
import org.apache.spark.streaming.api.java.JavaPairDStream;
import org.joda.time.Instant;
import scala.Tuple2;

public final class TranslationUtils {
    private TranslationUtils() {
    }

    public static <T, W extends BoundedWindow> boolean skipAssignWindows(Window.Assign<T> transform, EvaluationContext context) {
        WindowFn windowFn = transform.getWindowFn();
        return windowFn == null || ((PCollection)context.getInput(transform)).getWindowingStrategy().getWindowFn() instanceof GlobalWindows && windowFn instanceof GlobalWindows;
    }

    public static <T1, T2> JavaDStream<T2> dStreamValues(JavaPairDStream<T1, T2> pairDStream) {
        return pairDStream.map(new Function<Tuple2<T1, T2>, T2>(){

            public T2 call(Tuple2<T1, T2> v1) throws Exception {
                return v1._2();
            }
        });
    }

    public static <K, V> PairFunction<KV<K, V>, K, V> toPairFunction() {
        return new PairFunction<KV<K, V>, K, V>(){

            public Tuple2<K, V> call(KV<K, V> kv) {
                return new Tuple2(kv.getKey(), kv.getValue());
            }
        };
    }

    public static <K, V> PairFlatMapFunction<Iterator<KV<K, V>>, K, V> toPairFlatMapFunction() {
        return new PairFlatMapFunction<Iterator<KV<K, V>>, K, V>(){

            public Iterable<Tuple2<K, V>> call(Iterator<KV<K, V>> itr) {
                final Iterator outputItr = Iterators.transform(itr, new org.apache.beam.runners.spark.repackaged.com.google.common.base.Function<KV<K, V>, Tuple2<K, V>>(){

                    @Override
                    public Tuple2<K, V> apply(KV<K, V> kv) {
                        return new Tuple2(kv.getKey(), kv.getValue());
                    }
                });
                return new Iterable<Tuple2<K, V>>(){

                    @Override
                    public Iterator<Tuple2<K, V>> iterator() {
                        return outputItr;
                    }
                };
            }
        };
    }

    static <K, V> Function<Tuple2<K, V>, KV<K, V>> fromPairFunction() {
        return new Function<Tuple2<K, V>, KV<K, V>>(){

            public KV<K, V> call(Tuple2<K, V> t2) {
                return KV.of((Object)t2._1(), (Object)t2._2());
            }
        };
    }

    static <K, V> FlatMapFunction<Iterator<Tuple2<K, V>>, KV<K, V>> fromPairFlatMapFunction() {
        return new FlatMapFunction<Iterator<Tuple2<K, V>>, KV<K, V>>(){

            public Iterable<KV<K, V>> call(Iterator<Tuple2<K, V>> itr) {
                final Iterator outputItr = Iterators.transform(itr, new org.apache.beam.runners.spark.repackaged.com.google.common.base.Function<Tuple2<K, V>, KV<K, V>>(){

                    @Override
                    public KV<K, V> apply(Tuple2<K, V> t2) {
                        return KV.of((Object)t2._1(), (Object)t2._2());
                    }
                });
                return new Iterable<KV<K, V>>(){

                    @Override
                    public Iterator<KV<K, V>> iterator() {
                        return outputItr;
                    }
                };
            }
        };
    }

    public static <K, V> PairFunction<WindowedValue<KV<K, V>>, K, WindowedValue<KV<K, V>>> toPairByKeyInWindowedValue() {
        return new PairFunction<WindowedValue<KV<K, V>>, K, WindowedValue<KV<K, V>>>(){

            public Tuple2<K, WindowedValue<KV<K, V>>> call(WindowedValue<KV<K, V>> windowedKv) throws Exception {
                return new Tuple2(((KV)windowedKv.getValue()).getKey(), windowedKv);
            }
        };
    }

    static <K, V> Function<KV<K, WindowedValue<V>>, WindowedValue<KV<K, V>>> toKVByWindowInValue() {
        return new Function<KV<K, WindowedValue<V>>, WindowedValue<KV<K, V>>>(){

            public WindowedValue<KV<K, V>> call(KV<K, WindowedValue<V>> kv) throws Exception {
                WindowedValue wv = (WindowedValue)kv.getValue();
                return wv.withValue((Object)KV.of((Object)kv.getKey(), (Object)wv.getValue()));
            }
        };
    }

    static Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> getSideInputs(List<PCollectionView<?>> views, EvaluationContext context) {
        return TranslationUtils.getSideInputs(views, context.getSparkContext(), context.getPViews());
    }

    public static Map<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> getSideInputs(List<PCollectionView<?>> views, JavaSparkContext context, SparkPCollectionView pviews) {
        if (views == null) {
            return ImmutableMap.of();
        }
        HashMap<TupleTag<?>, KV<WindowingStrategy<?, ?>, SideInputBroadcast<?>>> sideInputs = Maps.newHashMap();
        for (PCollectionView<?> view : views) {
            SideInputBroadcast helper = pviews.getPCollectionView(view, context);
            WindowingStrategy windowingStrategy = view.getWindowingStrategyInternal();
            sideInputs.put(view.getTagInternal(), KV.of((Object)windowingStrategy, (Object)helper));
        }
        return sideInputs;
    }

    public static void rejectSplittable(DoFn<?, ?> doFn) {
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.processElement().isSplittable()) {
            throw new UnsupportedOperationException(String.format("%s does not support splittable DoFn: %s", SparkRunner.class.getSimpleName(), doFn));
        }
    }

    public static void rejectStateAndTimers(DoFn<?, ?> doFn) {
        DoFnSignature signature = DoFnSignatures.getSignature(doFn.getClass());
        if (signature.stateDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with state in the %s.", DoFn.StateId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
        if (signature.timerDeclarations().size() > 0) {
            throw new UnsupportedOperationException(String.format("Found %s annotations on %s, but %s cannot yet be used with timers in the %s.", DoFn.TimerId.class.getSimpleName(), doFn.getClass().getName(), DoFn.class.getSimpleName(), SparkRunner.class.getSimpleName()));
        }
    }

    public static <T> VoidFunction<T> emptyVoidFunction() {
        return new VoidFunction<T>(){

            public void call(T t) throws Exception {
            }
        };
    }

    public static <T, K, V> PairFlatMapFunction<Iterator<T>, K, V> pairFunctionToPairFlatMapFunction(final PairFunction<T, K, V> pairFunction) {
        return new PairFlatMapFunction<Iterator<T>, K, V>(){

            public Iterable<Tuple2<K, V>> call(Iterator<T> itr) throws Exception {
                final Iterator outputItr = Iterators.transform(itr, new org.apache.beam.runners.spark.repackaged.com.google.common.base.Function<T, Tuple2<K, V>>(){

                    @Override
                    public Tuple2<K, V> apply(T t) {
                        try {
                            return pairFunction.call(t);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                return new Iterable<Tuple2<K, V>>(){

                    @Override
                    public Iterator<Tuple2<K, V>> iterator() {
                        return outputItr;
                    }
                };
            }
        };
    }

    public static <InputT, OutputT> FlatMapFunction<Iterator<InputT>, OutputT> functionToFlatMapFunction(final Function<InputT, OutputT> func) {
        return new FlatMapFunction<Iterator<InputT>, OutputT>(){

            public Iterable<OutputT> call(Iterator<InputT> itr) throws Exception {
                final Iterator outputItr = Iterators.transform(itr, new org.apache.beam.runners.spark.repackaged.com.google.common.base.Function<InputT, OutputT>(){

                    @Override
                    public OutputT apply(InputT t) {
                        try {
                            return func.call(t);
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    }
                });
                return new Iterable<OutputT>(){

                    @Override
                    public Iterator<OutputT> iterator() {
                        return outputItr;
                    }
                };
            }
        };
    }

    public static Map<TupleTag<?>, Coder<WindowedValue<?>>> getTupleTagCoders(Map<TupleTag<?>, PValue> outputs) {
        HashMap coderMap = new HashMap(outputs.size());
        for (Map.Entry<TupleTag<?>, PValue> output : outputs.entrySet()) {
            PCollection pCollection = (PCollection)output.getValue();
            Coder coder = pCollection.getCoder();
            Coder wCoder = pCollection.getWindowingStrategy().getWindowFn().windowCoder();
            WindowedValue.FullWindowedValueCoder windowedValueCoder = WindowedValue.getFullCoder((Coder)coder, (Coder)wCoder);
            coderMap.put(output.getKey(), (Coder<WindowedValue<?>>)windowedValueCoder);
        }
        return coderMap;
    }

    public static PairFunction<Tuple2<TupleTag<?>, WindowedValue<?>>, TupleTag<?>, byte[]> getTupleTagEncodeFunction(final Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap) {
        return new PairFunction<Tuple2<TupleTag<?>, WindowedValue<?>>, TupleTag<?>, byte[]>(){

            public Tuple2<TupleTag<?>, byte[]> call(Tuple2<TupleTag<?>, WindowedValue<?>> tuple2) throws Exception {
                TupleTag tupleTag = (TupleTag)tuple2._1;
                WindowedValue windowedValue = (WindowedValue)tuple2._2;
                return new Tuple2((Object)tupleTag, (Object)CoderHelpers.toByteArray(windowedValue, (Coder)coderMap.get(tupleTag)));
            }
        };
    }

    public static PairFunction<Tuple2<TupleTag<?>, byte[]>, TupleTag<?>, WindowedValue<?>> getTupleTagDecodeFunction(final Map<TupleTag<?>, Coder<WindowedValue<?>>> coderMap) {
        return new PairFunction<Tuple2<TupleTag<?>, byte[]>, TupleTag<?>, WindowedValue<?>>(){

            public Tuple2<TupleTag<?>, WindowedValue<?>> call(Tuple2<TupleTag<?>, byte[]> tuple2) throws Exception {
                TupleTag tupleTag = (TupleTag)tuple2._1;
                byte[] windowedByteValue = (byte[])tuple2._2;
                return new Tuple2((Object)tupleTag, CoderHelpers.fromByteArray(windowedByteValue, (Coder)coderMap.get(tupleTag)));
            }
        };
    }

    public static boolean avoidRddSerialization(StorageLevel level) {
        return level.equals((Object)StorageLevel.MEMORY_ONLY()) || level.equals((Object)StorageLevel.MEMORY_ONLY_2());
    }

    public static final class TupleTagFilter<V>
    implements Function<Tuple2<TupleTag<V>, WindowedValue<?>>, Boolean> {
        private final TupleTag<V> tag;

        public TupleTagFilter(TupleTag<V> tag) {
            this.tag = tag;
        }

        public Boolean call(Tuple2<TupleTag<V>, WindowedValue<?>> input) {
            return this.tag.equals(input._1());
        }
    }

    public static class CombineGroupedValues<K, InputT, OutputT>
    implements Function<WindowedValue<KV<K, Iterable<InputT>>>, WindowedValue<KV<K, OutputT>>> {
        private final SparkKeyedCombineFn<K, InputT, ?, OutputT> fn;

        public CombineGroupedValues(SparkKeyedCombineFn<K, InputT, ?, OutputT> fn) {
            this.fn = fn;
        }

        public WindowedValue<KV<K, OutputT>> call(WindowedValue<KV<K, Iterable<InputT>>> windowedKv) throws Exception {
            return WindowedValue.of((Object)KV.of((Object)((KV)windowedKv.getValue()).getKey(), this.fn.apply(windowedKv)), (Instant)windowedKv.getTimestamp(), (Collection)windowedKv.getWindows(), (PaneInfo)windowedKv.getPane());
        }
    }

    static class InMemoryStateInternalsFactory<K>
    implements StateInternalsFactory<K>,
    Serializable {
        InMemoryStateInternalsFactory() {
        }

        public StateInternals stateInternalsForKey(K key) {
            return InMemoryStateInternals.forKey(key);
        }
    }
}

